/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.internal.listeners;

import eu.qimpress.ide.backbone.core.model.IQApplicationModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;

public class QImpressProjectlResourceChangedListener
implements IResourceChangeListener {
    private static final Logger logger = Logger.getLogger(QImpressProjectlResourceChangedListener.class);

    public void resourceChanged(IResourceChangeEvent event) {
        if (event.getType() == 4 || event.getType() == 2) {
            IResource resource = event.getResource();
            logger.trace((Object)("PRE_DELETE event received on resource " + resource));
            if (resource != null && resource.getType() == 4) {
                IProject project = (IProject)resource;
                this.handleProjectDelete(project);
            }
        }
    }

    protected void handleProjectDelete(IProject project) {
        try {
            IQApplicationModel qAppModel = QImpressApplicationModelManager.getManager().getQAppModel();
            IQProject qProject = qAppModel.getQProject(project);
            if (qProject != null) {
                logger.trace((Object)("PRE_DELETE event performed on Q-I project " + qProject));
                qAppModel.removeQProject(project);
            }
        }
        catch (RepositoryException e) {
            logger.error((Object)("Cannot close repository object for Q-I project: " + project), (Throwable)e);
        }
    }
}

