/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.internal;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;

public class ChainedLabelProvider
implements ILabelProvider {
    private ChainedLabelProvider next;
    private ILabelProvider labelProvider;

    public ChainedLabelProvider(ILabelProvider provider) {
        this(provider, null);
    }

    public ChainedLabelProvider(ILabelProvider provider, ChainedLabelProvider next) {
        this.labelProvider = provider;
        this.next = next;
    }

    public Image getImage(Object element) {
        Image result = this.labelProvider.getImage(element);
        if (result == null && this.next != null) {
            return this.next.getImage(element);
        }
        return result;
    }

    public String getText(Object element) {
        String result = this.labelProvider.getText(element);
        if ((result == null || "".equals(result)) && this.next != null) {
            return this.next.getText(element);
        }
        return result;
    }

    public void addListener(ILabelProviderListener listener) {
        this.labelProvider.addListener(listener);
        if (this.next != null) {
            this.next.addListener(listener);
        }
    }

    public void dispose() {
        if (this.next != null) {
            this.next.dispose();
        }
        this.labelProvider.dispose();
    }

    public boolean isLabelProperty(Object element, String property) {
        boolean result = this.labelProvider.isLabelProperty(element, property);
        if (!result && this.next != null) {
            return this.next.isLabelProperty(element, property);
        }
        return result;
    }

    public void removeListener(ILabelProviderListener listener) {
        if (this.next != null) {
            this.next.removeListener(listener);
        }
        this.labelProvider.removeListener(listener);
    }
}

