/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.part.ISetSelectionTarget;

public abstract class QElementSelectionDispatchAction
extends Action
implements ISelectionChangedListener {
    private IQElement selectedElement;
    private IStructuredSelection selection;
    private IWorkbenchSite workbenchSite;
    private ISetSelectionTarget selectionTarget;

    public QElementSelectionDispatchAction() {
        this(null, null);
    }

    public QElementSelectionDispatchAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget) {
        this.workbenchSite = site;
        this.selectionTarget = selectionTarget;
    }

    public QElementSelectionDispatchAction(IWorkbenchSite site) {
        this(site, null);
    }

    public void run() {
        switch (this.selectedElement.getElementType()) {
            case Q_ALTERNATIVE: {
                this.runInternal((IQAlternative)this.selectedElement);
                break;
            }
            case Q_REPOSITORY: {
                this.runInternal((IQRepository)this.selectedElement);
                break;
            }
            case Q_MODEL: {
                this.runInternal((IQModel)this.selectedElement);
            }
        }
    }

    protected void runInternal(IQRepository repository) {
    }

    protected void runInternal(IQAlternative alternative) {
    }

    protected void runInternal(IQModel model) {
    }

    protected Shell getShell() {
        return this.workbenchSite != null ? this.workbenchSite.getShell() : Display.getDefault().getActiveShell();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.selectedElement = null;
        if (selection instanceof IStructuredSelection) {
            Object o;
            this.selection = (IStructuredSelection)selection;
            if (((IStructuredSelection)selection).size() == 1 && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof IQElement) {
                this.selectedElement = (IQElement)((IStructuredSelection)selection).getFirstElement();
            }
        }
        this.postSelectionChanged(this.selectedElement);
    }

    protected void postSelectionChanged(IQElement element) {
    }

    protected IQElement getSelectedElement() {
        return this.selectedElement;
    }

    protected IWorkbenchSite getSite() {
        return this.workbenchSite;
    }

    protected void reportError(String msg, Throwable t) {
        MessageDialog.openError((Shell)this.getShell(), (String)"Error occured", (String)msg);
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    protected void unselect() {
        if (this.selectionTarget != null) {
            this.selectionTarget.selectReveal((ISelection)StructuredSelection.EMPTY);
        }
    }
}

