/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.ui.actions.QElementSelectionDispatchAction;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class ModelDefaultOpenAction
extends QElementSelectionDispatchAction {
    private static final Logger logger = Logger.getLogger(ModelDefaultOpenAction.class);

    public ModelDefaultOpenAction(IWorkbenchSite site) {
        super(site);
        this.setText("Open");
        this.setDescription("Open model default editor");
        this.setToolTipText("Open model default editor");
    }

    @Override
    protected void runInternal(IQModel model) {
        if (model != null) {
            try {
                IFile modelFile = (IFile)model.getCorrespondingResource();
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(modelFile.getName());
                page.openEditor((IEditorInput)new FileEditorInput(modelFile), desc.getId());
            }
            catch (PartInitException e) {
                logger.warn((Object)"Cannot open default editor for selected entity", (Throwable)e);
            }
        }
    }

    @Override
    protected void postSelectionChanged(IQElement element) {
        if (element != null && element instanceof IQModel) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

