/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.actions;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.actions.QElementSelectionDispatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class DeleteAlternativeAction
extends QElementSelectionDispatchAction {
    public DeleteAlternativeAction(IWorkbenchSite site) {
        super(site);
        this.setText("Delete alternative");
        this.setDescription("Delete selected alternative");
        this.setToolTipText("Deletes selected alternative with no children. Does not delete models in the alternative.");
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
    }

    @Override
    protected void runInternal(IQAlternative alternative) {
        if (this.canDelete(alternative)) {
            try {
                alternative.getRepository().deleteAlternative(alternative);
                QImpressApplicationModelManager.getManager().getQAppModel().fireRefresh();
            }
            catch (RepositoryException repositoryException) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Delete alternative", (String)"Cannot delete alternative");
                return;
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Delete alternative", (String)"Successfully deleted.");
        }
    }

    private boolean canDelete(IQAlternative alternative) {
        try {
            IQAlternative[] children = alternative.getRepository().getChildren(alternative);
            if (children.length != 0) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Delete alternative", (String)"Cannot delete - there are child alternatives.");
                return false;
            }
        }
        catch (RepositoryException repositoryException) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Delete alternative", (String)"Cannot obtain info about child alternatives");
            return false;
        }
        return MessageDialog.openQuestion((Shell)this.getShell(), (String)"Delete alternative", (String)("Do you want really delete alternative: " + alternative.getInfo().getDescription() + "?"));
    }

    @Override
    protected void postSelectionChanged(IQElement element) {
        if (element != null && element instanceof IQAlternative && !((IQAlternative)element).getInfo().isDefault()) {
            this.setEnabled(true);
        } else {
            this.setEnabled(false);
        }
    }
}

