/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.models;

import eu.qimpress.ide.backbone.core.model.AbstractApplicationModelChangeListener;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQApplicationModelChangeListener;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.models.resources.DefaultResourcesPlugin;
import eu.qimpress.ide.backbone.core.ui.decorators.QModelNeedsSaveDecorator;
import eu.qimpress.ide.backbone.core.ui.models.ShadowModelEditorAdapterFactory;
import eu.qimpress.ide.backbone.core.ui.models.adapters.QModelsComposedAdapterFactoryProvider;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class ShadowModelEditor
extends AbstractApplicationModelChangeListener
implements IEditingDomainProvider {
    private static final Logger logger = Logger.getLogger(ShadowModelEditor.class);
    protected Viewer viewer;
    protected IQAlternative alternative;
    protected AdapterFactoryEditingDomain editingDomain;
    private Map<URI, IQModel> modelCache = new HashMap<URI, IQModel>();

    public ShadowModelEditor(IQAlternative alternative) {
        this.alternative = alternative;
        this.initEditingDomain();
        this.loadDefaultModels();
        this.reloadModels(true);
        this.editingDomain.getResourceSet().getAdapterFactories().add((Object)new ShadowModelEditorAdapterFactory(this));
    }

    public void reloadModels(boolean refresh) {
        IQModel[] iQModelArray = this.alternative.getModels();
        int n = iQModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IQModel model = iQModelArray[n2];
            this.getModelResource(model, refresh);
            ++n2;
        }
    }

    protected void loadDefaultModels() {
        String[] stringArray = DefaultResourcesPlugin.getDefault().getAccesibleModels();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String modelName = stringArray[n2];
            URI modelURI = DefaultResourcesPlugin.getDefault().getModelURI(modelName);
            try {
                Resource res = this.editingDomain.getResourceSet().getResource(modelURI, true);
                res.load(null);
            }
            catch (Exception e) {
                logger.warn((Object)("Cannot load integrated model : " + modelURI), (Throwable)e);
            }
            ++n2;
        }
    }

    protected void initEditingDomain() {
        BasicCommandStack commandStack = new BasicCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                Command mostRecentCommand = ((CommandStack)event.getSource()).getMostRecentCommand();
                if (mostRecentCommand != null) {
                    Collection affectedObjects = mostRecentCommand.getAffectedObjects();
                    final ArrayList<EObject> affectedEObjects = new ArrayList<EObject>(3);
                    for (Object affectedObject : affectedObjects) {
                        if (!(affectedObject instanceof EObject)) continue;
                        affectedEObjects.add((EObject)affectedObject);
                    }
                    Display display = ShadowModelEditor.this.viewer != null ? ShadowModelEditor.this.viewer.getControl().getDisplay() : Display.getDefault();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            IQModel[] affectedModels = new IQModel[affectedEObjects.size()];
                            int c = 0;
                            for (EObject eo : affectedEObjects) {
                                try {
                                    URI modelURI = eo.eResource().getURI();
                                    ShadowModelEditor.this.markModifiedModelWorkspaceResource(modelURI);
                                    if (ShadowModelEditor.this.modelCache.containsKey(modelURI)) {
                                        affectedModels[c++] = (IQModel)ShadowModelEditor.this.modelCache.get(modelURI);
                                    }
                                }
                                catch (CoreException e) {
                                    logger.debug((Object)("Cannot mark resource as modified, eObject: " + eo), (Throwable)e);
                                }
                                ShadowModelEditor.this.fireModelsMarkerChanged(affectedModels);
                            }
                        }
                    });
                }
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)QModelsComposedAdapterFactoryProvider.getInstance().getAdapterFactory(), (CommandStack)commandStack);
    }

    private void markModifiedModelWorkspaceResource(URI modelURI) throws CoreException {
        Path path = new Path(modelURI.toPlatformString(true));
        IFile modelFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        modelFile.createMarker("eu.qimpress.ide.backbone.core.ui.QModelNeedsSave");
    }

    public Resource getModelResource(IQModel model) {
        return this.getModelResource(model, false);
    }

    public Resource getModelResource(IQModel model, boolean refresh) {
        IFile modelFile = (IFile)model.getCorrespondingResource();
        URI resourceURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toOSString(), (boolean)false);
        Resource res = this.editingDomain.getResourceSet().getResource(resourceURI, true);
        if (res.isLoaded() && refresh) {
            res.unload();
            try {
                res.load(null);
            }
            catch (IOException e) {
                logger.warn((Object)"Exception occured during model reloading ", (Throwable)e);
            }
        }
        this.cacheModel(resourceURI, model);
        return res;
    }

    public Resource createModelResource(IQModel qModel) {
        IFile modelFile = (IFile)qModel.getCorrespondingResource();
        URI resourceURI = URI.createPlatformResourceURI((String)modelFile.getFullPath().toOSString(), (boolean)false);
        Resource resource = this.editingDomain.getResourceSet().createResource(resourceURI);
        try {
            resource.save(null);
        }
        catch (IOException e) {
            logger.error((Object)("Cannot create file for qModel: " + qModel), (Throwable)e);
            resource = null;
        }
        this.cacheModel(resourceURI, qModel);
        return resource;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void dispose() {
        QImpressApplicationModelManager.getManager().getQAppModel().removeChangeListener((IQApplicationModelChangeListener)this);
    }

    public void modelCreated(IQModel[] models) {
        this.updateModels(models);
    }

    public void modelModified(IQModel[] models) {
        this.updateModels(models);
    }

    protected void updateModels(final IQModel[] models) {
        String thisAlternativeId = this.alternative.getInfo().getId();
        IQModel[] iQModelArray = models;
        int n = models.length;
        int n2 = 0;
        while (n2 < n) {
            IQModel model = iQModelArray[n2];
            IQAlternative alt = (IQAlternative)model.getParent();
            if (alt == null || alt.getInfo().getId().equals(thisAlternativeId)) {
                this.getModelResource(model, true);
            }
            ++n2;
        }
        Display display = this.viewer != null ? this.viewer.getControl().getDisplay() : Display.getDefault();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                IQModel[] iQModelArray = models;
                int n = models.length;
                int n2 = 0;
                while (n2 < n) {
                    IQModel rs = iQModelArray[n2];
                    try {
                        rs.getCorrespondingResource().deleteMarkers("eu.qimpress.ide.backbone.core.ui.QModelNeedsSave", true, 0);
                        ShadowModelEditor.this.fireModelsMarkerChanged(models);
                    }
                    catch (CoreException e) {
                        logger.debug((Object)("Cannot delete markers for model resource: " + rs), (Throwable)e);
                    }
                    ++n2;
                }
            }
        });
    }

    private void fireModelsMarkerChanged(IQModel[] models) {
        QModelNeedsSaveDecorator decorator = QModelNeedsSaveDecorator.getDecorator();
        if (decorator != null) {
            decorator.refresh(models);
        }
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void setViewer(Viewer viewer) {
        this.viewer = viewer;
    }

    private void cacheModel(URI uri, IQModel qModel) {
        this.modelCache.put(uri, qModel);
    }
}

