/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.realiability.launch;

import eu.qimpress.ide.analysis.realiability.launch.ReliabilityConfiguration;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesCheckBoxTreeViewer;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewerFactory;
import eu.qimpress.samm.usagemodel.Usage;
import eu.qimpress.samm.usagemodel.UsageScenario;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class MainLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private static final String TAB_NAME = "Analysis Input";
    private Text outputFolderText;
    private QAlternativesCheckBoxTreeViewer alternativesTreeViewer;
    private CheckboxTableViewer scenariosViewer;
    private ReliabilityConfiguration launchConfig = new ReliabilityConfiguration();

    public void createControl(Composite parent) {
        Composite topControl = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        topControl.setLayout((Layout)layout);
        this.setControl((Control)topControl);
        QAlternativesTreeViewerFactory viewerFactory = QAlternativesTreeViewerFactory.createTreeViewer((Composite)topControl, (QAlternativesTreeViewerFactory.SelectAlternativesEnum)QAlternativesTreeViewerFactory.SelectAlternativesEnum.SELECT_ONE);
        this.alternativesTreeViewer = (QAlternativesCheckBoxTreeViewer)viewerFactory.getTreeViewer();
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.minimumHeight = 200;
        gd.heightHint = 200;
        this.alternativesTreeViewer.getControl().setLayoutData((Object)gd);
        this.alternativesTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                List alts = MainLaunchConfigurationTab.this.alternativesTreeViewer.getSelectedAlternatives();
                if (alts == null || alts.size() == 0) {
                    MainLaunchConfigurationTab.this.launchConfig.resetAlernative();
                } else {
                    IQAlternative alt = MainLaunchConfigurationTab.this.alternativesTreeViewer.getFirstSelectedAlternative();
                    MainLaunchConfigurationTab.this.launchConfig.setAlternativeId(alt.getInfo().getId());
                }
                MainLaunchConfigurationTab.this.alternativeChanged();
                MainLaunchConfigurationTab.this.dialogChanged();
            }
        });
        Label lbl = new Label(topControl, 0);
        lbl.setText("Usage Scenario :");
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        lbl.setLayoutData((Object)gd);
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.minimumHeight = 100;
        gd.heightHint = 100;
        this.scenariosViewer = CheckboxTableViewer.newCheckList((Composite)topControl, (int)4);
        this.scenariosViewer.getControl().setLayoutData((Object)gd);
        this.scenariosViewer.setContentProvider((IContentProvider)new ArrayContentProvider(){

            public Object[] getElements(Object inputElement) {
                ReliabilityConfiguration conf;
                HashSet<UsageScenario> elements = new HashSet<UsageScenario>();
                if (inputElement instanceof ReliabilityConfiguration && (conf = (ReliabilityConfiguration)((Object)inputElement)).getUsageProfilesModel() != null) {
                    IQModel um = conf.getUsageProfilesModel();
                    Usage usage = (Usage)um.getTopLevelEObject();
                    for (UsageScenario us : usage.getUsageScenarios()) {
                        elements.add(us);
                    }
                }
                return elements.toArray();
            }
        });
        this.scenariosViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getColumnText(Object element, int columnIndex) {
                return ((UsageScenario)element).getName();
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }
        });
        this.scenariosViewer.setComparer(new IElementComparer(){

            public int hashCode(Object element) {
                if (element instanceof UsageScenario) {
                    UsageScenario us = (UsageScenario)element;
                    return us.getId().hashCode();
                }
                return element.hashCode();
            }

            public boolean equals(Object a, Object b) {
                if (a instanceof UsageScenario && b instanceof UsageScenario) {
                    UsageScenario usa = (UsageScenario)a;
                    UsageScenario usb = (UsageScenario)b;
                    return usa.getId().equals(usb.getId());
                }
                return a.equals(b);
            }
        });
        this.scenariosViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (!event.getChecked()) {
                    MainLaunchConfigurationTab.this.launchConfig.resetUsageScenario();
                } else {
                    UsageScenario scenario = (UsageScenario)event.getElement();
                    MainLaunchConfigurationTab.this.launchConfig.setUsageScenarioId(scenario.getId());
                }
                MainLaunchConfigurationTab.this.dialogChanged();
            }
        });
        this.scenariosViewer.setInput((Object)this.launchConfig);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        Label l = new Label(topControl, 0);
        l.setText("Output Folder");
        this.outputFolderText = new Text(topControl, 0);
        this.outputFolderText.setLayoutData((Object)gd);
        this.outputFolderText.setEditable(false);
    }

    public String getName() {
        return TAB_NAME;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.launchConfig.initializeFrom(configuration);
        }
        catch (CoreException e) {
            ErrorDialog d = new ErrorDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), "Configuration Error", "Error while configuring launch.", (IStatus)new Status(4, "eu.qimpress.ide.realiability", e.getMessage(), (Throwable)e), 0);
            d.open();
        }
        if (this.launchConfig.getAlternative() != null) {
            Object[] selection = new Object[]{this.launchConfig.getAlternative()};
            this.alternativesTreeViewer.setCheckedElements(selection);
            this.alternativeChanged();
            if (this.launchConfig.getUsageScenario() != null) {
                selection[0] = this.launchConfig.getUsageScenario();
                this.scenariosViewer.setCheckedElements(selection);
            }
        }
        this.dialogChanged();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.launchConfig.performApply(configuration);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.launchConfig.setDefaults();
        this.launchConfig.performApply(configuration);
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.updateLaunchConfigurationDialog();
    }

    private void dialogChanged() {
        this.updateStatus(this.launchConfig.getErrorMessage());
    }

    private void alternativeChanged() {
        this.scenariosViewer.refresh();
        IFolder outputFolder = this.launchConfig.getOutputFolder();
        this.outputFolderText.setText(outputFolder == null ? "" : outputFolder.toString());
    }
}

