/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.realiability.jobs.acceleo;

import de.uka.ipd.sdq.workflow.AbstractJobConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;

public class AcceleoTransformationJobConf
extends AbstractJobConfiguration {
    private Class<?> acceleoGeneratorClass;
    private String generatorMethodName;
    private URI inputModel;
    private IFolder outputFolder;
    private List<String> arguments = new ArrayList<String>();

    public Class<?> getAcceleoGeneratorClass() {
        return this.acceleoGeneratorClass;
    }

    public void setAcceleoGeneratorClass(Class<?> acceleoGeneratorClass) {
        this.acceleoGeneratorClass = acceleoGeneratorClass;
    }

    public URI getInputModel() {
        return this.inputModel;
    }

    public void setInputModel(URI inputModel) {
        this.inputModel = inputModel;
    }

    public IFolder getOutputFolder() {
        return this.outputFolder;
    }

    public void setOutputFolder(IFolder outputFolder) {
        this.outputFolder = outputFolder;
    }

    public List<String> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<String> arguments) {
        this.arguments = arguments;
    }

    public String getGeneratorMethodName() {
        return this.generatorMethodName;
    }

    public void setGeneratorMethodName(String generatorMethodName) {
        this.generatorMethodName = generatorMethodName;
    }

    public String getErrorMessage() {
        if (this.inputModel == null) {
            return "No input model specified";
        }
        if (this.outputFolder == null) {
            return "No output folder specified";
        }
        if (this.acceleoGeneratorClass == null) {
            return "No generator class specified";
        }
        if (this.generatorMethodName == null) {
            return "No generator method specified";
        }
        try {
            Class[] params = new Class[]{Monitor.class};
            this.acceleoGeneratorClass.getMethod(this.generatorMethodName, params);
        }
        catch (Exception e) {
            return "Invalid generator method specified : " + e.getMessage();
        }
        return null;
    }

    public void setDefaults() {
    }
}

