/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanediting.listeners;

import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.activator.Activator;
import de.fzi.kamp.ui.workplanediting.listeners.AddCompositeActivityListener;
import de.fzi.kamp.ui.workplanediting.listeners.DeleteActivityFromWorkplanListener;
import de.fzi.maintainabilitymodel.activity.adaptation.ChangeOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.adaptation.RemoveOperationImplementationActivity;
import de.fzi.maintainabilitymodel.activity.implementation.ImplementOperationActivity;
import de.fzi.maintainabilitymodel.workplan.Activity;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.osgi.framework.Bundle;

public class ContextMenuMouseListenerForWorkplanTree
extends MouseAdapter {
    private Tree tree;
    private IMainEditor mainEditor;
    private static final int RIGHT_MOUSE_BUTTON = 3;

    public ContextMenuMouseListenerForWorkplanTree(Tree tree, IMainEditor mainEditor) {
        this.tree = tree;
        this.mainEditor = mainEditor;
    }

    public void mouseDown(MouseEvent e) {
        if (e.button == 3 && e.widget instanceof Tree) {
            Menu rightButton = new Menu((Control)this.tree);
            MenuItem addItem = this.createMenuItem(rightButton, 64, "Add Refinement");
            addItem.addSelectionListener((SelectionListener)new AddCompositeActivityListener(this.tree, this.mainEditor));
            Activity task = (Activity)this.tree.getSelection()[0].getData();
            if (task instanceof ImplementOperationActivity || task instanceof ChangeOperationImplementationActivity || task instanceof RemoveOperationImplementationActivity) {
                addItem.setEnabled(false);
            }
            Status errorStatus = new Status(4, ((Object)((Object)this)).getClass().getName(), "TESTTESTTEST");
            Bundle bundle = Platform.getBundle((String)"de.fzi.kamp.ui");
            Platform.getLog((Bundle)bundle).log((IStatus)errorStatus);
            this.createMenuItem(rightButton, 2, "");
            MenuItem deleteItem = this.createMenuItem(rightButton, 64, "Delete Activity");
            deleteItem.addSelectionListener((SelectionListener)new DeleteActivityFromWorkplanListener((ICommandHandler)this.mainEditor, this.tree.getSelection()[0]));
            if (this.tree.getSelection()[0].getItemCount() > 0) {
                deleteItem.setEnabled(false);
            }
            this.tree.setMenu(rightButton);
        }
        super.mouseDown(e);
    }

    private MenuItem createMenuItem(Menu menu, int style, String text) {
        MenuItem item = new MenuItem(menu, style);
        item.setText(text);
        ImageDescriptor desc = Activator.getImageDescriptor("/icons/qimpress.gif");
        item.setImage(desc.createImage());
        return item;
    }
}

