/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanediting.adapter;

import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanediting.listeners.EditableTimeEffortModifyListener;
import de.fzi.kamp.ui.workplanediting.listeners.EffortEstimationEnterListener;
import de.fzi.kamp.ui.workplanediting.listeners.SetFocusAndEnterButtonListener;
import de.fzi.kamp.ui.workplanediting.providers.LowestAbstractionContentProvider;
import de.fzi.kamp.ui.workplanediting.providers.LowestAbstractionLabelProvider;
import de.fzi.kamp.ui.workplanediting.providers.WorkPlanContainmentContentProvider;
import de.fzi.kamp.ui.workplanediting.providers.WorkPlanFollowUpContentProvider;
import de.fzi.kamp.ui.workplanediting.providers.WorkPlanTreeLabelProvider;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class WorkPlanContentAdapter
extends EContentAdapter {
    private Tree tree;
    private List<Control> controls;
    private TreeViewer treeViewer;
    private ICommandHandler commandHandler;

    public WorkPlanContentAdapter(Tree tree, ICommandHandler commandHandler) {
        this.tree = tree;
        this.treeViewer = new TreeViewer(tree);
        this.controls = new LinkedList<Control>();
        this.commandHandler = commandHandler;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
    }

    public void update(Workplan workplan, boolean followUp, final boolean isEditableEffort, boolean lowestAbstraction) {
        if (!this.controls.isEmpty()) {
            for (Control control : this.controls) {
                control.dispose();
            }
            this.controls = new LinkedList<Control>();
        }
        if (lowestAbstraction) {
            this.treeViewer.setContentProvider((IContentProvider)new LowestAbstractionContentProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new LowestAbstractionLabelProvider());
        } else {
            if (followUp) {
                this.treeViewer.setContentProvider((IContentProvider)new WorkPlanFollowUpContentProvider());
            } else {
                this.treeViewer.setContentProvider((IContentProvider)new WorkPlanContainmentContentProvider());
            }
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkPlanTreeLabelProvider());
        }
        this.treeViewer.setInput((Object)workplan);
        this.treeViewer.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                WorkPlanContentAdapter.this.updateOrPackColumns(isEditableEffort);
            }

            public void treeExpanded(TreeExpansionEvent event) {
                WorkPlanContentAdapter.this.updateItemEditors(false);
            }
        });
        this.treeViewer.expandAll();
        this.updateOrPackColumns(isEditableEffort);
        if (isEditableEffort) {
            this.updateItemEditors(true);
        }
        this.blankOutColumns();
    }

    private void updateOrPackColumns(boolean isEditableEffort) {
        int i = 0;
        while (i < this.tree.getColumnCount()) {
            if (!(isEditableEffort || i != 7 && i != 8 && i != 2 && i != 4 && i != 3)) {
                this.tree.getColumns()[i].setWidth(0);
                this.tree.getColumns()[i].setResizable(false);
            } else {
                this.tree.getColumns()[i].pack();
            }
            ++i;
        }
        this.tree.getColumn(9).setWidth(0);
        this.tree.getColumn(9).setResizable(false);
    }

    private void updateItemEditors(boolean doFirstLevel) {
        TreeEditor editor1 = new TreeEditor(this.tree);
        if (editor1.getEditor() != null) {
            editor1.getEditor().dispose();
        }
        TreeItem[] treeItemArray = this.tree.getItems();
        int n = treeItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (doFirstLevel) {
                this.createEditableTextfield(item);
            }
            this.updateItemEditorsOfSubItems(item);
            ++n2;
        }
        treeItemArray = this.tree.getColumns();
        n = treeItemArray.length;
        n2 = 0;
        while (n2 < n) {
            TreeItem column = treeItemArray[n2];
            if (column.getText() != "Developer Structure") {
                column.pack();
            }
            ++n2;
        }
        this.tree.getColumn(6).setAlignment(0x1000000);
        this.tree.getColumn(7).setAlignment(0x1000000);
        this.tree.getColumn(8).setAlignment(0x1000000);
    }

    private void updateItemEditorsOfSubItems(TreeItem item) {
        if (item.getItems().length > 0) {
            TreeItem[] treeItemArray = item.getItems();
            int n = treeItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeItem child = treeItemArray[n2];
                if (child.getData() != null) {
                    this.createEditableTextfield(child);
                }
                if (child.getItems().length > 0) {
                    this.updateItemEditorsOfSubItems(child);
                }
                ++n2;
            }
        }
    }

    private void createEditableTextfield(TreeItem item) {
        if (!(item.getData() instanceof CompositeTask)) {
            item.setFont(new SurfaceFactory().getFontStyle().get("answerStyle"));
            Text text = new Text((Composite)this.tree, 0x1000004);
            this.controls.add((Control)text);
            Activity activity = (Activity)item.getData();
            text.addModifyListener((ModifyListener)new EditableTimeEffortModifyListener(activity, text, this.tree.getDisplay(), this.treeViewer, item, this.commandHandler));
            text.addKeyListener((KeyListener)new EffortEstimationEnterListener(this.controls, text));
            text.addMouseListener((MouseListener)new SetFocusAndEnterButtonListener(text));
            this.createEditor((Control)text, item, 7);
        }
    }

    private void createEditor(Control control, TreeItem item, int column) {
        TreeEditor editor = new TreeEditor(this.tree);
        if (control instanceof Text) {
            if (item.getData() instanceof Activity) {
                ((Text)control).setText(Double.toString(((Activity)item.getData()).getWorkTimeEstimate()));
            } else {
                ((Text)control).setText("edit");
            }
        }
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(control, item, column);
    }

    public TreeViewer getTreeViewer(Tree tree) {
        if (this.treeViewer.getTree() == tree) {
            return this.treeViewer;
        }
        return null;
    }

    private void blankOutColumns() {
        TreeColumn[] treeColumnArray = this.tree.getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TreeColumn column = treeColumnArray[n2];
            if (column.getText().equals("Component") || column.getText().equals("Interface Port") || column.getText().equals("Operation")) {
                column.setWidth(0);
                column.setResizable(false);
            }
            ++n2;
        }
    }
}

