/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.OperationSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.listeners.OperationCheckBoxListener;
import de.fzi.kamp.ui.workplanderivation.listeners.OperationComboListener;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.DeriveWorkPlanWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.InitialForkPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectComponentActivitiesWizardPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacesPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationSelectionContainer;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SelectOperationPage
extends WizardPage {
    private SurfaceFactory factory;
    private Composite container;
    private boolean justChange;
    private CompositeTaskDerivationContainer workplanContainer;
    private Map<OperationSelectionContainer, OperationSelectionContainerDecorator> container2decoratorMap;

    protected SelectOperationPage(CompositeTaskDerivationContainer workplanContainer) {
        super("");
        this.setTitle("Select Operation Activities");
        this.setDescription("Please detail your change description on operation level:\nWhich operations are affected?");
        this.factory = new SurfaceFactory();
        this.workplanContainer = workplanContainer;
        this.container2decoratorMap = new HashMap<OperationSelectionContainer, OperationSelectionContainerDecorator>();
        this.justChange = false;
    }

    public void createControl(Composite parent) {
        this.container = this.factory.createCompositeOrGroup(parent, 1, 4, 1, 0, false, 0, 0);
        this.createTable();
        this.setControl((Control)this.container);
    }

    public void createTable() {
        Table table = this.factory.createTable(this.container, 1, new String[]{"!", "InterfacePort Name", "Operations", "Basic Activity"}, 4, true);
        this.factory.setGrabVerticalForGridData((Control)table, true, 4);
        this.factory.setControlHeight((Control)table, 200);
        if (((InitialForkPage)this.getWizard().getPage("forkPage")).getFirstPage() instanceof SelectComponentActivitiesWizardPage) {
            if (this.workplanContainer.getLastShownComponentContainers().size() > 0) {
                for (ComponentSelectionContainer selectedComponent : this.workplanContainer.getLastShownComponentContainers()) {
                    if (selectedComponent.getRefinements().isEmpty() || !selectedComponent.isSelected()) continue;
                    for (InterfacePortSelectionContainer refinement : selectedComponent.getRefinements()) {
                        if (!refinement.isSelected()) continue;
                        this.createTableForInterface(refinement, table);
                    }
                }
            }
        } else {
            this.justChange = true;
            if (((InitialForkPage)this.getWizard().getPage("forkPage")).getFirstPage() instanceof SelectInterfacesPage) {
                if (this.workplanContainer.getLastShownInterfaceContainers().size() > 0) {
                    for (InterfaceSelectionContainer selectedInterface : this.workplanContainer.getLastShownInterfaceContainers()) {
                        if (selectedInterface.getFollowups().isEmpty() || !selectedInterface.isSelected()) continue;
                        for (InterfacePortSelectionContainer followUp : selectedInterface.getFollowups()) {
                            if (!followUp.isSelected()) continue;
                            this.createTableForInterface(followUp, table);
                        }
                    }
                }
            } else if (this.workplanContainer.getLastShownDataTypeSelectionContainers().size() > 0) {
                for (DataTypeSelectionContainer datatypeContainer : this.workplanContainer.getLastShownDataTypeSelectionContainers()) {
                    if (!datatypeContainer.isSelected()) continue;
                    for (InterfaceSelectionContainer ifaceContainer : datatypeContainer.getSelectedInterfaceSelectionContainers()) {
                        if (ifaceContainer.getFollowups().isEmpty() || !ifaceContainer.isSelected()) continue;
                        for (InterfacePortSelectionContainer ifacePortContainer : ifaceContainer.getFollowups()) {
                            if (!ifaceContainer.isSelected()) continue;
                            this.createTableForInterface(ifacePortContainer, table);
                        }
                    }
                }
            }
        }
        this.getShell().pack();
    }

    private void createTableForInterface(InterfacePortSelectionContainer interfacePortContainer, Table table) {
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        TableItem item = new TableItem(table, 0);
        item.setText(1, interfacePortContainer.getInterfaceport().getName());
        if (interfacePortContainer.getBasicActivity() != null) {
            switch (interfacePortContainer.getBasicActivity()) {
                case ADD: {
                    item.setText(3, BasicActivity.ADD.toString());
                    break;
                }
                case CHANGE: {
                    item.setText(3, BasicActivity.CHANGE.toString());
                    break;
                }
                case REMOVE: {
                    item.setText(3, BasicActivity.REMOVE.toString());
                    break;
                }
                default: {
                    item.setText(3, "");
                }
            }
        }
        for (OperationSelectionContainer operationContainer : interfacePortContainer.getRefinements()) {
            TableItem itemForAssociatedOperation = new TableItem(table, 0);
            itemForAssociatedOperation.setFont(this.factory.getFontStyle().get("answerStyle"));
            if (operationContainer.getOperation() != null) {
                itemForAssociatedOperation.setText(2, operationContainer.getOperation().getName());
            }
            if (interfacePortContainer.getBasicActivity() != BasicActivity.REMOVE) {
                Button checkbox = new Button((Composite)table, 32);
                this.factory.setControlWithTableEditor(table, itemForAssociatedOperation, (Control)checkbox, 0);
                checkbox.setToolTipText("Check this, if this operation is affected within the current composite activity.");
                Combo combo = null;
                if (this.justChange) {
                    combo = this.factory.createCombo(itemForAssociatedOperation, new String[]{BasicActivity.CHANGE.toString()}, table, 3);
                } else {
                    if (interfacePortContainer.getBasicActivity() == BasicActivity.ADD) {
                        combo = this.factory.createCombo(itemForAssociatedOperation, new String[]{BasicActivity.ADD.toString()}, table, 3);
                    }
                    if (interfacePortContainer.getBasicActivity() == BasicActivity.CHANGE) {
                        combo = this.factory.createCombo(itemForAssociatedOperation, new String[]{BasicActivity.ADD.toString(), BasicActivity.CHANGE.toString(), BasicActivity.REMOVE.toString()}, table, 3);
                    }
                }
                combo.setToolTipText("Please specify the basic activity for this operation.");
                combo.setEnabled(false);
                OperationSelectionContainerDecorator decorator = this.createDecorator(operationContainer, itemForAssociatedOperation, checkbox, combo);
                if (operationContainer.isSelected()) {
                    checkbox.setSelection(true);
                    checkbox.setEnabled(false);
                    combo.setText(combo.getItem(((DeriveWorkPlanWizard)this.getWizard()).getSelectionIndex((AbstractContainer)operationContainer)));
                }
                checkbox.addSelectionListener((SelectionListener)new OperationCheckBoxListener(this, decorator, interfacePortContainer));
                combo.addSelectionListener((SelectionListener)new OperationComboListener(this, decorator, this.justChange));
                continue;
            }
            Button placeboCheckbox = new Button((Composite)table, 32);
            placeboCheckbox.setEnabled(false);
            placeboCheckbox.setToolTipText("It is unnecessary to choose further activities if the parent is removed");
            this.factory.setControlWithTableEditor(table, itemForAssociatedOperation, (Control)placeboCheckbox, 0);
            Combo placeboCombo = new Combo((Composite)table, 8);
            placeboCombo.setText("Nothing to choose");
            placeboCombo.setEnabled(false);
            this.factory.setControlWithTableEditor(table, itemForAssociatedOperation, (Control)placeboCombo, 3);
            if (!operationContainer.isSelected()) continue;
            placeboCheckbox.setSelection(true);
            placeboCombo.setText(placeboCombo.getItem(((DeriveWorkPlanWizard)this.getWizard()).getSelectionIndex((AbstractContainer)operationContainer)));
        }
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.setPageComplete(this.checkedAndSelected());
    }

    private OperationSelectionContainerDecorator createDecorator(OperationSelectionContainer operationContainer, TableItem itemForAssociatedOperation, Button checkbox, Combo combo) {
        OperationSelectionContainerDecorator decorator = new OperationSelectionContainerDecorator(operationContainer);
        this.container2decoratorMap.put(operationContainer, decorator);
        itemForAssociatedOperation.setData((Object)operationContainer);
        decorator.setCheckbox(checkbox);
        decorator.setCombo(combo);
        decorator.setTableItem(itemForAssociatedOperation);
        this.workplanContainer.getLastShownOperationSelectionContainer().add((Object)operationContainer);
        return decorator;
    }

    public boolean checkedAndSelected() {
        this.setErrorMessage(null);
        EList selectedItems = this.workplanContainer.getLastShownOperationSelectionContainer();
        if (selectedItems.size() < 1) {
            return false;
        }
        boolean checkedAndSelected = true;
        for (OperationSelectionContainer abstractContainer : selectedItems) {
            OperationSelectionContainerDecorator container = this.container2decoratorMap.get(abstractContainer);
            if (abstractContainer.getBasicActivity() == null) {
                container.getTableItem().setBackground(4, new Color((Device)this.getContainer().getShell().getDisplay(), 255, 0, 0));
                this.setErrorMessage("If you check a component, you have to chose a basic activity");
                checkedAndSelected = false;
                continue;
            }
            container.getTableItem().setBackground(4, new Color((Device)this.getContainer().getShell().getDisplay(), 255, 255, 255));
        }
        return checkedAndSelected;
    }
}

