/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.InterfacePortSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.listeners.IPDatatypesCheckboxListener;
import de.fzi.kamp.ui.workplanderivation.listeners.InterfacePortForDataTypeComboListener;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SelectInterfacePortForDatatypesPage
extends WizardPage {
    private CompositeTaskDerivationContainer workplanContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private SurfaceFactory factory;
    private Composite container;
    private Map<InterfacePortSelectionContainer, InterfacePortSelectionContainerDecorator> container2decoratorMap;

    protected SelectInterfacePortForDatatypesPage(CompositeTaskDerivationContainer workplanContainer) {
        super("interfacePortAfterDatatypes");
        this.workplanContainer = workplanContainer;
        this.workplanDerivationManager = new WorkplanDerivationManager(workplanContainer);
        this.factory = new SurfaceFactory();
        this.container2decoratorMap = new HashMap<InterfacePortSelectionContainer, InterfacePortSelectionContainerDecorator>();
    }

    public void createControl(Composite parent) {
        this.container = this.factory.createCompositeOrGroup(parent, 1, 4, 1, 0, false, 0, 0);
        this.setControl((Control)this.container);
        this.createTableForDatatypes();
        this.setTitle("Select Interface Port Activities");
        this.setDescription("Please check the interface ports which are affected\nby the changes in the previously selected interfaces.");
        this.getShell().pack();
    }

    private void createTableForDatatypes() {
        Table table = this.factory.createTable(this.container, 1, new String[]{"!", "Interface Name", "Interface Port", "Type", "Basic Activity"}, 4, true);
        this.factory.setGrabVerticalForGridData((Control)table, true, 4);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        for (DataTypeSelectionContainer datatypeContainer : this.workplanContainer.getLastShownDataTypeSelectionContainers()) {
            if (!datatypeContainer.isSelected()) continue;
            for (InterfaceSelectionContainer ifaceContainer : datatypeContainer.getSelectedInterfaceSelectionContainers()) {
                if (!ifaceContainer.isSelected()) continue;
                this.createItemForInterface(ifaceContainer, table);
            }
        }
    }

    private void createItemForInterface(InterfaceSelectionContainer ifaceContainer, Table table) {
        for (InterfacePortSelectionContainer interfacePortContainer : ifaceContainer.getFollowups()) {
            this.createItemForInterfacePort(interfacePortContainer, table, ifaceContainer);
        }
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        table.pack();
        this.setPageComplete(this.checkedAndSelected());
    }

    private void createItemForInterfacePort(InterfacePortSelectionContainer interfacePortContainer, Table table, InterfaceSelectionContainer ifaceContainer) {
        TableItem itemForAssociatedInterface = new TableItem(table, 0);
        itemForAssociatedInterface.setFont(this.factory.getFontStyle().get("answerStyle"));
        itemForAssociatedInterface.setText(1, interfacePortContainer.getInterfaceSelectionContainer().getReferencedInterface().getName());
        itemForAssociatedInterface.setText(2, String.valueOf(interfacePortContainer.getParent().getComponenttype().getName()) + "." + interfacePortContainer.getInterfaceport().getName());
        Button checkbox = new Button((Composite)table, 32);
        this.factory.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)checkbox, 0);
        checkbox.setToolTipText("Check this, if the interface port is affected within the current composite activity.");
        Combo combo = this.factory.createCombo(itemForAssociatedInterface, new String[]{BasicActivity.CHANGE.toString(), BasicActivity.REMOVE.toString()}, table, 4);
        combo.setEnabled(false);
        combo.setToolTipText("Please specify the basic activity for this interface port.");
        this.factory.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)combo, 4);
        if (interfacePortContainer.getInterfaceport().isRequired()) {
            itemForAssociatedInterface.setText(3, "required");
        } else {
            itemForAssociatedInterface.setText(3, "provided");
        }
        InterfacePortSelectionContainerDecorator decorator = this.createDecorator(interfacePortContainer, itemForAssociatedInterface, checkbox, combo);
        checkbox.addSelectionListener((SelectionListener)new IPDatatypesCheckboxListener(decorator, ifaceContainer));
        combo.addSelectionListener((SelectionListener)new InterfacePortForDataTypeComboListener(this, decorator));
        if (interfacePortContainer.isSelected()) {
            checkbox.setSelection(true);
            checkbox.setEnabled(false);
            combo.setText(combo.getItem(0));
        }
    }

    public boolean checkedAndSelected() {
        this.setErrorMessage(null);
        List selectedItems = this.workplanDerivationManager.getSelectedInterfacePorts();
        if (selectedItems.size() < 1) {
            return false;
        }
        boolean checkedAndSelected = true;
        for (InterfacePortSelectionContainer abstractContainer : selectedItems) {
            if (abstractContainer.getBasicActivity() == BasicActivity.REMOVE) {
                return true;
            }
            InterfacePortSelectionContainerDecorator decorator = this.container2decoratorMap.get(abstractContainer);
            if (decorator == null) continue;
            if (abstractContainer.getBasicActivity() == null) {
                decorator.getTableItem().setBackground(4, new Color((Device)this.getContainer().getShell().getDisplay(), 255, 0, 0));
                this.setErrorMessage("If you check a component, you have to chose a basic activity");
                checkedAndSelected = false;
                continue;
            }
            decorator.getTableItem().setBackground(4, new Color((Device)this.getContainer().getShell().getDisplay(), 255, 255, 255));
        }
        return checkedAndSelected;
    }

    private InterfacePortSelectionContainerDecorator createDecorator(InterfacePortSelectionContainer ifaceContainer, TableItem itemForAssociatedInterface, Button checkbox, Combo combo) {
        InterfacePortSelectionContainerDecorator decorator = new InterfacePortSelectionContainerDecorator(ifaceContainer);
        this.container2decoratorMap.put(ifaceContainer, decorator);
        itemForAssociatedInterface.setData((Object)ifaceContainer);
        decorator.setCheckbox(checkbox);
        decorator.setCombo(combo);
        decorator.setTableItem(itemForAssociatedInterface);
        this.workplanDerivationManager.addShowedInterfacePort(ifaceContainer);
        return decorator;
    }
}

