/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.ComponentSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.listeners.ComponentCheckBoxListener;
import de.fzi.kamp.ui.workplanderivation.listeners.ComponentComboListener;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SelectComponentActivitiesWizardPage
extends WizardPage {
    private SurfaceFactory factory;
    private Table table;
    private CompositeTaskDerivationContainer workplanContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private Map<ComponentSelectionContainer, ComponentSelectionContainerDecorator> container2decoratorMap;

    public SelectComponentActivitiesWizardPage(CompositeTaskDerivationContainer workplanContainer) {
        super("compPage");
        this.setTitle("Select Component Activities");
        this.setDescription("Please mark the components which are affected by changes. For marked components please specify what basic activity (ADD, CHANGE, or REMOVE) is performed.");
        this.container2decoratorMap = new HashMap<ComponentSelectionContainer, ComponentSelectionContainerDecorator>();
        this.factory = new SurfaceFactory();
        this.workplanContainer = workplanContainer;
        this.workplanDerivationManager = new WorkplanDerivationManager(workplanContainer);
    }

    public void createControl(Composite parent) {
        Composite container = this.factory.createCompositeOrGroup(parent, 1, 4, 1, 0, false, 0, 0);
        this.setControl((Control)container);
        this.table = this.factory.createTable(container, 1, new String[]{"!", "Component", "Basic Activity"}, 4, true);
        this.factory.setGrabVerticalForGridData((Control)this.table, true, 4);
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        for (ComponentSelectionContainer componentContainer : this.workplanContainer.getComponentContainers()) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(1, componentContainer.getComponenttype().getName());
            item.setFont(this.factory.getFontStyle().get("answerStyle"));
            this.table.getColumn(1).pack();
            this.table.update();
            Button checkbox = new Button((Composite)this.table, 32);
            checkbox.setSelection(false);
            this.setControlWithEditor(this.table, item, (Control)checkbox, 0);
            checkbox.setToolTipText("Check this, if the component is affected within the current composite activity.");
            this.table.getColumn(0).pack();
            this.table.update();
            Combo combo = this.configureBasicActivityCombo(item);
            combo.setToolTipText("Please specify the basic activity regarding this component.");
            this.table.getColumn(2).pack();
            this.table.redraw();
            this.table.pack();
            ComponentSelectionContainerDecorator decorator = new ComponentSelectionContainerDecorator(componentContainer);
            this.container2decoratorMap.put(componentContainer, decorator);
            item.setData((Object)decorator);
            decorator.setCheckbox(checkbox);
            decorator.setCombo(combo);
            decorator.setTableItem(item);
            this.workplanDerivationManager.addShowedComponent(componentContainer);
            checkbox.addSelectionListener((SelectionListener)new ComponentCheckBoxListener(this, decorator));
            combo.addSelectionListener((SelectionListener)new ComponentComboListener(this, decorator));
        }
        this.setPageComplete(this.checkedAndSelected());
    }

    private Combo configureBasicActivityCombo(TableItem item) {
        Combo combo = new Combo((Composite)this.table, 8);
        combo.add(BasicActivity.ADD.toString());
        combo.add(BasicActivity.CHANGE.toString());
        combo.add(BasicActivity.REMOVE.toString());
        combo.setEnabled(false);
        this.setControlWithEditor(this.table, item, (Control)combo, 2);
        return combo;
    }

    private void setControlWithEditor(Table table, TableItem item, Control control, int column) {
        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(control, item, column);
        editor.layout();
    }

    public boolean checkedAndSelected() {
        this.setErrorMessage(null);
        List selectedComponents = this.workplanDerivationManager.getSelectedComponents();
        if (selectedComponents.isEmpty()) {
            return false;
        }
        boolean checkedAndSelected = true;
        for (ComponentSelectionContainer componentContainer : selectedComponents) {
            ComponentSelectionContainerDecorator decorator = this.container2decoratorMap.get(componentContainer);
            if (componentContainer.getBasicActivity() == null) {
                if (decorator != null) {
                    decorator.getTableItem().setBackground(2, new Color((Device)this.getContainer().getShell().getDisplay(), 255, 0, 0));
                }
                this.setErrorMessage("If you check a component, you have to choose a basic activity");
                checkedAndSelected = false;
                continue;
            }
            if (decorator == null) continue;
            decorator.getTableItem().setBackground(2, new Color((Device)this.getContainer().getShell().getDisplay(), 255, 255, 255));
        }
        return checkedAndSelected;
    }
}

