/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import de.fzi.kamp.service.architecturemodel.IArchitectureModelProvider;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.CompositeTaskDerivationContainerBuilder;
import de.fzi.kamp.service.workplanmanagement.WorkPlanBuilder;
import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.AbstractWizard;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.InitialForkPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.NamingChangingRationalPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectComponentActivitiesWizardPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectDatatypesPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacePortForDatatypesPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacePortPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacesPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectOperationPage;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.WorkplanFactory;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.SelectioncontainerFactoryImpl;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;

public class DeriveWorkPlanWizard
extends AbstractWizard
implements IWizard {
    private CompositeTaskDerivationContainer compositeTaskContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private IMainEditor editor;
    private EffortAnalysisInstance instance;
    private InitialForkPage forkPage;
    private NamingChangingRationalPage rationalPage;
    private SelectComponentActivitiesWizardPage compPage;
    private SelectInterfacePortPage interfacePortPage;
    private SelectOperationPage operationPage;
    private SelectInterfacesPage interfacePage;
    private SelectDatatypesPage datatypePage;
    private SelectInterfacePortForDatatypesPage IPDatatypesPage;
    private IWizardPage activePage;
    private int navigationIndex;

    public DeriveWorkPlanWizard(EffortAnalysisInstance instance, IMainEditor editor, IArchitectureModelProvider architectureModelProvider) {
        this.instance = instance;
        this.createWorkplanDerivationContainer(architectureModelProvider);
        this.workplanDerivationManager = new WorkplanDerivationManager(this.compositeTaskContainer);
        this.editor = editor;
        this.rationalPage = new NamingChangingRationalPage(((CompositeTask)this.compositeTaskContainer.getActivity()).getTaskrationale());
        this.forkPage = new InitialForkPage();
        this.compPage = new SelectComponentActivitiesWizardPage(this.compositeTaskContainer);
        this.interfacePortPage = new SelectInterfacePortPage(this.compositeTaskContainer);
        this.operationPage = new SelectOperationPage(this.compositeTaskContainer);
        this.interfacePage = new SelectInterfacesPage(this.compositeTaskContainer);
        this.datatypePage = new SelectDatatypesPage(this.compositeTaskContainer);
        this.IPDatatypesPage = new SelectInterfacePortForDatatypesPage(this.compositeTaskContainer);
        this.activePage = this.compPage;
        this.navigationIndex = -1;
    }

    @Override
    public boolean performFinish() {
        this.workplanDerivationManager.resetLastSelectedLists();
        new WorkPlanBuilder().fillTasklistOfWorkplan(this.compositeTaskContainer, this.instance.getWorkplan());
        this.editor.showWorkplanChanges(this.instance.getWorkplan(), false);
        this.editor.getCentralPage().setAddCompositeActivityButtonVisible();
        return true;
    }

    @Override
    public boolean canFinish() {
        if (this.activePage == this.compPage) {
            return false;
        }
        if (this.activePage == this.interfacePortPage) {
            return false;
        }
        if (this.activePage == this.operationPage) {
            return true;
        }
        return super.canFinish();
    }

    @Override
    public void addPages() {
        this.addPage((IWizardPage)this.rationalPage);
        this.addPage((IWizardPage)this.forkPage);
        this.addPage((IWizardPage)this.compPage);
        this.addPage((IWizardPage)this.interfacePortPage);
        this.addPage((IWizardPage)this.operationPage);
        this.addPage((IWizardPage)this.interfacePage);
        this.addPage((IWizardPage)this.datatypePage);
        this.addPage((IWizardPage)this.IPDatatypesPage);
        this.setWindowTitle("Select Work Activities");
    }

    @Override
    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.rationalPage) {
            return this.forkPage;
        }
        if (page == this.compPage) {
            this.getPageList().remove((Object)this.interfacePortPage);
            this.interfacePortPage = new SelectInterfacePortPage(this.compositeTaskContainer);
            this.addPage((IWizardPage)this.interfacePortPage);
            this.activePage = this.interfacePortPage;
            return this.interfacePortPage;
        }
        if (page == this.interfacePortPage) {
            this.getPageList().remove((Object)this.operationPage);
            this.operationPage = new SelectOperationPage(this.compositeTaskContainer);
            this.addPage((IWizardPage)this.operationPage);
            this.activePage = this.operationPage;
            return this.operationPage;
        }
        if (page == this.interfacePage) {
            if (page.getPreviousPage() instanceof SelectDatatypesPage) {
                this.getPageList().remove((Object)this.IPDatatypesPage);
                this.IPDatatypesPage = new SelectInterfacePortForDatatypesPage(this.compositeTaskContainer);
                this.addPage((IWizardPage)this.IPDatatypesPage);
                this.activePage = this.IPDatatypesPage;
                return this.IPDatatypesPage;
            }
            this.getPageList().remove((Object)this.interfacePortPage);
            this.interfacePortPage = new SelectInterfacePortPage(this.compositeTaskContainer);
            this.addPage((IWizardPage)this.interfacePortPage);
            this.activePage = this.interfacePortPage;
            return this.interfacePortPage;
        }
        if (page == this.datatypePage) {
            this.getPageList().remove((Object)this.interfacePage);
            this.interfacePage = new SelectInterfacesPage(this.compositeTaskContainer);
            this.addPage((IWizardPage)this.interfacePage);
            this.activePage = this.interfacePage;
            return this.interfacePage;
        }
        if (page == this.IPDatatypesPage) {
            this.getPageList().remove((Object)this.operationPage);
            this.operationPage = new SelectOperationPage(this.compositeTaskContainer);
            this.addPage((IWizardPage)this.operationPage);
            this.activePage = this.operationPage;
            return this.operationPage;
        }
        return super.getNextPage(page);
    }

    @Override
    public IWizardPage getPreviousPage(IWizardPage page) {
        if (page == this.compPage) {
            this.activePage = page;
            return null;
        }
        if (page == this.interfacePortPage) {
            this.activePage = this.compPage;
            return this.compPage;
        }
        if (page == this.operationPage) {
            this.activePage = this.interfacePortPage;
            return this.interfacePortPage;
        }
        if (page instanceof SelectInterfacesPage) {
            return null;
        }
        return super.getPreviousPage(page);
    }

    public List<ComponentSelectionContainer> getSelectedComponents() {
        return this.workplanDerivationManager.getSelectedComponents();
    }

    public void setNavigationIndex(int index) {
        this.navigationIndex = index;
    }

    public int getNavigationIndex() {
        return this.navigationIndex;
    }

    public int getSelectionIndex(AbstractContainer operationContainer) {
        switch (operationContainer.getBasicActivity()) {
            case ADD: {
                return 0;
            }
            case CHANGE: {
                return 1;
            }
            case REMOVE: {
                return 2;
            }
        }
        return -1;
    }

    @Override
    public boolean performCancel() {
        this.instance.getWorkplan().getCompositetaskderivationcontainer().remove((Object)this.compositeTaskContainer);
        return super.performCancel();
    }

    private void createWorkplanDerivationContainer(IArchitectureModelProvider architectureModelProvider) {
        this.compositeTaskContainer = SelectioncontainerFactoryImpl.eINSTANCE.createCompositeTaskDerivationContainer();
        new CompositeTaskDerivationContainerBuilder(architectureModelProvider).fillWorkplanDerivationContainer(this.compositeTaskContainer, this.instance);
        this.compositeTaskContainer.setActivity((Activity)WorkplanFactory.eINSTANCE.createCompositeTask());
        ((CompositeTask)this.compositeTaskContainer.getActivity()).setTaskrationale(WorkplanFactory.eINSTANCE.createTaskRationale());
        this.instance.getWorkplan().getCompositetaskderivationcontainer().add((Object)this.compositeTaskContainer);
    }
}

