/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.listeners.FurtherDerivationComboListener;
import de.fzi.kamp.ui.workplanderivation.providers.FurtherDerivationTreeContentProvider;
import de.fzi.kamp.ui.workplanderivation.providers.FurtherDerivationtTreeLabelProvider;
import de.fzi.kamp.ui.workplanderivation.providers.SpecialComponentSelectionContentProvider;
import de.fzi.kamp.ui.workplanderivation.providers.SpecialDatatypeSelectionContentProvider;
import de.fzi.kamp.ui.workplanderivation.providers.SpecialInterfaceSelectionContentProvider;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.FurtherDerivationWizard;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import java.util.List;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class SelectElementTypesPage
extends WizardPage {
    private SurfaceFactory factory = new SurfaceFactory();
    private Tree currentTree;
    private TreeViewer treeViewer;
    private int presentationIndicator;
    private boolean somethingChanged = false;

    protected SelectElementTypesPage() {
        super("beginningPage");
    }

    public void createControl(Composite parent) {
        Composite container = this.factory.createCompositeOrGroup(parent, 1, 16384, 1, 0, true, 10, 10);
        this.getShell().setMinimumSize(600, 500);
        this.setTitle("If elements are grayed, it is not possible to uncheck them or change basic activity.");
        this.currentTree = this.factory.createTree(container, 4, 1, true, 2080, new String[]{"Element Type", "Name", "Basic Activity"});
        this.factory.setGrabVerticalForGridData((Control)this.currentTree, true, 4, false);
        this.currentTree.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 22;
            }
        });
        List<AbstractContainer> input = ((FurtherDerivationWizard)this.getWizard()).getInput();
        this.treeViewer = new TreeViewer(this.currentTree);
        if (input != null && !input.isEmpty() && !(input.get(0) instanceof CompositeTaskDerivationContainer)) {
            this.setTreeViewerToTree(input);
        }
        this.setControl((Control)container);
    }

    private void checkAlreadyChosenContainers(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractContainer container;
            TreeItem item = treeItemArray[n2];
            if (item.getItems().length > 0) {
                this.checkAlreadyChosenContainers(item.getItems());
            }
            if ((container = (AbstractContainer)item.getData()).isSelected()) {
                item.setChecked(true);
            }
            ++n2;
        }
    }

    protected void assignChanges(TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getItems().length > 0) {
                this.assignChanges(item.getItems());
            }
            if (!item.getGrayed()) {
                AbstractContainer container = (AbstractContainer)item.getData();
                if (item.getChecked() != container.isSelected()) {
                    container.setSelected(item.getChecked());
                    this.somethingChanged = true;
                }
            }
            ++n2;
        }
    }

    protected Tree getCurrentTree() {
        return this.currentTree;
    }

    protected void addComboToTreeItems(Widget directParentItem, TreeItem[] items) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (item.getItems().length > 0) {
                this.addComboToTreeItems((Widget)item, item.getItems());
            }
            AbstractContainer container = (AbstractContainer)item.getData();
            Combo combo = new Combo((Composite)this.currentTree, 8);
            combo.addSelectionListener((SelectionListener)new FurtherDerivationComboListener(container, combo));
            if (container instanceof InterfaceSelectionContainer || item.getData() instanceof DataTypeSelectionContainer) {
                combo.add(BasicActivity.CHANGE.toString());
            } else {
                combo.add("ADD");
                combo.add("CHANGE");
                combo.add("REMOVE");
            }
            if (container.isSelected() && directParentItem instanceof TreeItem) {
                ((TreeItem)directParentItem).setChecked(true);
                ((TreeItem)directParentItem).setGrayed(true);
            }
            this.factory.setControlWithTableTreeEditor(this.currentTree, item, (Control)combo, 2);
            if (container.isSelected()) {
                this.setSelectedBasicActivity(container.getBasicActivity(), combo);
            }
            ++n2;
        }
    }

    public void setPresentationIndicator(int indicator) {
        this.presentationIndicator = indicator;
    }

    public void setTreeViewerToTree(List<AbstractContainer> input) {
        this.setContentProvider(this.treeViewer);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new FurtherDerivationtTreeLabelProvider());
        this.treeViewer.setInput(input);
        this.treeViewer.expandAll();
        this.currentTree.getColumn(0).pack();
        this.currentTree.getColumn(1).pack();
        this.checkAlreadyChosenContainers(this.currentTree.getItems());
        this.addComboToTreeItems((Widget)this.currentTree, this.currentTree.getItems());
    }

    private void setContentProvider(TreeViewer viewer) {
        switch (this.presentationIndicator) {
            case 1: {
                viewer.setContentProvider(new SpecialComponentSelectionContentProvider());
                break;
            }
            case 2: {
                viewer.setContentProvider((IContentProvider)new SpecialInterfaceSelectionContentProvider());
                break;
            }
            case 3: {
                viewer.setContentProvider((IContentProvider)new SpecialDatatypeSelectionContentProvider());
                break;
            }
            default: {
                viewer.setContentProvider((IContentProvider)new FurtherDerivationTreeContentProvider());
            }
        }
    }

    private void setSelectedBasicActivity(BasicActivity basicActivity, Combo combo) {
        switch (basicActivity) {
            case ADD: {
                combo.setText(BasicActivity.ADD.toString());
                break;
            }
            case CHANGE: {
                combo.setText(BasicActivity.CHANGE.toString());
                break;
            }
            case REMOVE: {
                combo.setText(BasicActivity.REMOVE.toString());
                break;
            }
            default: {
                combo.setText("");
            }
        }
    }

    public boolean isSomethingChanged() {
        return this.somethingChanged;
    }
}

