/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.preparation.dialogs;

import de.fzi.kamp.service.commands.ApplyWorkorganisationElementsMappingCommand;
import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.preparation.listeners.AddDeveloperButtonListener;
import de.fzi.kamp.ui.preparation.listeners.AllOrSingleCompaniesButtonListener;
import de.fzi.kamp.ui.preparation.listeners.ClearAssignedDevelopersButtonListener;
import de.fzi.kamp.ui.preparation.listeners.ComponentToMapListener;
import de.fzi.kamp.ui.preparation.listeners.ContextMenuForDeletingAssignedWOElementListener;
import de.fzi.kamp.ui.preparation.listeners.RoleComboListener;
import de.fzi.kamp.ui.preparation.listeners.SelectSingleCompaniesButtonListener;
import de.fzi.kamp.ui.preparation.listeners.TeamComboListener;
import de.fzi.kamp.ui.preparation.providers.AssignedDevelopersTableContentProvider;
import de.fzi.kamp.ui.preparation.providers.AssignedDevelopersTableLabelProvider;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractArchitectureModel;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractModelElement;
import de.fzi.maintainabilitymodel.architecturemodel.SAMMComponentProxy;
import de.fzi.maintainabilitymodel.architecturemodel.util.ArchitecturemodelSwitch;
import de.fzi.maintainabilitymodel.workorganisation.Company;
import de.fzi.maintainabilitymodel.workorganisation.Department;
import de.fzi.maintainabilitymodel.workorganisation.Team;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class MapElementsToDevelopersDialog
extends Dialog {
    private static final String SHELL_TITLE = "Map developers or teams to compoents";
    private static final String COLUMNTEXT_CENTRALTABLE_COMPONENT = "Component";
    private static final String COLUMNTEXT_CENTRALTABLE_TEAM = "Team";
    private static final String COLUMNTEXT_CENTRALTABLE_ROLE = "Role";
    private SurfaceFactory factory;
    private Composite companySelectionButtonsComposite;
    private WorkOrganisationModel workorganisation;
    private AbstractArchitectureModel architectureModel;
    private ArrayList<Company> selectedCompaniesList;
    private List<Team> currentTeams;
    private Table mappingTable;
    private Label componentName;
    private Table assignedDevelopers;
    private TableViewer assignedDevelopersViewer;
    private Map<SAMMComponentProxy, WorkOrganisationElement> currentMappingMap;
    private ICommandHandler commandHandler;
    private List<TableEditor> usedTableEditors;

    public MapElementsToDevelopersDialog(Shell parentShell, WorkOrganisationModel workorganisation, AbstractArchitectureModel architectureModel, ICommandHandler commandHandler) {
        super(parentShell);
        this.workorganisation = workorganisation;
        this.architectureModel = architectureModel;
        this.factory = new SurfaceFactory();
        this.selectedCompaniesList = new ArrayList();
        this.currentTeams = new ArrayList<Team>();
        this.usedTableEditors = new ArrayList<TableEditor>();
        this.currentMappingMap = new HashMap<SAMMComponentProxy, WorkOrganisationElement>();
        this.commandHandler = commandHandler;
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(SHELL_TITLE);
        this.createFilterGroup(parent);
        this.createMappingTable(parent);
        this.setAllCompaniesSelected();
        this.updateTeamsList();
        this.createComponentPropertiesGroup(parent);
        this.createBottomButtons(parent);
        this.fillTable();
        return super.createContents(parent);
    }

    private void createMappingTable(Composite parent) {
        this.mappingTable = this.factory.createTable(parent, 3, new String[]{COLUMNTEXT_CENTRALTABLE_COMPONENT, COLUMNTEXT_CENTRALTABLE_TEAM, COLUMNTEXT_CENTRALTABLE_ROLE}, 4, true);
        this.factory.setControlHeight((Control)this.mappingTable, 150);
    }

    private void createFilterGroup(Composite parent) {
        Group filterGroup = (Group)this.factory.createCompositeOrGroup(parent, 3, 4, 1, 0, true);
        filterGroup.setFont(this.factory.getFontStyle().get("textStyle"));
        filterGroup.setText("Filter");
        this.createChooseViewComposite((Composite)filterGroup);
        this.factory.setGrabVerticalForGridData((Control)new Label((Composite)filterGroup, 514), true, 4, true);
        this.companySelectionButtonsComposite = this.factory.createVerticalButtonComposite((Composite)filterGroup, 4, 4, this.getCompanyNames(), 32);
        this.fillListenerArrayForCheckButtons(this.companySelectionButtonsComposite.getChildren());
        this.setCompanySelectionButtonsEnabled(false);
    }

    private String[] getCompanyNames() {
        String[] companyNames = new String[this.workorganisation.getCompanies().size()];
        int companyIndex = 0;
        for (Company company : this.workorganisation.getCompanies()) {
            companyNames[companyIndex] = company.getName() == null ? "Company No. " + companyIndex : company.getName();
            ++companyIndex;
        }
        return companyNames;
    }

    private void fillListenerArrayForCheckButtons(Control[] companyButtons) {
        EList companyList = this.workorganisation.getCompanies();
        int companyIndex = 0;
        Control[] controlArray = companyButtons;
        int n = companyButtons.length;
        int n2 = 0;
        while (n2 < n) {
            Control button = controlArray[n2];
            ((Button)button).addSelectionListener((SelectionListener)new SelectSingleCompaniesButtonListener((Button)button, this));
            ((Button)button).setData(companyList.get(companyIndex));
            ++companyIndex;
            ++n2;
        }
    }

    private void createChooseViewComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        new Label(comp, 0).setText("Show teams of");
        this.setAllCompaniesOrSingleCompaniesButtonListener(this.factory.createVerticalButtonComposite(comp, 4, 4, new String[]{"all Companies", "selected Companies"}, 16));
    }

    private void setAllCompaniesOrSingleCompaniesButtonListener(Composite buttonComposite) {
        Assert.isNotNull((Object)buttonComposite, (String)"Button for selecting all or single companies have not been created");
        ((Button)buttonComposite.getChildren()[0]).addSelectionListener((SelectionListener)new AllOrSingleCompaniesButtonListener(false, this));
        ((Button)buttonComposite.getChildren()[1]).addSelectionListener((SelectionListener)new AllOrSingleCompaniesButtonListener(true, this));
    }

    public void setCompanySelectionButtonsEnabled(boolean isEnabled) {
        Control[] controlArray = this.companySelectionButtonsComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control button = controlArray[n2];
            button.setEnabled(isEnabled);
            ++n2;
        }
    }

    public void setAllCompaniesSelected() {
        this.selectedCompaniesList.clear();
        this.selectedCompaniesList.addAll((Collection<Company>)this.workorganisation.getCompanies());
        this.setAllCompanyButtonsSelected();
    }

    public void updateTeamsList() {
        this.currentTeams.clear();
        for (Company company : this.selectedCompaniesList) {
            for (Department departement : company.getDepartments()) {
                this.currentTeams.addAll((Collection<Team>)departement.getTeams());
            }
        }
    }

    public List<Company> getSelectedCompaniesList() {
        return this.selectedCompaniesList;
    }

    public void fillTable() {
        this.mappingTable.clearAll();
        this.mappingTable.removeAll();
        this.disposeAllTableEditors();
        this.mappingTable.redraw();
        ArchitecturemodelSwitch<AbstractModelElement> selectComponentSwitch = new ArchitecturemodelSwitch<AbstractModelElement>(){

            public AbstractModelElement caseSAMMComponentProxy(SAMMComponentProxy component) {
                TableItem item = new TableItem(MapElementsToDevelopersDialog.this.getMappingTable(), 0);
                item.setText(component.getComponenttype().getName());
                item.setData((Object)component);
                item.setFont(MapElementsToDevelopersDialog.this.factory.getFontStyle().get("textStyle"));
                MapElementsToDevelopersDialog.this.setTableEditor(item);
                return component;
            }
        };
        for (AbstractModelElement modelElement : this.architectureModel.getModelelements()) {
            selectComponentSwitch.doSwitch((EObject)modelElement);
        }
        this.mappingTable.getColumn(0).pack();
        this.mappingTable.getColumn(1).setWidth(150);
        this.mappingTable.getColumn(2).setWidth(150);
        this.mappingTable.addSelectionListener((SelectionListener)new ComponentToMapListener(this.mappingTable, this.componentName, this.assignedDevelopersViewer));
    }

    private void createComponentPropertiesGroup(Composite parent) {
        Group teamPropertiesGroup = (Group)this.factory.createCompositeOrGroup(parent, 1, 4, 1, 0, true);
        teamPropertiesGroup.setFont(this.factory.getFontStyle().get("textStyle"));
        teamPropertiesGroup.setText("Component Properties");
        this.createComponentComposite((Composite)teamPropertiesGroup);
        this.createPropertiesLabel((Composite)teamPropertiesGroup);
    }

    private void createComponentComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        comp.setLayout((Layout)layout);
        this.createComponentLabelRow(comp);
    }

    private void createComponentLabelRow(Composite parent) {
        Label componentLabel = new Label(parent, 0);
        componentLabel.setFont(this.factory.getFontStyle().getBold("textStyle"));
        componentLabel.setText("Component: ");
        this.componentName = new Label(parent, 0);
        this.componentName.setText("[No component selected]");
    }

    private void createPropertiesLabel(Composite parent) {
        Label description = new Label(parent, 0);
        description.setFont(this.factory.getFontStyle().getBold("textStyle"));
        description.setText("Assigned Teams/Developers: ");
        this.configureAssignedDevelopersTable(parent);
    }

    private void configureAssignedDevelopersTable(Composite parent) {
        this.assignedDevelopers = new Table(parent, 2056);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.minimumHeight = 80;
        this.assignedDevelopers.setLayoutData((Object)data);
        this.assignedDevelopers.setFont(this.factory.getFontStyle().get("textStyle"));
        this.setProvidersToAssignedDevelopersTable();
    }

    private void setProvidersToAssignedDevelopersTable() {
        this.assignedDevelopersViewer = new TableViewer(this.assignedDevelopers);
        this.assignedDevelopersViewer.setContentProvider((IContentProvider)new AssignedDevelopersTableContentProvider());
        this.assignedDevelopersViewer.setLabelProvider((IBaseLabelProvider)new AssignedDevelopersTableLabelProvider());
        this.assignedDevelopersViewer.setInput(null);
        this.assignedDevelopers.addMouseListener((MouseListener)new ContextMenuForDeletingAssignedWOElementListener(this.commandHandler, this.assignedDevelopersViewer, this.mappingTable));
    }

    private void setTableEditor(TableItem item) {
        Combo teamCombo = this.createAndfillTeamCombo();
        this.createNewTableEditor().setEditor((Control)teamCombo, item, 1);
        Combo rolesCombo = this.createRolesCombo();
        this.createNewTableEditor().setEditor((Control)rolesCombo, item, 2);
        teamCombo.addSelectionListener((SelectionListener)new TeamComboListener(teamCombo, rolesCombo, this.componentName, (SAMMComponentProxy)item.getData(), this.assignedDevelopersViewer));
        rolesCombo.addSelectionListener((SelectionListener)new RoleComboListener(rolesCombo, item, teamCombo, this.assignedDevelopersViewer, this.currentMappingMap));
    }

    private TableEditor createNewTableEditor() {
        TableEditor editor = new TableEditor(this.mappingTable);
        this.usedTableEditors.add(editor);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        return editor;
    }

    private Combo createAndfillTeamCombo() {
        Combo combo = new Combo((Composite)this.mappingTable, 8);
        LinkedList<Team> teamsData = new LinkedList<Team>();
        combo.setData(teamsData);
        for (Team team : this.currentTeams) {
            combo.add(team.getName());
            teamsData.add(team);
        }
        combo.pack();
        return combo;
    }

    private Combo createRolesCombo() {
        return new Combo((Composite)this.mappingTable, 8);
    }

    private void disposeAllTableEditors() {
        for (TableEditor editor : this.usedTableEditors) {
            if (editor.getEditor() != null) {
                editor.getEditor().dispose();
            }
            if (editor.getItem() != null) {
                editor.getItem().dispose();
            }
            editor.dispose();
        }
        this.usedTableEditors.clear();
    }

    private void setAllCompanyButtonsSelected() {
        Control[] controlArray = this.companySelectionButtonsComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control companyButton = controlArray[n2];
            ((Button)companyButton).setSelection(true);
            ++n2;
        }
    }

    public Table getMappingTable() {
        return this.mappingTable;
    }

    private void createBottomButtons(Composite parent) {
        String[] buttonNames = new String[]{"Apply developer/team assignments", "Clear assigned developer/teams of selected component"};
        SelectionAdapter[] selectionListeners = new SelectionAdapter[]{new AddDeveloperButtonListener(this, this.assignedDevelopersViewer), new ClearAssignedDevelopersButtonListener(this.mappingTable, this.assignedDevelopersViewer, this.commandHandler)};
        int i = 0;
        String[] stringArray = buttonNames;
        int n = buttonNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            Button button = new Button(parent, 0);
            button.setText(name);
            button.addSelectionListener((SelectionListener)selectionListeners[i]);
            GridData data = new GridData();
            data.grabExcessHorizontalSpace = true;
            data.horizontalAlignment = 0x1000000;
            button.setLayoutData((Object)data);
            ++i;
            ++n2;
        }
    }

    protected void okPressed() {
        this.applyDeveloperAssignments();
        super.okPressed();
    }

    public void applyDeveloperAssignments() {
        ApplyWorkorganisationElementsMappingCommand command = new ApplyWorkorganisationElementsMappingCommand(this.currentMappingMap);
        this.commandHandler.handleCommand((Command)command);
    }
}

