/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.maineditor.stacklayers;

import de.fzi.kamp.service.maineditor.ICommandHandler;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.maineditor.page.CentralEditorPage;
import de.fzi.kamp.ui.workplanediting.adapter.WorkPlanContentAdapter;
import de.fzi.kamp.ui.workplanediting.listeners.AddTopLevelActivitiesListener;
import de.fzi.kamp.ui.workplanediting.listeners.BackToAnalysisOverviewPageListener;
import de.fzi.kamp.ui.workplanediting.listeners.ContextMenuMouseListenerForWorkplanTree;
import de.fzi.kamp.ui.workplanediting.listeners.DeveloperStructureButtonListener;
import de.fzi.kamp.ui.workplanediting.listeners.LowestAbstractionListener;
import de.fzi.kamp.ui.workplanediting.listeners.WorkplanContainmentButtonListener;
import de.fzi.kamp.ui.workplanediting.listeners.WorkplanFollowUpButtonListener;
import de.fzi.kamp.ui.workplanediting.providers.WorkplanTableColumnConstants;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class WorkplanTableLayer {
    private static final String BUTTONTEXT_LOWESTABSTRACTIONLEVEL = "Lowest Abstraction Level";
    private static final String BUTTONTEXT_DEVELOPERSTRUCTURE = "Developer Structure";
    private static final String BUTTONTEXT_CONTAINMENTRELATION = "Containment Relation";
    private static final String BUTTONTEXT_FOLLOW_UP_RELATION = "Follow-Up Relation";
    private static final String BUTTONTEXT_NAVIGATIONBUTTON = "Go back to Analysis Overview";
    private static final String BUTTONTEXT_ADDCHANGINGDOMAIN = "Add Composite Activity / Milestone";
    private static final String GROUPHEADING_RELATIONGROUP = "Show Activities in";
    private CentralEditorPage page;
    private WorkPlanContentAdapter adapter;
    private SurfaceFactory factory;
    private Display display;
    private boolean isEditableEffort;
    private ScrolledForm form;
    private Composite structureButtons;
    private Group groupForWorkplanModification;
    private IMainEditor mainEditor;
    private Composite buttonRowComposite;
    private Tree tree;

    public WorkplanTableLayer(CentralEditorPage page) {
        this.page = page;
        this.factory = new SurfaceFactory();
    }

    public void createWorkplanTable(Display display, IMainEditor mainEditor, ScrolledForm form) {
        SurfaceFactory factory = new SurfaceFactory();
        this.display = display;
        this.form = form;
        this.mainEditor = mainEditor;
        String[] headings = WorkplanTableColumnConstants.getHeadings();
        this.tree = factory.createTreeforEclipseForm(display, this.form.getBody(), headings, 128, true, 1, 450);
        this.buttonRowComposite = factory.createCompositeForEclipseForm(display, form.getBody(), 0, 4, true, 1, 2);
        this.createGroupForWorkplanModification(display, mainEditor, factory);
        this.createGroupForNavigation(display, mainEditor, factory);
        this.adapter = new WorkPlanContentAdapter(this.tree, (ICommandHandler)this.mainEditor);
        this.tree.addMouseListener((MouseListener)new ContextMenuMouseListenerForWorkplanTree(this.tree, mainEditor));
    }

    private void createGroupForNavigation(Display display, IMainEditor mainEditor, SurfaceFactory factory) {
        Group groupForNavigation = new Group(this.buttonRowComposite, 0);
        factory.configureCompositeForTableWrapLayout((Composite)groupForNavigation, 1, 8, 1, false, new Color((Device)display, 255, 255, 255));
        SelectionAdapter[] navigationListeners = new SelectionAdapter[]{new BackToAnalysisOverviewPageListener(mainEditor)};
        factory.createButtonsForGivenTableWrapComposite((Composite)groupForNavigation, new String[]{BUTTONTEXT_NAVIGATIONBUTTON}, 8, 0, true, navigationListeners);
    }

    private void createGroupForWorkplanModification(Display display, IMainEditor mainEditor, SurfaceFactory factory) {
        this.groupForWorkplanModification = new Group(this.buttonRowComposite, 0);
        factory.configureCompositeForTableWrapLayout((Composite)this.groupForWorkplanModification, 2, 2, 1, false, new Color((Device)display, 255, 255, 255));
        SelectionAdapter[] listeners = new SelectionAdapter[]{new AddTopLevelActivitiesListener(mainEditor, this.tree)};
        factory.createButtonsForGivenTableWrapComposite((Composite)this.groupForWorkplanModification, new String[]{BUTTONTEXT_ADDCHANGINGDOMAIN}, 128, 0, true, listeners);
    }

    public WorkPlanContentAdapter getAdapter() {
        return this.adapter;
    }

    private Composite createSelectStructureComposite() {
        FormToolkit toolkit = new FormToolkit(this.display);
        Group group = this.factory.createGroupWithWhiteBackgroundTableWrap(this.display, this.form.getBody(), GROUPHEADING_RELATIONGROUP, 8, false, 1, 4);
        group.setFont(this.factory.getFontStyle().getBold("groupStyle"));
        if (!this.isEditableEffort) {
            Button containment = toolkit.createButton((Composite)group, BUTTONTEXT_CONTAINMENTRELATION, 16);
            containment.addSelectionListener((SelectionListener)new WorkplanContainmentButtonListener(this.page, this.tree));
            containment.setSelection(true);
            Button followUp = toolkit.createButton((Composite)group, BUTTONTEXT_FOLLOW_UP_RELATION, 16);
            followUp.addSelectionListener((SelectionListener)new WorkplanFollowUpButtonListener(this.page, this.tree));
        } else {
            Button lowestAbstractionButton = toolkit.createButton((Composite)group, BUTTONTEXT_LOWESTABSTRACTIONLEVEL, 32);
            Button isDeveloperStructureButton = toolkit.createButton((Composite)group, BUTTONTEXT_DEVELOPERSTRUCTURE, 32);
            lowestAbstractionButton.addSelectionListener((SelectionListener)new LowestAbstractionListener(this.page, this.tree, lowestAbstractionButton, isDeveloperStructureButton));
            isDeveloperStructureButton.addSelectionListener((SelectionListener)new DeveloperStructureButtonListener(this.mainEditor, this.tree, isDeveloperStructureButton));
        }
        return group;
    }

    public void showEffortEstimationColumns() {
        if (this.structureButtons != null) {
            this.structureButtons.dispose();
        }
        this.structureButtons = this.createSelectStructureComposite();
        this.structureButtons.moveAbove((Control)this.tree);
        this.groupForWorkplanModification.setVisible(!this.isEditableEffort);
        this.form.reflow(true);
    }

    public void setIsEditableEffort(boolean isEditableEffotr) {
        this.isEditableEffort = isEditableEffotr;
    }

    public void setAddCompositeTaskButtonVisible() {
        this.groupForWorkplanModification.setVisible(true);
    }

    public void showDeveloperOrLowestAbstactionStructureView(Boolean showDeveloper) {
        if (showDeveloper.booleanValue()) {
            this.tree.getColumn(9).pack();
            this.tree.getColumn(9).setResizable(true);
        } else {
            TreeColumn[] treeColumnArray = this.tree.getColumns();
            int n = treeColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreeColumn column = treeColumnArray[n2];
                if (column.getText() == BUTTONTEXT_DEVELOPERSTRUCTURE || column.getText() == "Component" || column.getText() == "Interface Port" || column.getText() == "Operation") {
                    column.setWidth(0);
                } else {
                    column.pack();
                }
                ++n2;
            }
        }
    }
}

