/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.general;

import de.fzi.kamp.service.analysisinstance.IAnalysisInstanceManager;
import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceContentAdapter;
import de.fzi.kamp.ui.analysisoverview.adapters.AnalysisInstanceItemAdapter;
import de.fzi.kamp.ui.analysisoverview.listeners.CalculateButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.DeriveButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.EditEffortEstimationButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.EditWorkplanButtonListener;
import de.fzi.kamp.ui.analysisoverview.listeners.ShowResultSummaryButtonListener;
import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class SurfaceFactory {
    public static final String STYLE_HEADING = "headingStyle";
    public static final String STYLE_HEADING_EDITORPAGE = "editorpageheadingStyle";
    public static final String STYLE_TABLE_HEADING = "tableheadingStyle";
    public static final String STYLE_GROUP = "groupStyle";
    public static final String STYLE_QUESTION = "questionStyle";
    public static final String STYLE_TEXT = "textStyle";
    public static final String STYLE_ANSWER = "answerStyle";
    public static final String STYLE_FOOTNOTE_HEADING = "footnoteHeadingStyle";
    public static final String STYLE_FOOTNOTE_TEXT = "footnoteTextStyle";

    public FontRegistry getFontStyle() {
        FontRegistry FontReg = new FontRegistry();
        FontReg.put(STYLE_HEADING, new FontData[]{new FontData("Helvetica", 11, 1)});
        FontReg.put(STYLE_HEADING_EDITORPAGE, new FontData[]{new FontData("Helvetica", 16, 0)});
        FontReg.put(STYLE_TABLE_HEADING, new FontData[]{new FontData("Helvetica", 10, 1)});
        FontReg.put(STYLE_GROUP, new FontData[]{new FontData("Helvetica", 10, 0)});
        FontReg.put(STYLE_QUESTION, new FontData[]{new FontData("Helvetica", 10, 1)});
        FontReg.put(STYLE_TEXT, new FontData[]{new FontData("Helvetica", 9, 0)});
        FontReg.put(STYLE_ANSWER, new FontData[]{new FontData("Helvetica", 9, 0)});
        FontReg.put(STYLE_FOOTNOTE_HEADING, new FontData[]{new FontData("bla", 7, 1)});
        FontReg.put(STYLE_FOOTNOTE_TEXT, new FontData[]{new FontData("bla", 7, 0)});
        return FontReg;
    }

    public Section createSection(Composite form, String title, int sectionStyle, int horizontalAlignTableWrap, Boolean grabHorizontal, Display display, int colspan) {
        Section section = new Section(form, sectionStyle);
        section.setText(title);
        section.setTitleBarBackground(new Color((Device)display, 204, 236, 241));
        section.setBackground(new Color((Device)display, 255, 255, 255));
        section.setForeground(new Color((Device)display, 0, 0, 0));
        section.setTitleBarBorderColor(new Color((Device)display, 0, 119, 75));
        section.setFont(new SurfaceFactory().getFontStyle().get(STYLE_GROUP));
        TableWrapData td = new TableWrapData();
        td.align = horizontalAlignTableWrap;
        td.grabHorizontal = grabHorizontal;
        td.colspan = colspan;
        section.setLayoutData((Object)td);
        return section;
    }

    public Composite createVerticalButtonComposite(Composite parent, int horizontalAlignmentComposite, int horizontalAlignmentButton, String[] buttonText, int buttonSyle) {
        return this.createVerticalButtonComposite(parent, horizontalAlignmentComposite, horizontalAlignmentButton, buttonText, buttonSyle, null, null);
    }

    public Composite createVerticalButtonComposite(Composite parent, int horizontalAlignmentComposite, int horizontalAlignmentButton, String[] buttonText, int buttonSyle, SelectionAdapter[] listener) {
        return this.createVerticalButtonComposite(parent, horizontalAlignmentComposite, horizontalAlignmentButton, buttonText, buttonSyle, listener, null);
    }

    public Composite createVerticalButtonComposite(Composite parent, int horizontalAlignmentComposite, int horizontalAlignmentButton, String[] buttonText, int buttonSyle, SelectionAdapter[] listener, String[] toolTips) {
        Composite compForButtons = new Composite(parent, 0);
        compForButtons.setLayout((Layout)new GridLayout());
        GridData gdCompForButtons = new GridData();
        gdCompForButtons.horizontalAlignment = horizontalAlignmentComposite;
        gdCompForButtons.grabExcessHorizontalSpace = true;
        compForButtons.setLayoutData((Object)gdCompForButtons);
        int i = 0;
        while (i < buttonText.length) {
            Button button = new Button(compForButtons, buttonSyle);
            button.setText(buttonText[i]);
            GridData gdLoadButton = new GridData();
            gdLoadButton.horizontalAlignment = horizontalAlignmentButton;
            gdLoadButton.grabExcessHorizontalSpace = true;
            button.setLayoutData((Object)gdLoadButton);
            button.setFont(new SurfaceFactory().getFontStyle().get(STYLE_ANSWER));
            if (listener != null && i < listener.length) {
                button.addSelectionListener((SelectionListener)listener[i]);
            }
            if (toolTips != null && i < toolTips.length) {
                button.setToolTipText(toolTips[i]);
            }
            ++i;
        }
        return compForButtons;
    }

    public Composite createHorizontalButtonCompositeWithToolkit(Composite parent, Boolean withLeadingLabel, String labelText, String[] buttonText, int horizontalAlignmentComp, int horizontalAlignmentButton, Display display, Boolean withToolkit, SelectionAdapter[] selectionListener) {
        FormToolkit toolkit = new FormToolkit(display);
        Composite comp = withToolkit != false ? toolkit.createComposite(parent) : new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        GridData gdButton = new GridData();
        GridData gdComp = new GridData();
        gdComp.horizontalAlignment = horizontalAlignmentComp;
        gl.numColumns = withLeadingLabel != false ? buttonText.length + 1 : buttonText.length;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)gdComp);
        if (withLeadingLabel.booleanValue()) {
            Label label = new Label(comp, 0);
            label.setText(labelText);
            label.setFont(new SurfaceFactory().getFontStyle().getBold(STYLE_ANSWER));
        }
        int i = 0;
        while (i < buttonText.length) {
            Button button = new Button(comp, 0);
            button.setText(buttonText[i]);
            button.setFont(new SurfaceFactory().getFontStyle().get(STYLE_ANSWER));
            gdButton.horizontalAlignment = horizontalAlignmentButton;
            button.setLayoutData((Object)gdButton);
            button.addSelectionListener((SelectionListener)selectionListener[i]);
            ++i;
        }
        return comp;
    }

    public Table createTable(Composite parent, int horizontalSpan, String[] columns, int horizontalAlignment, boolean grabHorizontal) {
        Table table = new Table(parent, 67588);
        table.setLayout((Layout)new GridLayout());
        GridData gdTable = new GridData();
        gdTable.horizontalAlignment = horizontalAlignment;
        gdTable.horizontalSpan = horizontalSpan;
        gdTable.grabExcessHorizontalSpace = grabHorizontal;
        table.setLayoutData((Object)gdTable);
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.setFont(new SurfaceFactory().getFontStyle().get(STYLE_TABLE_HEADING));
        int i = 0;
        while (i < columns.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columns[i]);
            ++i;
        }
        int j = 0;
        while (j < table.getColumnCount()) {
            table.getColumn(j).pack();
            ++j;
        }
        return table;
    }

    public Tree createTree(Composite parent, int horizontalAlignment, int horizontalSpan, boolean grabHorizontal, int style, String[] columns) {
        Tree tree = new Tree(parent, style | 0x100 | 0x200);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        GridData treeData = new GridData();
        treeData.horizontalAlignment = horizontalAlignment;
        treeData.horizontalSpan = horizontalSpan;
        treeData.grabExcessHorizontalSpace = grabHorizontal;
        tree.setLayoutData((Object)treeData);
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String columnText = stringArray[n2];
            TreeColumn column = new TreeColumn(tree, 0x1000000);
            column.setText(columnText);
            column.pack();
            ++n2;
        }
        return tree;
    }

    public void fillTable(Table table) {
        int i = 0;
        while (i < 100) {
            TableItem item = new TableItem(table, 0);
            item.setFont(new SurfaceFactory().getFontStyle().get(STYLE_TEXT));
            int j = 0;
            while (j < table.getColumnCount()) {
                if (table.getColumn(j).getText() == "ID") {
                    item.setText(j, String.valueOf(i));
                } else {
                    item.setText(j, "Item " + i);
                }
                ++j;
            }
            ++i;
        }
    }

    public Composite createCompositeOrGroup(Composite container, int numClumns, int horizontalAlignment, int horizontalSpan, int compositeStyle, boolean group) {
        return this.createCompositeOrGroup(container, numClumns, horizontalAlignment, horizontalSpan, compositeStyle, group, 5, 5);
    }

    public Composite createCompositeOrGroup(Composite container, int numClumns, int horizontalAlignment, int horizontalSpan, int compositeStyle, boolean group, int marginWidth, int marginHeight) {
        Composite comp;
        GridLayout glUp = new GridLayout();
        glUp.numColumns = numClumns;
        glUp.marginWidth = marginWidth;
        glUp.marginHeight = marginHeight;
        GridData gdUp = new GridData();
        gdUp.horizontalAlignment = horizontalAlignment;
        gdUp.horizontalSpan = horizontalSpan;
        if (!group) {
            comp = new Composite(container, compositeStyle);
            comp.setLayout((Layout)glUp);
            comp.setLayoutData((Object)gdUp);
        } else {
            comp = new Group(container, compositeStyle);
            comp.setLayout((Layout)glUp);
            comp.setLayoutData((Object)gdUp);
        }
        return comp;
    }

    public void createHeading(Composite upperPart, String title, int horizontalSpan, int horizontalAlignment, boolean group) {
        if (group) {
            Group labelGroup = new Group(upperPart, 0);
            labelGroup.setLayout((Layout)new GridLayout());
            GridData gdGroup = new GridData();
            gdGroup.grabExcessHorizontalSpace = true;
            gdGroup.horizontalAlignment = horizontalAlignment;
            gdGroup.horizontalSpan = horizontalSpan;
            labelGroup.setLayoutData((Object)gdGroup);
            Label AALabel = new Label((Composite)labelGroup, 0);
            AALabel.setText(title);
            AALabel.setFont(new SurfaceFactory().getFontStyle().getBold(STYLE_TEXT));
        } else {
            Label AALabel = new Label(upperPart, 0);
            AALabel.setText(title);
            GridData gdLabel = new GridData();
            gdLabel.grabExcessHorizontalSpace = true;
            gdLabel.horizontalAlignment = horizontalAlignment;
            gdLabel.horizontalSpan = horizontalSpan;
            AALabel.setLayoutData((Object)gdLabel);
            AALabel.setFont(new SurfaceFactory().getFontStyle().getBold(STYLE_TEXT));
        }
    }

    public Composite createCompositeForSection(Composite container, int numClumns, int horizontalAlignment, int horizontalSpan, int compositeStyle, int marginWidth, int marginHeight, Display display) {
        FormToolkit toolkit = new FormToolkit(display);
        Composite comp = toolkit.createComposite(container, compositeStyle);
        GridLayout gl = new GridLayout();
        gl.numColumns = numClumns;
        gl.verticalSpacing = 25;
        gl.marginWidth = marginWidth;
        gl.marginHeight = marginHeight;
        GridData gd = new GridData();
        gd.horizontalAlignment = horizontalAlignment;
        gd.horizontalSpan = horizontalSpan;
        comp.setLayout((Layout)gl);
        comp.setLayoutData((Object)gd);
        return comp;
    }

    public Composite createHorizontalButtonsForEclipseForm(Display display, Composite parent, String[] buttonTexts, SelectionAdapter[] listeners, int horizontalAlignmentComp, int horizontalAlignmentButton, boolean makeColumnsEqualWidth) {
        FormToolkit toolkit = new FormToolkit(display);
        Composite compositeForButtons = toolkit.createComposite(parent, 0);
        TableWrapLayout twLayout = new TableWrapLayout();
        twLayout.makeColumnsEqualWidth = makeColumnsEqualWidth;
        twLayout.numColumns = buttonTexts.length;
        twLayout.bottomMargin = 1;
        twLayout.topMargin = 1;
        twLayout.leftMargin = 1;
        twLayout.rightMargin = 1;
        compositeForButtons.setLayout((Layout)twLayout);
        TableWrapData td = new TableWrapData();
        td.align = horizontalAlignmentComp;
        td.grabHorizontal = true;
        compositeForButtons.setData((Object)td);
        int i = 0;
        while (i < buttonTexts.length) {
            TableWrapData gd = new TableWrapData();
            gd.grabHorizontal = true;
            gd.align = horizontalAlignmentButton;
            Button button = toolkit.createButton(compositeForButtons, buttonTexts[i], 0);
            button.setLayoutData((Object)gd);
            button.addSelectionListener((SelectionListener)listeners[i]);
            ++i;
        }
        return compositeForButtons;
    }

    public Label createIndentedLabel(Composite parent, String labelText, int indent, int style) {
        Label label = new Label(parent, style);
        label.setText(labelText);
        GridData gd = new GridData();
        gd.widthHint = indent;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        label.setLayoutData((Object)gd);
        return label;
    }

    public Button createFirstLevelOptionRadio(Composite parent, String optionText, int horizontalSpan) {
        Button button = new Button(parent, 16);
        button.setText(optionText);
        GridLayout gdB = new GridLayout();
        gdB.numColumns = 2;
        return button;
    }

    public Group createGroupWithWhiteBackgroundTableWrap(Display display, Composite comp, String text, int horizontalAlignment, Boolean grabExcessHorizontalSpace, int horizontalSpan, int numColumns) {
        Group group = new Group(comp, 0);
        group.setText(text);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        group.setLayout((Layout)layout);
        TableWrapData wrapData = new TableWrapData();
        wrapData.grabHorizontal = grabExcessHorizontalSpace;
        wrapData.align = horizontalAlignment;
        wrapData.colspan = horizontalSpan;
        group.setLayoutData((Object)wrapData);
        group.setBackground(new Color((Device)display, 255, 255, 255));
        return group;
    }

    public Composite createCompositeForEclipseForm(Display display, Composite parent, int compStyle, int alignWrap, Boolean grabHorizontal, int colspan, int numColumns) {
        FormToolkit toolkit = new FormToolkit(display);
        Composite comp = toolkit.createComposite(parent, compStyle);
        TableWrapLayout twl = new TableWrapLayout();
        twl.numColumns = numColumns;
        TableWrapData twd = new TableWrapData();
        twd.align = alignWrap;
        twd.grabHorizontal = grabHorizontal;
        twd.colspan = colspan;
        comp.setLayout((Layout)twl);
        comp.setLayoutData((Object)twd);
        return comp;
    }

    public Table createTableWithToolkit(Display display, Composite parent, int tableStyle, String[] headers, Boolean grabHorizontal, int horizontalAlignment, int colspan) {
        FormToolkit toolkit = new FormToolkit(display);
        Table table = toolkit.createTable(parent, tableStyle);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableWrapData twd = new TableWrapData();
        twd.align = horizontalAlignment;
        twd.grabHorizontal = grabHorizontal;
        twd.colspan = colspan;
        twd.heightHint = 100;
        table.setLayoutData((Object)twd);
        int i = 0;
        while (i < headers.length) {
            TableColumn tc = new TableColumn(table, 0);
            tc.setText(headers[i]);
            tc.pack();
            ++i;
        }
        return table;
    }

    public Table createTableForAnalysisInstanceLayer(Display display, Composite parent, int tableStyle, String[] headers, Boolean grabHorizontal, int horizontalAlignment, int colspan) {
        FormToolkit toolkit = new FormToolkit(display);
        Table table = toolkit.createTable(parent, tableStyle);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableWrapData twd = new TableWrapData();
        twd.align = horizontalAlignment;
        twd.grabHorizontal = grabHorizontal;
        twd.colspan = colspan;
        table.setLayoutData((Object)twd);
        table.setFont(this.getFontStyle().get(STYLE_QUESTION));
        int i = 0;
        while (i < headers.length) {
            TableColumn tc = new TableColumn(table, 0);
            tc.setText(headers[i]);
            tc.pack();
            ++i;
        }
        return table;
    }

    public Tree createTreeforEclipseForm(Display display, Composite parent, String[] columns, int align, Boolean grabHorizontal, int colspan, int heightHint) {
        FormToolkit toolkit = new FormToolkit(display);
        Tree tree = toolkit.createTree(parent, 67584);
        tree.setLinesVisible(true);
        tree.setHeaderVisible(true);
        TableWrapData data = new TableWrapData();
        data.align = align;
        data.grabHorizontal = grabHorizontal;
        data.colspan = colspan;
        data.heightHint = heightHint;
        int i = 0;
        while (i < columns.length) {
            TreeColumn column = new TreeColumn(tree, 0);
            column.setText(columns[i]);
            column.pack();
            ++i;
        }
        tree.setLayoutData((Object)data);
        tree.setFont(new SurfaceFactory().getFontStyle().get(STYLE_TABLE_HEADING));
        return tree;
    }

    public void removeArchitectureAlternativeFromOverviewTable(Table table, int index) {
        try {
            TableEditor editor = new TableEditor(table);
            editor.getEditor();
            table.remove(index);
            table.update();
        }
        catch (Exception exception) {}
    }

    public List<TableEditor> addButtonsToOverviewTable(TableItem item, IAnalysisInstanceManager manager, AnalysisInstanceContentAdapter contentAdapter, IMainEditor editor) {
        LinkedList<TableEditor> tableEditorList = new LinkedList<TableEditor>();
        if (item.getData() instanceof EffortAnalysisInstance) {
            EffortAnalysisInstance analysisInstance = (EffortAnalysisInstance)item.getData();
            AnalysisInstanceItemAdapter itemadapter = new AnalysisInstanceItemAdapter(manager, analysisInstance);
            analysisInstance.eAdapters().add((Object)itemadapter);
            tableEditorList.add(this.createWorkPlanButtons(item, 2, item.getParent(), manager, contentAdapter, analysisInstance, itemadapter, editor));
            tableEditorList.add(this.createEffortEstimationButtons(item, 3, item.getParent(), manager, itemadapter, analysisInstance, editor));
            itemadapter.notifyChanged(null);
        }
        return tableEditorList;
    }

    private TableEditor createWorkComplexityButton(TableItem item, int column, Table table, IAnalysisInstanceManager manager, AnalysisInstanceItemAdapter itemadapter, EffortAnalysisInstance instance, IMainEditor mainEditor) {
        Composite comp = this.createButtonComposite((Composite)table);
        Button button = this.createButton(comp, "Calculate", new CalculateButtonListener(manager, instance, mainEditor));
        button.setEnabled(false);
        itemadapter.setCalculateWorkcomplexityButton(button);
        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor((Control)comp, item, column);
        editor.layout();
        return editor;
    }

    private TableEditor createResultSummaryButton(TableItem item, int column, Table table, IAnalysisInstanceManager manager, AnalysisInstanceItemAdapter itemadapter, EffortAnalysisInstance instance, IMainEditor mainEditor) {
        Composite comp = this.createButtonComposite((Composite)table);
        Button button = this.createButton(comp, "Show", new ShowResultSummaryButtonListener(manager, instance, mainEditor));
        button.setEnabled(false);
        itemadapter.setShowResultSummaryButton(button);
        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor((Control)comp, item, column);
        editor.layout();
        return editor;
    }

    private TableEditor createWorkPlanButtons(TableItem item, int column, Table table, IAnalysisInstanceManager manager, AnalysisInstanceContentAdapter contentAdapter, EffortAnalysisInstance instance, AnalysisInstanceItemAdapter itemadapter, IMainEditor mainEditor) {
        TableEditor editor = new TableEditor(table);
        Composite comp = this.createButtonComposite((Composite)table);
        Button derive = this.createButton(comp, "Derive", new DeriveButtonListener(manager, instance, mainEditor));
        Button edit = this.createButton(comp, "Edit", new EditWorkplanButtonListener(manager, instance, mainEditor));
        edit.setEnabled(false);
        itemadapter.setDeriveWorkplanButton(derive);
        itemadapter.setEditWorkspaceButton(edit);
        editor.setEditor((Control)comp, item, column);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.layout();
        return editor;
    }

    private TableEditor createEffortEstimationButtons(TableItem item, int column, Table table, IAnalysisInstanceManager manager, AnalysisInstanceItemAdapter itemadapter, EffortAnalysisInstance instance, IMainEditor mainEditor) {
        TableEditor editor = new TableEditor(table);
        Composite comp = this.createButtonComposite((Composite)table);
        Button editButton = this.createButton(comp, "Edit", new EditEffortEstimationButtonListener(manager, instance, mainEditor));
        editButton.setEnabled(false);
        itemadapter.setEffortEstimationEditButton(editButton);
        editor.setEditor((Control)comp, item, column);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.layout();
        return editor;
    }

    private Composite createButtonComposite(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        comp.setLayout((Layout)layout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        comp.setLayoutData((Object)data);
        comp.setBackground(new Color((Device)comp.getDisplay(), 255, 255, 255));
        return comp;
    }

    private Button createButton(Composite parent, String text, SelectionAdapter listener) {
        Button button = new Button(parent, 0);
        button.setText(text);
        button.addSelectionListener((SelectionListener)listener);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        button.setLayoutData((Object)data);
        return button;
    }

    public void setControlWithTableEditor(Table table, TableItem item, Control control, int column) {
        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(control, item, column);
    }

    public void setControlWithTableTreeEditor(Tree tree, TreeItem item, Control control, int column) {
        TreeEditor editor = new TreeEditor(tree);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(control, item, column);
    }

    public Combo createCombo(TableItem itemForAssociatedInterface, String[] itemsToAdd, Table table, int column) {
        Combo combo = new Combo((Composite)table, 8);
        String[] stringArray = itemsToAdd;
        int n = itemsToAdd.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            combo.add(text);
            ++n2;
        }
        this.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)combo, column);
        return combo;
    }

    public void configureCompositeForTableWrapLayout(Composite composite, int numColumns, int align, int colspan, boolean grabHorizintal, Color background) {
        this.configureCompositeForTableWrapLayout(composite, numColumns, align, colspan, grabHorizintal, background, -1);
    }

    public void configureCompositeForTableWrapLayout(Composite composite, int numColumns, int align, int colspan, boolean grabHorizintal, Color background, int maxWidth) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = numColumns;
        layout.bottomMargin = 1;
        layout.topMargin = 1;
        layout.leftMargin = 1;
        layout.rightMargin = 2;
        TableWrapData data = new TableWrapData();
        data.align = align;
        data.colspan = colspan;
        data.grabHorizontal = grabHorizintal;
        if (maxWidth != -1) {
            data.maxWidth = maxWidth;
        }
        composite.setBackground(background);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
    }

    public void createButtonsForGivenTableWrapComposite(Composite parent, String[] buttonText, int alignmentButton, int buttonStyle, boolean grabHorizontal, SelectionAdapter[] listeners) {
        int i = 0;
        String[] stringArray = buttonText;
        int n = buttonText.length;
        int n2 = 0;
        while (n2 < n) {
            String text = stringArray[n2];
            Button button = new Button(parent, buttonStyle);
            button.setText(text);
            if (listeners[i] != null) {
                button.addSelectionListener((SelectionListener)listeners[i]);
            }
            TableWrapData td = new TableWrapData();
            td.align = alignmentButton;
            td.grabHorizontal = grabHorizontal;
            button.setLayoutData((Object)td);
            ++i;
            ++n2;
        }
    }

    public Button createChangeSelectionButton(Composite parent, String text, int TODO, int style) {
        return new Button(parent, style);
    }

    public void setSizeForControl(Composite composite, int widthHint, int heighHint, boolean useWidthHint) {
        if (composite.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)composite.getLayoutData();
            gd.heightHint = heighHint;
            if (useWidthHint) {
                gd.widthHint = widthHint;
            }
        } else if (composite.getLayoutData() instanceof TableWrapData) {
            TableWrapData twd = (TableWrapData)composite.getLayoutData();
            twd.heightHint = heighHint;
        }
    }

    public void setGrabVerticalForGridData(Control control, boolean grabVertical, int verticalAlignment) {
        this.setGrabVerticalForGridData(control, grabVertical, verticalAlignment, false);
    }

    public void setGrabVerticalForGridData(Control control, boolean grabVertical, int verticalAlignment, boolean setGridData) {
        if (control.getLayoutData() instanceof GridData) {
            GridData gd = (GridData)control.getLayoutData();
            gd.grabExcessVerticalSpace = grabVertical;
            gd.verticalAlignment = verticalAlignment;
        } else if (setGridData) {
            GridData gd = new GridData();
            gd.grabExcessVerticalSpace = grabVertical;
            gd.verticalAlignment = verticalAlignment;
            control.setLayoutData((Object)gd);
        }
    }

    public void setGrabVerticalForTableWrapData(Control control, boolean grabVertical, int vAlign) {
        if (control.getLayoutData() == null) {
            control.setLayoutData((Object)new TableWrapData());
        }
        if (control.getLayoutData() instanceof TableWrapData) {
            TableWrapData twd = (TableWrapData)control.getLayoutData();
            twd.grabVertical = grabVertical;
            twd.valign = vAlign;
        }
    }

    public void setControlHeight(Control control, int heighHint) {
        if (control.getLayoutData() instanceof GridData) {
            ((GridData)control.getLayoutData()).heightHint = heighHint;
        }
        if (control.getLayoutData() instanceof TableWrapData) {
            ((TableWrapData)control.getLayoutData()).heightHint = heighHint;
        }
    }

    public void setGridLayout(Control control, int horizontalAlignment, boolean grabHorizontal, int horizontalSpan) {
        GridData layoutData = new GridData();
        layoutData.horizontalAlignment = horizontalAlignment;
        layoutData.grabExcessHorizontalSpace = grabHorizontal;
        layoutData.horizontalSpan = horizontalSpan;
        control.setLayoutData((Object)layoutData);
    }

    public void setTableWrapData(Control control, int align, boolean grabHorizontal, int valign, boolean grabVertical, int colspan) {
        TableWrapData data = new TableWrapData();
        data.align = align;
        data.grabHorizontal = grabHorizontal;
        data.valign = valign;
        data.grabVertical = grabVertical;
        data.colspan = colspan;
        control.setLayoutData((Object)data);
    }

    public void setControlWidth(Control control, int widthHint) {
        if (control.getLayoutData() instanceof GridData) {
            ((GridData)control.getLayoutData()).widthHint = widthHint;
        }
        if (control.getLayoutData() instanceof TableWrapData) {
            ((TableWrapData)control.getLayoutData()).maxWidth = widthHint;
        }
    }

    public Button createButton(Composite parent, String text, int style) {
        Button button = new Button(parent, style);
        button.setText(text);
        return button;
    }

    public void packTableColums(Table table) {
        TableColumn[] tableColumnArray = table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
    }
}

