/*
 * Decompiled with CFR 0.152.
 */
package options;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DecisionStatusEnum implements Enumerator
{
    OPEN(0, "open", "open"),
    TAKEN(1, "taken", "taken"),
    REVIEWED(2, "reviewed", "reviewed"),
    OBSOLETE(3, "obsolete", "obsolete"),
    REPLACED(4, "replaced", "replaced"),
    IN_CONFLICT(5, "inConflict", "inConflict");

    public static final int OPEN_VALUE = 0;
    public static final int TAKEN_VALUE = 1;
    public static final int REVIEWED_VALUE = 2;
    public static final int OBSOLETE_VALUE = 3;
    public static final int REPLACED_VALUE = 4;
    public static final int IN_CONFLICT_VALUE = 5;
    private static final DecisionStatusEnum[] VALUES_ARRAY;
    public static final List<DecisionStatusEnum> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DecisionStatusEnum[]{OPEN, TAKEN, REVIEWED, OBSOLETE, REPLACED, IN_CONFLICT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DecisionStatusEnum get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DecisionStatusEnum result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DecisionStatusEnum getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            DecisionStatusEnum result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static DecisionStatusEnum get(int value) {
        switch (value) {
            case 0: {
                return OPEN;
            }
            case 1: {
                return TAKEN;
            }
            case 2: {
                return REVIEWED;
            }
            case 3: {
                return OBSOLETE;
            }
            case 4: {
                return REPLACED;
            }
            case 5: {
                return IN_CONFLICT;
            }
        }
        return null;
    }

    private DecisionStatusEnum(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

