/*
 * Decompiled with CFR 0.152.
 */
package effects.impl;

import effects.CategoryEffect;
import effects.EffectCategory;
import effects.EffectRepository;
import effects.EffectType;
import effects.EffectsFactory;
import effects.EffectsPackage;
import effects.QualityEffect;
import effects.SimpleEffect;
import effects.impl.CategoryEffectImpl;
import effects.impl.EffectCategoryImpl;
import effects.impl.EffectRepositoryImpl;
import effects.impl.QualityEffectImpl;
import effects.impl.SimpleEffectImpl;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class EffectsFactoryImpl
extends EFactoryImpl
implements EffectsFactory {
    public static EffectsFactory init() {
        try {
            EffectsFactory theEffectsFactory = (EffectsFactory)EPackage.Registry.INSTANCE.getEFactory("http://toometa.de/effects/0.6");
            if (theEffectsFactory != null) {
                return theEffectsFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new EffectsFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createSimpleEffect();
            }
            case 1: {
                return this.createEffectRepository();
            }
            case 3: {
                return this.createEffectCategory();
            }
            case 4: {
                return this.createQualityEffect();
            }
            case 5: {
                return this.createCategoryEffect();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.createEffectTypeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 6: {
                return this.convertEffectTypeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public SimpleEffect createSimpleEffect() {
        SimpleEffectImpl simpleEffect = new SimpleEffectImpl();
        return simpleEffect;
    }

    @Override
    public EffectRepository createEffectRepository() {
        EffectRepositoryImpl effectRepository = new EffectRepositoryImpl();
        return effectRepository;
    }

    @Override
    public EffectCategory createEffectCategory() {
        EffectCategoryImpl effectCategory = new EffectCategoryImpl();
        return effectCategory;
    }

    @Override
    public QualityEffect createQualityEffect() {
        QualityEffectImpl qualityEffect = new QualityEffectImpl();
        return qualityEffect;
    }

    @Override
    public CategoryEffect createCategoryEffect() {
        CategoryEffectImpl categoryEffect = new CategoryEffectImpl();
        return categoryEffect;
    }

    public EffectType createEffectTypeFromString(EDataType eDataType, String initialValue) {
        EffectType result = EffectType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertEffectTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    @Override
    public EffectsPackage getEffectsPackage() {
        return (EffectsPackage)this.getEPackage();
    }

    @Deprecated
    public static EffectsPackage getPackage() {
        return EffectsPackage.eINSTANCE;
    }
}

