/*
 * Decompiled with CFR 0.152.
 */
package effects.provider;

import effects.provider.CategoryEffectItemProvider;
import effects.provider.EffectCategoryItemProvider;
import effects.provider.EffectRepositoryItemProvider;
import effects.provider.QualityEffectItemProvider;
import effects.provider.SimpleEffectItemProvider;
import effects.util.EffectsAdapterFactory;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

public class EffectsItemProviderAdapterFactory
extends EffectsAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IDisposable {
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected SimpleEffectItemProvider simpleEffectItemProvider;
    protected EffectRepositoryItemProvider effectRepositoryItemProvider;
    protected EffectCategoryItemProvider effectCategoryItemProvider;
    protected QualityEffectItemProvider qualityEffectItemProvider;
    protected CategoryEffectItemProvider categoryEffectItemProvider;

    public EffectsItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createSimpleEffectAdapter() {
        if (this.simpleEffectItemProvider == null) {
            this.simpleEffectItemProvider = new SimpleEffectItemProvider((AdapterFactory)this);
        }
        return this.simpleEffectItemProvider;
    }

    public Adapter createEffectRepositoryAdapter() {
        if (this.effectRepositoryItemProvider == null) {
            this.effectRepositoryItemProvider = new EffectRepositoryItemProvider((AdapterFactory)this);
        }
        return this.effectRepositoryItemProvider;
    }

    public Adapter createEffectCategoryAdapter() {
        if (this.effectCategoryItemProvider == null) {
            this.effectCategoryItemProvider = new EffectCategoryItemProvider((AdapterFactory)this);
        }
        return this.effectCategoryItemProvider;
    }

    public Adapter createQualityEffectAdapter() {
        if (this.qualityEffectItemProvider == null) {
            this.qualityEffectItemProvider = new QualityEffectItemProvider((AdapterFactory)this);
        }
        return this.qualityEffectItemProvider;
    }

    public Adapter createCategoryEffectAdapter() {
        if (this.categoryEffectItemProvider == null) {
            this.categoryEffectItemProvider = new CategoryEffectItemProvider((AdapterFactory)this);
        }
        return this.categoryEffectItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.simpleEffectItemProvider != null) {
            this.simpleEffectItemProvider.dispose();
        }
        if (this.effectRepositoryItemProvider != null) {
            this.effectRepositoryItemProvider.dispose();
        }
        if (this.effectCategoryItemProvider != null) {
            this.effectCategoryItemProvider.dispose();
        }
        if (this.qualityEffectItemProvider != null) {
            this.qualityEffectItemProvider.dispose();
        }
        if (this.categoryEffectItemProvider != null) {
            this.categoryEffectItemProvider.dispose();
        }
    }
}

