/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4req.core.derivation;

import decisions.Decision;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.AbstractModification;
import edu.kit.ipd.sdq.kamp.model.modificationmarks.ChangePropagationStep;
import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityElementType;
import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityType;
import edu.kit.ipd.sdq.kamp.workplan.Activity;
import edu.kit.ipd.sdq.kamp.workplan.BasicActivity;
import edu.kit.ipd.sdq.kamp4is.core.ISActivityElementType;
import edu.kit.ipd.sdq.kamp4is.core.ISActivityType;
import edu.kit.ipd.sdq.kamp4is.core.derivation.ISInternalModificationDerivation;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.AbstractISModificationRepository;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.ISModifyDataType;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.provider.ISLabelCustomizing;
import edu.kit.ipd.sdq.kamp4req.core.ReqActivityElementType;
import edu.kit.ipd.sdq.kamp4req.core.ReqArchitectureVersion;
import edu.kit.ipd.sdq.kamp4req.model.modificationmarks.ReqChangePropagationDueToSpecificationDependencies;
import edu.kit.ipd.sdq.kamp4req.model.modificationmarks.ReqModifyEntity;
import edu.kit.ipd.sdq.kamp4req.model.modificationmarks.ReqModifyTraceableObject;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import options.Option;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.DataType;
import relations.TraceableObject;
import requirements.Requirement;

public class ReqInternalModificationDerivation {
    public static List<String> getCausingElementsNames(AbstractModification<?, ?> modification) {
        LinkedList<String> causingElementNames = new LinkedList<String>();
        for (Object causingElement : modification.getCausingElements()) {
            if (causingElement instanceof Entity) {
                Entity causingEntity = (Entity)causingElement;
                causingElementNames.add(String.valueOf(causingEntity.eClass().getName()) + " \"" + causingEntity.getEntityName() + "\"");
                continue;
            }
            if (causingElement instanceof DataType) {
                DataType causingDataType = (DataType)causingElement;
                causingElementNames.add(String.valueOf(causingDataType.eClass().getName()) + " \"" + ISLabelCustomizing.getDataTypeName((DataType)causingDataType) + "\"");
                continue;
            }
            if (!(causingElement instanceof TraceableObject)) continue;
            TraceableObject causingTraceableObject = (TraceableObject)causingElement;
            causingElementNames.add(String.valueOf(causingTraceableObject.eClass().getName()) + " \"" + ReqInternalModificationDerivation.getElementNameForTraceableObject(causingTraceableObject) + "\"");
        }
        return causingElementNames;
    }

    public static Activity createModificationActivity(AbstractModification<?, ?> modification, List<String> causingElementNames, AbstractActivityElementType activityElementType) {
        Activity result = ISInternalModificationDerivation.createModificationActivity(modification, causingElementNames, (AbstractActivityElementType)activityElementType);
        if (result != null) {
            return result;
        }
        if (modification instanceof ReqModifyTraceableObject) {
            TraceableObject traceableObject = (TraceableObject)((ReqModifyTraceableObject)modification).getAffectedElement();
            String elementName = ReqInternalModificationDerivation.getElementNameForTraceableObject(traceableObject);
            return new Activity((AbstractActivityType)ISActivityType.INTERNALMODIFICATIONMARK, activityElementType, (EObject)traceableObject, elementName, causingElementNames, BasicActivity.MODIFY, "Modify " + traceableObject.eClass().getName() + " " + elementName + ".");
        }
        return null;
    }

    public static Activity createModificationActivity(AbstractModification<?, ?> modification, AbstractActivityElementType activityElementType) {
        List<String> causingElementNames = ReqInternalModificationDerivation.getCausingElementsNames(modification);
        return ReqInternalModificationDerivation.createModificationActivity(modification, causingElementNames, activityElementType);
    }

    protected static String getElementNameForTraceableObject(TraceableObject object) {
        if (object instanceof Requirement) {
            return "\"" + ((Requirement)object).getSpecification() + "\"";
        }
        if (object instanceof Decision) {
            return "\"" + ((Decision)object).getDescription() + "\"";
        }
        if (object instanceof Option) {
            return "\"" + ((Option)object).getDescription() + "\"";
        }
        return null;
    }

    public List<Activity> deriveInternalModifications(ReqArchitectureVersion targetVersion) {
        LinkedList<Activity> activityList = new LinkedList<Activity>();
        for (ChangePropagationStep currentPropagationStep : ((AbstractISModificationRepository)targetVersion.getModificationMarkRepository()).getChangePropagationSteps()) {
            if (!(currentPropagationStep instanceof ReqChangePropagationDueToSpecificationDependencies)) continue;
            ReqChangePropagationDueToSpecificationDependencies cp = (ReqChangePropagationDueToSpecificationDependencies)currentPropagationStep;
            this.deriveTraceableObjectModifications((Collection<? extends ReqModifyTraceableObject<?>>)cp.getRequirementModifications(), (List<Activity>)activityList);
            this.deriveTraceableObjectModifications((Collection<? extends ReqModifyTraceableObject<?>>)cp.getDecisionModifications(), (List<Activity>)activityList);
            this.deriveTraceableObjectModifications((Collection<? extends ReqModifyTraceableObject<?>>)cp.getOptionModifications(), (List<Activity>)activityList);
            this.deriveDataTypeModifications((Collection<ISModifyDataType>)cp.getDataTypeModifications(), activityList);
            this.deriveEntityModifications((Collection<? extends ReqModifyEntity>)cp.getEntityModifications(), activityList);
        }
        return activityList;
    }

    private void deriveTraceableObjectModifications(Collection<? extends ReqModifyTraceableObject<?>> modifications, List<Activity> activityList) {
        for (ReqModifyTraceableObject<?> modification : modifications) {
            activityList.add(ReqInternalModificationDerivation.createModificationActivity(modification, ReqActivityElementType.getActivityTypeForObject((EObject)modification.getAffectedElement())));
        }
    }

    private void deriveDataTypeModifications(Collection<ISModifyDataType> modifications, List<Activity> activityList) {
        for (ISModifyDataType modification : modifications) {
            activityList.add(ReqInternalModificationDerivation.createModificationActivity(modification, (AbstractActivityElementType)ISActivityElementType.DATATYPE));
        }
    }

    private void deriveEntityModifications(Collection<? extends ReqModifyEntity> modifications, List<Activity> activityList) {
        for (ReqModifyEntity reqModifyEntity : modifications) {
            activityList.add(ReqInternalModificationDerivation.createModificationActivity(reqModifyEntity, ReqActivityElementType.ENTITY));
        }
    }
}

