/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4req.core;

import de.uhd.ifi.se.pcm.bppcm.datamodel.DataModel;
import de.uhd.ifi.se.pcm.bppcm.organizationenvironmentmodel.OrganizationEnvironmentModel;
import de.uka.ipd.sdq.componentInternalDependencies.ComponentInternalDependencyRepository;
import decisions.DecisionRepository;
import decisions.DecisionsPackage;
import edu.kit.ipd.sdq.kamp.util.FileAndFolderManagement;
import edu.kit.ipd.sdq.kamp4bp.core.BPArchitectureVersion;
import edu.kit.ipd.sdq.kamp4bp.core.BPArchitectureVersionPersistency;
import edu.kit.ipd.sdq.kamp4is.core.AbstractISArchitectureVersionPersistency;
import edu.kit.ipd.sdq.kamp4is.core.ISArchitectureVersion;
import edu.kit.ipd.sdq.kamp4is.model.fieldofactivityannotations.ISFieldOfActivityAnnotationsRepository;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.AbstractISModificationRepository;
import edu.kit.ipd.sdq.kamp4req.core.ReqArchitectureVersion;
import edu.kit.ipd.sdq.kamp4req.model.modificationmarks.ReqModificationmarksPackage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import options.OptionRepository;
import options.OptionsPackage;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.system.System;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import requirements.ReqRepository;
import requirements.RequirementsPackage;

public class ReqArchitectureVersionPersistency
extends AbstractISArchitectureVersionPersistency<ReqArchitectureVersion> {
    public static final String FILEEXTENSION_REQUIREMENTS = "requirements";
    public static final String FILEEXTENSION_DECISIONS = "decisions";
    public static final String FILEEXTENSION_OPTIONS = "options";

    public ReqArchitectureVersion load(String folderpath, String filename, String versionname) {
        ResourceSetImpl loadResourceSet = new ResourceSetImpl();
        String repositoryfilePath = String.valueOf(filename) + "." + "repository";
        String systemfilePath = String.valueOf(filename) + "." + "system";
        String fieldOfActivityRepositoryFilePath = String.valueOf(filename) + "." + "fieldofactivityannotations";
        String internalModFilePath = String.valueOf(filename) + "." + "modificationmarks";
        String cidepfilePath = String.valueOf(filename) + "." + "componentinternaldependencies";
        String usageModelFilePath = String.valueOf(filename) + "." + "usagemodel";
        String bpusageModelFilePath = String.valueOf(filename) + "." + "bpusagemodel";
        String dataModelFilePath = String.valueOf(filename) + "." + "datamodel";
        String orgEnvironmentModelFilePath = String.valueOf(filename) + "." + "organizationenvironmentmodel";
        String requirementsFilePath = String.valueOf(filename) + "." + FILEEXTENSION_REQUIREMENTS;
        String decisionsFilePath = String.valueOf(filename) + "." + FILEEXTENSION_DECISIONS;
        String optionsFilePath = String.valueOf(filename) + "." + FILEEXTENSION_OPTIONS;
        Repository repository = (Repository)this.loadEmfModelFromResource(folderpath, repositoryfilePath, (ResourceSet)loadResourceSet);
        System system = (System)this.loadEmfModelFromResource(folderpath, systemfilePath, (ResourceSet)loadResourceSet);
        ISFieldOfActivityAnnotationsRepository fieldOfActivityRepository = (ISFieldOfActivityAnnotationsRepository)this.loadEmfModelFromResource(folderpath, fieldOfActivityRepositoryFilePath, (ResourceSet)loadResourceSet);
        AbstractISModificationRepository modificationMarkRepository = (AbstractISModificationRepository)this.loadEmfModelFromResource(folderpath, internalModFilePath, (ResourceSet)loadResourceSet);
        ComponentInternalDependencyRepository componentInternalDependencyRepository = (ComponentInternalDependencyRepository)this.loadEmfModelFromResource(folderpath, cidepfilePath, (ResourceSet)loadResourceSet);
        UsageModel usageModel = (UsageModel)this.loadEmfModelFromResource(folderpath, bpusageModelFilePath, (ResourceSet)loadResourceSet);
        if (usageModel == null) {
            usageModel = (UsageModel)this.loadEmfModelFromResource(folderpath, usageModelFilePath, (ResourceSet)loadResourceSet);
        }
        DataModel dataModel = (DataModel)this.loadEmfModelFromResource(folderpath, dataModelFilePath, (ResourceSet)loadResourceSet);
        OrganizationEnvironmentModel orgEnviromentModel = (OrganizationEnvironmentModel)this.loadEmfModelFromResource(folderpath, orgEnvironmentModelFilePath, (ResourceSet)loadResourceSet);
        ReqRepository requirementRepostory = (ReqRepository)this.loadEmfModelFromResource(folderpath, requirementsFilePath, (ResourceSet)loadResourceSet);
        DecisionRepository decisionRepository = (DecisionRepository)this.loadEmfModelFromResource(folderpath, decisionsFilePath, (ResourceSet)loadResourceSet);
        OptionRepository optionRepository = (OptionRepository)this.loadEmfModelFromResource(folderpath, optionsFilePath, (ResourceSet)loadResourceSet);
        return new ReqArchitectureVersion(versionname, repository, system, fieldOfActivityRepository, modificationMarkRepository, componentInternalDependencyRepository, Collections.singletonMap("default", usageModel), dataModel, orgEnviromentModel, requirementRepostory, decisionRepository, optionRepository);
    }

    public ReqArchitectureVersion load(IContainer folder, String versionname) {
        ResourceSetImpl loadResourceSet = new ResourceSetImpl();
        IFile repositoryfile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"repository");
        IFile systemfile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"system");
        IFile fieldOfActivityRepositoryFile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"fieldofactivityannotations");
        IFile internalModFile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"modificationmarks");
        IFile cidepfile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"componentinternaldependencies");
        Collection usageModelFiles = FileAndFolderManagement.retrieveFilesWithExtension((IContainer)folder, (String)"bpusagemodel");
        usageModelFiles.addAll(FileAndFolderManagement.retrieveFilesWithExtension((IContainer)folder, (String)"usagemodel"));
        IFile dataModelFile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"datamodel");
        IFile organizationEnvironmentModelFile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)"organizationenvironmentmodel");
        IFile requirementsFile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)FILEEXTENSION_REQUIREMENTS);
        IFile decisionsFile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)FILEEXTENSION_DECISIONS);
        IFile optionsFile = FileAndFolderManagement.retrieveFileWithExtension((IContainer)folder, (String)FILEEXTENSION_OPTIONS);
        Repository repository = null;
        System system = null;
        ISFieldOfActivityAnnotationsRepository fieldOfActivityRepository = null;
        AbstractISModificationRepository modificationMarkRepository = null;
        ComponentInternalDependencyRepository componentInternalDependencyRepository = null;
        HashMap<String, UsageModel> usageModels = new HashMap<String, UsageModel>();
        DataModel dataModel = null;
        OrganizationEnvironmentModel organizationEnvironmentModel = null;
        ReqRepository requirementRepository = null;
        DecisionRepository decisionRepository = null;
        OptionRepository optionRepository = null;
        if (repositoryfile != null && repositoryfile.exists()) {
            repository = (Repository)this.loadEmfModelFromResource(repositoryfile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (systemfile != null && systemfile.exists()) {
            system = (System)this.loadEmfModelFromResource(systemfile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (fieldOfActivityRepositoryFile != null && fieldOfActivityRepositoryFile.exists()) {
            fieldOfActivityRepository = (ISFieldOfActivityAnnotationsRepository)this.loadEmfModelFromResource(fieldOfActivityRepositoryFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (internalModFile != null && internalModFile.exists()) {
            modificationMarkRepository = (AbstractISModificationRepository)this.loadEmfModelFromResource(internalModFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (cidepfile != null && cidepfile.exists()) {
            componentInternalDependencyRepository = (ComponentInternalDependencyRepository)this.loadEmfModelFromResource(cidepfile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        for (IFile usageModelFile : usageModelFiles) {
            if (usageModelFile == null || !usageModelFile.exists()) continue;
            usageModels.put(usageModelFile.getName(), (UsageModel)this.loadEmfModelFromResource(usageModelFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet));
        }
        if (dataModelFile != null && dataModelFile.exists()) {
            dataModel = (DataModel)this.loadEmfModelFromResource(dataModelFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (organizationEnvironmentModelFile != null && organizationEnvironmentModelFile.exists()) {
            organizationEnvironmentModel = (OrganizationEnvironmentModel)this.loadEmfModelFromResource(organizationEnvironmentModelFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (requirementsFile != null && requirementsFile.exists()) {
            requirementRepository = (ReqRepository)this.loadEmfModelFromResource(requirementsFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (decisionsFile != null && decisionsFile.exists()) {
            decisionRepository = (DecisionRepository)this.loadEmfModelFromResource(decisionsFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        if (optionsFile != null && optionsFile.exists()) {
            optionRepository = (OptionRepository)this.loadEmfModelFromResource(optionsFile.getFullPath().toString(), null, (ResourceSet)loadResourceSet);
        }
        return new ReqArchitectureVersion(versionname, repository, system, fieldOfActivityRepository, modificationMarkRepository, componentInternalDependencyRepository, usageModels, dataModel, organizationEnvironmentModel, requirementRepository, decisionRepository, optionRepository);
    }

    public void save(String targetDirectoryPath, String filename, ReqArchitectureVersion version) {
        ReqArchitectureVersionPersistency.savePCMAndKAMPModels((String)targetDirectoryPath, (String)filename, (ISArchitectureVersion)version);
        BPArchitectureVersionPersistency.saveBusinessProcessModels((String)targetDirectoryPath, (String)filename, (BPArchitectureVersion)version);
        ReqArchitectureVersionPersistency.saveRequirementsModel(targetDirectoryPath, filename, version);
    }

    public static void saveRequirementsModel(String targetDirectoryPath, String filename, ReqArchitectureVersion version) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String requirementsFilePath = String.valueOf(filename) + "." + FILEEXTENSION_REQUIREMENTS;
        String decisionsFilePath = String.valueOf(filename) + "." + FILEEXTENSION_DECISIONS;
        String optionsFilePath = String.valueOf(filename) + "." + FILEEXTENSION_OPTIONS;
        if (version.getRequirementsRepository() != null) {
            ReqArchitectureVersionPersistency.saveEmfModelToResource((EObject)version.getRequirementsRepository(), (String)targetDirectoryPath, (String)requirementsFilePath, (ResourceSet)resourceSet);
        }
        if (version.getDecisionRepository() != null) {
            ReqArchitectureVersionPersistency.saveEmfModelToResource((EObject)version.getDecisionRepository(), (String)targetDirectoryPath, (String)decisionsFilePath, (ResourceSet)resourceSet);
        }
        if (version.getOptionRepository() != null) {
            ReqArchitectureVersionPersistency.saveEmfModelToResource((EObject)version.getOptionRepository(), (String)targetDirectoryPath, (String)optionsFilePath, (ResourceSet)resourceSet);
        }
    }

    protected void registerEPackages(ResourceSet resourceSet) {
        ReqArchitectureVersionPersistency.registerKAMPPackages((ResourceSet)resourceSet);
        BPArchitectureVersionPersistency.registerBusinessProcessPackages((ResourceSet)resourceSet);
        ReqArchitectureVersionPersistency.registerRequirementsPackages(resourceSet);
    }

    public static void registerRequirementsPackages(ResourceSet resourceSet) {
        resourceSet.getPackageRegistry().put((Object)"http://sdq.ipd.kit.edu/KAMP4ReqModificationmarks/1.0", (Object)ReqModificationmarksPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://toometa.de/requirements/0.6", (Object)RequirementsPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://toometa.de/decisions/0.6", (Object)DecisionsPackage.eINSTANCE);
        resourceSet.getPackageRegistry().put((Object)"http://toometa.de/options/0.6", (Object)OptionsPackage.eINSTANCE);
    }
}

