/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4req.core;

import decisions.Decision;
import edu.kit.ipd.sdq.kamp.util.MapUtil;
import edu.kit.ipd.sdq.kamp4req.core.ReqArchitectureVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import options.Option;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.Entity;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.RepositoryComponent;
import pcmarchoptions.PCM_AllocateNeverTogether;
import pcmarchoptions.PCM_AllocateTogether;
import pcmarchoptions.PCM_ChangeDataType;
import pcmarchoptions.PCM_ChangeInterface;
import pcmarchoptions.PCM_ChangeRoles;
import pcmarchoptions.PCM_FunctionalityConnection;
import pcmarchoptions.PCM_IntroduceNewAdapter;
import pcmarchoptions.PCM_IntroduceNewComponent;
import pcmarchoptions.PCM_IntroduceNewDataType;
import pcmarchoptions.PCM_IntroduceNewInterface;
import pcmarchoptions.PCM_MergeComponents;
import pcmarchoptions.PCM_MoveComponents;
import pcmarchoptions.PCM_MultipleAllocation;
import pcmarchoptions.PCM_MultipleInstantiation;
import pcmarchoptions.PCM_NeverAllocateToSpecificNodes;
import pcmarchoptions.PCM_OnlySingleAllocation;
import pcmarchoptions.PCM_OnlySingleInstantiation;
import pcmarchoptions.PCM_ProvidedFunctionality;
import pcmarchoptions.PCM_RemoveDataType;
import pcmarchoptions.PCM_RemoveInterface;
import pcmarchoptions.PCM_ReplaceComponents;
import pcmarchoptions.PCM_RequiredFunctionality;
import pcmarchoptions.PCM_ReuseComponent;
import pcmarchoptions.PCM_SplitComponent;
import pcmbpoptions.PCM_ChangeEntity;
import pcmbpoptions.PCM_IntroduceNewEntity;
import pcmbpoptions.PCM_RemoveEntity;
import relations.CouldResolveObject;
import relations.DependencyObject;
import relations.ResolveObject;
import relations.SelectionObject;
import relations.TriggerObject;
import requirements.Requirement;

public class ReqArchitectureModelLookup {
    public static Map<Requirement, Set<TriggerObject>> lookUpRequirementsTriggeringTriggerObjects(Collection<? extends TriggerObject> triggeredObjects) {
        HashMap<Requirement, Set<TriggerObject>> results = new HashMap<Requirement, Set<TriggerObject>>();
        for (TriggerObject triggerObject : triggeredObjects) {
            for (TriggerObject trigger : triggerObject.getTriggeredBy()) {
                if (!(trigger instanceof Requirement)) continue;
                MapUtil.putOrAddToMap(results, (Object)((Requirement)trigger), (Object)triggerObject);
            }
        }
        return results;
    }

    public static Map<Decision, Set<TriggerObject>> lookUpDecisionsTriggeredByTriggerObjects(Collection<? extends TriggerObject> triggers) {
        HashMap<Decision, Set<TriggerObject>> results = new HashMap<Decision, Set<TriggerObject>>();
        for (TriggerObject triggerObject : triggers) {
            for (TriggerObject triggeredObject : triggerObject.getTriggerOf()) {
                if (!(triggeredObject instanceof Decision)) continue;
                MapUtil.putOrAddToMap(results, (Object)((Decision)triggeredObject), (Object)triggerObject);
            }
        }
        return results;
    }

    public static Map<Option, Set<TriggerObject>> lookUpOptionsTriggeredByTriggerObjects(Collection<? extends TriggerObject> triggers) {
        HashMap<Option, Set<TriggerObject>> results = new HashMap<Option, Set<TriggerObject>>();
        for (TriggerObject triggerObject : triggers) {
            for (TriggerObject triggeredObject : triggerObject.getTriggerOf()) {
                if (!(triggeredObject instanceof Option)) continue;
                MapUtil.putOrAddToMap(results, (Object)((Option)triggeredObject), (Object)triggerObject);
            }
        }
        return results;
    }

    public static Map<Decision, Set<ResolveObject>> lookUpDecisionsResolvingResolveObjects(Collection<? extends ResolveObject> objectsToBeResolved) {
        HashMap<Decision, Set<ResolveObject>> results = new HashMap<Decision, Set<ResolveObject>>();
        for (ResolveObject resolveObject : objectsToBeResolved) {
            for (ResolveObject resolvingObject : resolveObject.getResolvedBy()) {
                if (!(resolvingObject instanceof Decision)) continue;
                MapUtil.putOrAddToMap(results, (Object)((Decision)resolvingObject), (Object)resolveObject);
            }
        }
        return results;
    }

    public static Map<Option, Set<ResolveObject>> lookUpOptionsResolvingResolveObjects(Collection<? extends ResolveObject> objectsToBeResolved) {
        HashMap<Option, Set<ResolveObject>> results = new HashMap<Option, Set<ResolveObject>>();
        for (ResolveObject resolveObject : objectsToBeResolved) {
            for (ResolveObject resolvingObject : resolveObject.getResolvedBy()) {
                if (!(resolvingObject instanceof Option)) continue;
                MapUtil.putOrAddToMap(results, (Object)((Option)resolvingObject), (Object)resolveObject);
            }
        }
        return results;
    }

    public static Map<Decision, Set<CouldResolveObject>> lookUpDecisionsCouldBeResolvingResolveObjects(Collection<? extends CouldResolveObject> objectsToBeResolved) {
        HashMap<Decision, Set<CouldResolveObject>> results = new HashMap<Decision, Set<CouldResolveObject>>();
        for (CouldResolveObject couldResolveObject : objectsToBeResolved) {
            for (CouldResolveObject resolvingObject : couldResolveObject.getCouldBeResolvedBy()) {
                if (!(resolvingObject instanceof Decision)) continue;
                MapUtil.putOrAddToMap(results, (Object)((Decision)resolvingObject), (Object)couldResolveObject);
            }
        }
        return results;
    }

    public static Map<Option, Set<CouldResolveObject>> lookUpOptionsCouldBeResolvingResolveObjects(Collection<? extends CouldResolveObject> objectsToBeResolved) {
        HashMap<Option, Set<CouldResolveObject>> results = new HashMap<Option, Set<CouldResolveObject>>();
        for (CouldResolveObject couldResolveObject : objectsToBeResolved) {
            for (CouldResolveObject resolvingObject : couldResolveObject.getCouldBeResolvedBy()) {
                if (!(resolvingObject instanceof Option)) continue;
                MapUtil.putOrAddToMap(results, (Object)((Option)resolvingObject), (Object)couldResolveObject);
            }
        }
        return results;
    }

    public static Map<DataType, Set<Decision>> lookUpDataTypesReferencedByDecisions(ReqArchitectureVersion version, Collection<? extends Decision> decisions) {
        HashMap<DataType, Set<Decision>> results = new HashMap<DataType, Set<Decision>>();
        for (Decision decision : decisions) {
            for (SelectionObject selection : decision.getSelected()) {
                if (!(selection instanceof Option)) continue;
                for (DataType dataType : version.getRepository().getDataTypes__Repository()) {
                    if (!ReqArchitectureModelLookup.isDataTypeReferencedByOption(dataType, (Option)selection)) continue;
                    MapUtil.putOrAddToMap(results, (Object)dataType, (Object)decision);
                }
            }
        }
        return results;
    }

    public static Map<DataType, Set<Option>> lookUpDataTypesReferencedByOptions(ReqArchitectureVersion version, Collection<? extends Option> options) {
        HashMap<DataType, Set<Option>> results = new HashMap<DataType, Set<Option>>();
        for (Option option : options) {
            for (DataType dataType : version.getRepository().getDataTypes__Repository()) {
                if (!ReqArchitectureModelLookup.isDataTypeReferencedByOption(dataType, option)) continue;
                MapUtil.putOrAddToMap(results, (Object)dataType, (Object)option);
            }
        }
        return results;
    }

    private static boolean isDataTypeReferencedByOption(DataType dataType, Option option) {
        return ReqArchitectureModelLookup.isDataTypeReferencedByIntroduceOption(dataType, option) || ReqArchitectureModelLookup.isDataTypeReferencedByChangeOption(dataType, option) || ReqArchitectureModelLookup.isDataTypeReferencedByRemoveOption(dataType, option);
    }

    private static boolean isDataTypeReferencedByIntroduceOption(DataType dataType, Option option) {
        if (option instanceof PCM_IntroduceNewDataType) {
            PCM_IntroduceNewDataType pcmOption = (PCM_IntroduceNewDataType)option;
            return pcmOption.getDataTypes().contains((Object)dataType);
        }
        return false;
    }

    private static boolean isDataTypeReferencedByChangeOption(DataType dataType, Option option) {
        if (option instanceof PCM_ChangeDataType) {
            PCM_ChangeDataType pcmOption = (PCM_ChangeDataType)option;
            return pcmOption.getOldDataTypes().contains((Object)dataType);
        }
        return false;
    }

    private static boolean isDataTypeReferencedByRemoveOption(DataType dataType, Option option) {
        if (option instanceof PCM_RemoveDataType) {
            PCM_RemoveDataType pcmOption = (PCM_RemoveDataType)option;
            return pcmOption.getDataTypes().contains((Object)dataType);
        }
        return false;
    }

    public static Map<OperationInterface, Set<Decision>> lookUpInterfacesReferencedByDecisions(ReqArchitectureVersion version, Collection<? extends Decision> decisions) {
        HashMap<OperationInterface, Set<Decision>> results = new HashMap<OperationInterface, Set<Decision>>();
        for (Decision decision : decisions) {
            for (SelectionObject selection : decision.getSelected()) {
                if (!(selection instanceof Option)) continue;
                for (Interface interfac : version.getRepository().getInterfaces__Repository()) {
                    if (!(interfac instanceof OperationInterface) || !ReqArchitectureModelLookup.isInterfaceReferencedByOption((OperationInterface)interfac, (Option)selection)) continue;
                    MapUtil.putOrAddToMap(results, (Object)((OperationInterface)interfac), (Object)decision);
                }
            }
        }
        return results;
    }

    public static Map<OperationInterface, Set<Option>> lookUpInterfacesReferencedByOptions(ReqArchitectureVersion version, Collection<? extends Option> options) {
        HashMap<OperationInterface, Set<Option>> results = new HashMap<OperationInterface, Set<Option>>();
        for (Option option : options) {
            for (Interface interfac : version.getRepository().getInterfaces__Repository()) {
                if (!(interfac instanceof OperationInterface) || !ReqArchitectureModelLookup.isInterfaceReferencedByOption((OperationInterface)interfac, option)) continue;
                MapUtil.putOrAddToMap(results, (Object)((OperationInterface)interfac), (Object)option);
            }
        }
        return results;
    }

    private static boolean isInterfaceReferencedByOption(OperationInterface interfac, Option option) {
        return ReqArchitectureModelLookup.isInterfaceReferencedByIntroduceOption(interfac, option) || ReqArchitectureModelLookup.isInterfaceReferencedByChangeOption(interfac, option) || ReqArchitectureModelLookup.isInterfaceReferencedByRemoveOption(interfac, option);
    }

    private static boolean isInterfaceReferencedByIntroduceOption(OperationInterface interfac, Option option) {
        if (option instanceof PCM_IntroduceNewInterface) {
            PCM_IntroduceNewInterface pcmOption = (PCM_IntroduceNewInterface)option;
            return pcmOption.getInterfaces().contains((Object)interfac);
        }
        return false;
    }

    private static boolean isInterfaceReferencedByChangeOption(OperationInterface interfac, Option option) {
        if (option instanceof PCM_ChangeDataType) {
            PCM_ChangeInterface pcmOption = (PCM_ChangeInterface)option;
            return pcmOption.getOldInterfaces().contains((Object)interfac);
        }
        return false;
    }

    private static boolean isInterfaceReferencedByRemoveOption(OperationInterface interfac, Option option) {
        if (option instanceof PCM_RemoveInterface) {
            PCM_RemoveInterface pcmOption = (PCM_RemoveInterface)option;
            return pcmOption.getInterfaces().contains((Object)interfac);
        }
        return false;
    }

    public static Map<RepositoryComponent, Set<Decision>> lookUpComponentsReferencedByDecisions(ReqArchitectureVersion version, Collection<? extends Decision> decisions) {
        HashMap<RepositoryComponent, Set<Decision>> results = new HashMap<RepositoryComponent, Set<Decision>>();
        for (Decision decision : decisions) {
            for (SelectionObject selection : decision.getSelected()) {
                if (!(selection instanceof Option)) continue;
                for (RepositoryComponent component : version.getRepository().getComponents__Repository()) {
                    if (!ReqArchitectureModelLookup.isComponentReferencedByOption(component, (Option)selection)) continue;
                    MapUtil.putOrAddToMap(results, (Object)component, (Object)decision);
                }
            }
        }
        return results;
    }

    public static Map<RepositoryComponent, Set<Option>> lookUpComponentsReferencedByOptions(ReqArchitectureVersion version, Collection<? extends Option> options) {
        HashMap<RepositoryComponent, Set<Option>> results = new HashMap<RepositoryComponent, Set<Option>>();
        for (Option option : options) {
            for (RepositoryComponent repositoryComponent : version.getRepository().getComponents__Repository()) {
                if (!ReqArchitectureModelLookup.isComponentReferencedByOption(repositoryComponent, option)) continue;
                MapUtil.putOrAddToMap(results, (Object)repositoryComponent, (Object)option);
            }
        }
        return results;
    }

    private static boolean isComponentReferencedByOption(RepositoryComponent component, Option option) {
        return ReqArchitectureModelLookup.isComponentReferencedByFunctionalityConnectionOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByRequiredFunctionalityOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByProvidedFunctionalityOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByOnlySingleAllocationOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByAllocateTogetherOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByAllocateNeverTogetherOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByMultipleAllocationOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByNeverAllocateToSpecificNodesOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByMoveComponentsOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByChangeRolesOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByMultipleInstantiationOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByOnlySingleInstantiationOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByReplaceComponentsOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByBanComponentOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByReuseComponentOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedBySplitComponentOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByMergeComponentOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByIntroduceNewComponentOption(component, option) || ReqArchitectureModelLookup.isComponentReferencedByIntroduceNewAdapterOption(component, option);
    }

    private static boolean isComponentReferencedByFunctionalityConnectionOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_FunctionalityConnection) {
            PCM_FunctionalityConnection pcmOption = (PCM_FunctionalityConnection)option;
            return pcmOption.getConnector() != null && (pcmOption.getConnector().getProvidingAssemblyContext_AssemblyConnector().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent) || pcmOption.getConnector().getRequiringAssemblyContext_AssemblyConnector().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent));
        }
        return false;
    }

    private static boolean isComponentReferencedByRequiredFunctionalityOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_RequiredFunctionality) {
            PCM_RequiredFunctionality pcmOption = (PCM_RequiredFunctionality)option;
            ArrayList commonRequiredRoles = new ArrayList(repositoryComponent.getRequiredRoles_InterfaceRequiringEntity());
            commonRequiredRoles.retainAll((Collection<?>)pcmOption.getRequiredRoles());
            return !commonRequiredRoles.isEmpty();
        }
        return false;
    }

    private static boolean isComponentReferencedByProvidedFunctionalityOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_ProvidedFunctionality) {
            PCM_ProvidedFunctionality pcmOption = (PCM_ProvidedFunctionality)option;
            ArrayList commonProvidedRoles = new ArrayList(repositoryComponent.getProvidedRoles_InterfaceProvidingEntity());
            commonProvidedRoles.retainAll((Collection<?>)pcmOption.getProvidedRoles());
            return !commonProvidedRoles.isEmpty();
        }
        return false;
    }

    private static boolean isComponentReferencedByOnlySingleAllocationOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_OnlySingleAllocation) {
            PCM_OnlySingleAllocation pcmOption = (PCM_OnlySingleAllocation)option;
            for (AllocationContext allocationContext : pcmOption.getAllocationContexts()) {
                if (!allocationContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isComponentReferencedByAllocateTogetherOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_AllocateTogether) {
            PCM_AllocateTogether pcmOption = (PCM_AllocateTogether)option;
            for (AllocationContext pcmOptionAllocationContext : pcmOption.getAllocationContexts()) {
                if (!pcmOptionAllocationContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isComponentReferencedByAllocateNeverTogetherOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_AllocateNeverTogether) {
            PCM_AllocateNeverTogether pcmOption = (PCM_AllocateNeverTogether)option;
            for (AllocationContext pcmOptionAllocationContext : pcmOption.getAllocationContexts()) {
                if (!pcmOptionAllocationContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isComponentReferencedByMultipleAllocationOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_MultipleAllocation) {
            PCM_MultipleAllocation pcmOption = (PCM_MultipleAllocation)option;
            for (AllocationContext pcmOptionAllocationContext : pcmOption.getAllocationContexts()) {
                if (!pcmOptionAllocationContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isComponentReferencedByNeverAllocateToSpecificNodesOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_NeverAllocateToSpecificNodes) {
            PCM_NeverAllocateToSpecificNodes pcmOption = (PCM_NeverAllocateToSpecificNodes)option;
            for (AllocationContext pcmOptionAllocationContext : pcmOption.getAllocationContexts()) {
                if (!pcmOptionAllocationContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isComponentReferencedByMoveComponentsOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_MoveComponents) {
            PCM_MoveComponents pcmOption = (PCM_MoveComponents)option;
            for (AllocationContext pcmOptionAllocationContext : pcmOption.getAllocationContexts()) {
                if (!pcmOptionAllocationContext.getAssemblyContext_AllocationContext().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isComponentReferencedByChangeRolesOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_ChangeRoles) {
            PCM_ChangeRoles pcmOption = (PCM_ChangeRoles)option;
            return pcmOption.getAssemblyContext() != null && pcmOption.getAssemblyContext().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent);
        }
        return false;
    }

    private static boolean isComponentReferencedByMultipleInstantiationOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_MultipleInstantiation) {
            PCM_MultipleInstantiation pcmOption = (PCM_MultipleInstantiation)option;
            for (AssemblyContext pcmOptionAssemblyContext : pcmOption.getAssemblyContexts()) {
                if (!pcmOptionAssemblyContext.getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isComponentReferencedByOnlySingleInstantiationOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_OnlySingleInstantiation) {
            PCM_OnlySingleInstantiation pcmOption = (PCM_OnlySingleInstantiation)option;
            for (AssemblyContext assemblyContext : pcmOption.getAssemblyContexts()) {
                if (!assemblyContext.getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isComponentReferencedByReplaceComponentsOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_ReplaceComponents) {
            PCM_ReplaceComponents pcmOption = (PCM_ReplaceComponents)option;
            for (AssemblyContext assemblyContext : pcmOption.getContextsReplacedWith()) {
                if (!assemblyContext.getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isComponentReferencedByBanComponentOption(RepositoryComponent repositoryComponent, Option option) {
        return false;
    }

    private static boolean isComponentReferencedByReuseComponentOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_ReuseComponent) {
            PCM_ReuseComponent pcmOption = (PCM_ReuseComponent)option;
            for (AssemblyContext assemblyContext : pcmOption.getAssemblyContexts()) {
                if (!assemblyContext.getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isComponentReferencedBySplitComponentOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_SplitComponent) {
            PCM_SplitComponent pcmOption = (PCM_SplitComponent)option;
            for (AssemblyContext pcmOptionAssemblyContext : pcmOption.getFinalContexts()) {
                if (!pcmOptionAssemblyContext.getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private static boolean isComponentReferencedByMergeComponentOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_MergeComponents) {
            PCM_MergeComponents pcmOption = (PCM_MergeComponents)option;
            return pcmOption.getFinalContext() != null && pcmOption.getFinalContext().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent);
        }
        return false;
    }

    private static boolean isComponentReferencedByIntroduceNewComponentOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_IntroduceNewComponent) {
            PCM_IntroduceNewComponent pcmOption = (PCM_IntroduceNewComponent)option;
            for (AssemblyContext assemblyContext : pcmOption.getAssemblyContexts()) {
                if (!assemblyContext.getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isComponentReferencedByIntroduceNewAdapterOption(RepositoryComponent repositoryComponent, Option option) {
        if (option instanceof PCM_IntroduceNewAdapter) {
            PCM_IntroduceNewAdapter pcmOption = (PCM_IntroduceNewAdapter)option;
            return pcmOption.getContextBeingAdapted() != null && pcmOption.getContextBeingAdapted().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent) || pcmOption.getAdapterContext() != null && pcmOption.getAdapterContext().getEncapsulatedComponent__AssemblyContext().equals(repositoryComponent);
        }
        return false;
    }

    public static <T extends DependencyObject> Map<T, Set<DependencyObject>> lookUpObjectsDependOnObjects(Collection<? extends DependencyObject> sourceDependencyObjects, Class<T> dependencyObjectsClass) {
        HashMap results = new HashMap();
        LinkedList<? extends DependencyObject> dependenciesToVisit = new LinkedList<DependencyObject>(sourceDependencyObjects);
        while (!dependenciesToVisit.isEmpty()) {
            DependencyObject sourceDependencyObject = (DependencyObject)dependenciesToVisit.remove(0);
            for (DependencyObject targetDependencyObject : sourceDependencyObject.getHasDependents()) {
                if (!dependencyObjectsClass.isAssignableFrom(targetDependencyObject.getClass())) continue;
                if (!dependenciesToVisit.contains(targetDependencyObject) && !results.containsKey(targetDependencyObject)) {
                    dependenciesToVisit.add((DependencyObject)targetDependencyObject);
                }
                MapUtil.putOrAddToMap(results, (Object)targetDependencyObject, (Object)sourceDependencyObject);
            }
        }
        return results;
    }

    public static <T extends DependencyObject> Map<T, Set<DependencyObject>> lookUpObjectsAnotherObjectDependsOn(Collection<? extends DependencyObject> targetDependencyObjects, Class<T> dependencyObjectClass) {
        HashMap results = new HashMap();
        LinkedList<? extends DependencyObject> dependenciesToVisit = new LinkedList<DependencyObject>(targetDependencyObjects);
        while (!dependenciesToVisit.isEmpty()) {
            DependencyObject targetDependencyObject = (DependencyObject)dependenciesToVisit.remove(0);
            for (DependencyObject sourceDependencyObject : targetDependencyObject.getDependsOn()) {
                if (!dependencyObjectClass.isAssignableFrom(sourceDependencyObject.getClass())) continue;
                if (!dependenciesToVisit.contains(sourceDependencyObject) && !results.containsKey(sourceDependencyObject)) {
                    dependenciesToVisit.add((DependencyObject)sourceDependencyObject);
                }
                MapUtil.putOrAddToMap(results, (Object)sourceDependencyObject, (Object)targetDependencyObject);
            }
        }
        return results;
    }

    public static Map<Entity, Set<Decision>> lookUpEntitiesReferencedByDecisions(ReqArchitectureVersion version, Collection<? extends Decision> decisions) {
        HashMap<Entity, Set<Decision>> results = new HashMap<Entity, Set<Decision>>();
        for (Decision decision : decisions) {
            for (SelectionObject selection : decision.getSelected()) {
                if (selection instanceof PCM_IntroduceNewEntity) {
                    for (Entity entity : ((PCM_IntroduceNewEntity)selection).getEntities()) {
                        MapUtil.putOrAddToMap(results, (Object)entity, (Object)decision);
                    }
                    continue;
                }
                if (selection instanceof PCM_ChangeEntity) {
                    for (Entity entity : ((PCM_ChangeEntity)selection).getOldEntities()) {
                        MapUtil.putOrAddToMap(results, (Object)entity, (Object)decision);
                    }
                    continue;
                }
                if (!(selection instanceof PCM_RemoveEntity)) continue;
                for (Entity entity : ((PCM_RemoveEntity)selection).getEntities()) {
                    MapUtil.putOrAddToMap(results, (Object)entity, (Object)decision);
                }
            }
        }
        return results;
    }

    public static Map<Entity, Set<Option>> lookUpEntitiesReferencedByOptions(ReqArchitectureVersion version, Collection<? extends Option> options) {
        HashMap<Entity, Set<Option>> results = new HashMap<Entity, Set<Option>>();
        for (Option option : options) {
            if (option instanceof PCM_IntroduceNewEntity) {
                for (Entity entity : ((PCM_IntroduceNewEntity)option).getEntities()) {
                    MapUtil.putOrAddToMap(results, (Object)entity, (Object)option);
                }
                continue;
            }
            if (option instanceof PCM_ChangeEntity) {
                for (Entity entity : ((PCM_ChangeEntity)option).getOldEntities()) {
                    MapUtil.putOrAddToMap(results, (Object)entity, (Object)option);
                }
                continue;
            }
            if (!(option instanceof PCM_RemoveEntity)) continue;
            for (Entity entity : ((PCM_RemoveEntity)option).getEntities()) {
                MapUtil.putOrAddToMap(results, (Object)entity, (Object)option);
            }
        }
        return results;
    }
}

