/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4is.core.derivation;

import edu.kit.ipd.sdq.kamp.derivation.AbstractDifferenceCalculation;
import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityElementType;
import edu.kit.ipd.sdq.kamp.workplan.AbstractActivityType;
import edu.kit.ipd.sdq.kamp.workplan.Activity;
import edu.kit.ipd.sdq.kamp.workplan.BasicActivity;
import edu.kit.ipd.sdq.kamp4is.core.ISActivityElementType;
import edu.kit.ipd.sdq.kamp4is.core.ISActivityType;
import edu.kit.ipd.sdq.kamp4is.core.ISArchitectureVersion;
import edu.kit.ipd.sdq.kamp4is.core.derivation.ISInternalModificationDerivation;
import edu.kit.ipd.sdq.kamp4is.core.derivation.ISSubactivityDerivation;
import edu.kit.ipd.sdq.kamp4is.model.modificationmarks.provider.ISLabelCustomizing;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.core.entity.NamedElement;
import org.palladiosimulator.pcm.repository.DataType;

public class ISDifferenceCalculation
extends AbstractDifferenceCalculation<ISArchitectureVersion> {
    private final ISInternalModificationDerivation architectureInternalModificationDerivation = new ISInternalModificationDerivation();
    private final ISSubactivityDerivation architectureSubactivityDerivation = new ISSubactivityDerivation();

    public void checkForDifferencesAndAddToWorkplan(Diff diffElement, List<Activity> workplan) {
        ISActivityElementType[] iSActivityElementTypeArray = ISActivityElementType.topLevelPCMActivityElementTypes();
        int n = iSActivityElementTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ISActivityElementType elementType = iSActivityElementTypeArray[n2];
            if (ISDifferenceCalculation.detectionRuleAdded((Diff)diffElement, elementType.getElementClass())) {
                if (elementType == ISActivityElementType.DATATYPE) {
                    DataType architectureElement = (DataType)((ReferenceChange)diffElement).getValue();
                    workplan.add(new Activity((AbstractActivityType)ISActivityType.ARCHITECTUREMODELDIFF, (AbstractActivityElementType)elementType, (EObject)architectureElement, ISLabelCustomizing.getDataTypeName((DataType)architectureElement), null, BasicActivity.ADD, ISDifferenceCalculation.createAddElementDescription(architectureElement)));
                } else {
                    NamedElement architectureElement = (NamedElement)((ReferenceChange)diffElement).getValue();
                    Activity newActivity = new Activity((AbstractActivityType)ISActivityType.ARCHITECTUREMODELDIFF, (AbstractActivityElementType)elementType, (EObject)architectureElement, architectureElement.getEntityName(), null, BasicActivity.ADD, ISDifferenceCalculation.createAddElementDescription(architectureElement));
                    workplan.add(newActivity);
                    this.architectureSubactivityDerivation.deriveSubactivities(architectureElement, newActivity);
                }
                return;
            }
            if (ISDifferenceCalculation.detectionRuleDeleted((Diff)diffElement, elementType.getElementClass())) {
                if (elementType == ISActivityElementType.DATATYPE) {
                    DataType architectureElement = (DataType)((ReferenceChange)diffElement).getValue();
                    workplan.add(new Activity((AbstractActivityType)ISActivityType.ARCHITECTUREMODELDIFF, (AbstractActivityElementType)elementType, (EObject)architectureElement, ISLabelCustomizing.getDataTypeName((DataType)architectureElement), null, BasicActivity.REMOVE, ISDifferenceCalculation.createRemoveElementDescription(architectureElement)));
                } else {
                    NamedElement architectureElement = (NamedElement)((ReferenceChange)diffElement).getValue();
                    Activity newActivity = new Activity((AbstractActivityType)ISActivityType.ARCHITECTUREMODELDIFF, (AbstractActivityElementType)elementType, (EObject)architectureElement, architectureElement.getEntityName(), null, BasicActivity.REMOVE, ISDifferenceCalculation.createRemoveElementDescription(architectureElement));
                    workplan.add(newActivity);
                    this.architectureSubactivityDerivation.deriveSubactivities(architectureElement, newActivity);
                }
                return;
            }
            ++n2;
        }
    }

    public List<Activity> deriveWorkplan(ISArchitectureVersion baseVersion, ISArchitectureVersion targetVersion) {
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        List repositoryDiff = ISDifferenceCalculation.calculateDiffModel((EObject)baseVersion.getRepository(), (EObject)targetVersion.getRepository());
        List systemDiff = ISDifferenceCalculation.calculateDiffModel((EObject)baseVersion.getSystem(), (EObject)targetVersion.getSystem());
        List repositoryActivities = this.deriveAddAndRemoveActivities(repositoryDiff);
        activityList.addAll(repositoryActivities);
        List systemActivities = this.deriveAddAndRemoveActivities(systemDiff);
        activityList.addAll(systemActivities);
        List<Activity> internalModificationActivities = this.architectureInternalModificationDerivation.deriveInternalModifications(targetVersion);
        activityList.addAll(internalModificationActivities);
        return activityList;
    }

    public static String createAddElementDescription(NamedElement element) {
        return "Add " + element.eClass().getName() + " " + element.getEntityName() + ".";
    }

    public static String createAddElementDescription(DataType element) {
        return "Add " + element.eClass().getName() + " " + element.toString() + ".";
    }

    public static String createRemoveElementDescription(NamedElement element) {
        return "Remove " + element.eClass().getName() + " " + element.getEntityName() + ".";
    }

    public static String createRemoveElementDescription(DataType element) {
        return "Remove " + element.eClass().getName() + " " + ISLabelCustomizing.getDataTypeName((DataType)element) + ".";
    }
}

