/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp4bp.core;

import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.AcquireDeviceResourceAction;
import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.Activity;
import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.ActorStep;
import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.ReleaseDeviceResourceAction;
import de.uhd.ifi.se.pcm.bppcm.datamodel.CollectionDataObject;
import de.uhd.ifi.se.pcm.bppcm.datamodel.CompositeDataObject;
import de.uhd.ifi.se.pcm.bppcm.datamodel.DataObject;
import de.uhd.ifi.se.pcm.bppcm.datamodel.InnerDataObjectDeclaration;
import de.uhd.ifi.se.pcm.bppcm.organizationenvironmentmodel.DeviceResource;
import de.uhd.ifi.se.pcm.bppcm.organizationenvironmentmodel.Role;
import edu.kit.ipd.sdq.kamp.util.MapUtil;
import edu.kit.ipd.sdq.kamp4bp.core.BPArchitectureVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.InnerDeclaration;
import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.OperationInterface;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

public class BPArchitectureModelLookup {
    public static List<AcquireDeviceResourceAction> lookUpAcquireDeviceResourceActionsWithDeviceResources(BPArchitectureVersion version, Collection<DeviceResource> deviceResources) {
        LinkedList<AcquireDeviceResourceAction> results = new LinkedList<AcquireDeviceResourceAction>();
        for (AbstractUserAction action : BPArchitectureModelLookup.lookUpAllUserActions(version)) {
            if (!(action instanceof AcquireDeviceResourceAction) || !deviceResources.contains(((AcquireDeviceResourceAction)action).getPassiveresource_AcquireAction())) continue;
            results.add((AcquireDeviceResourceAction)action);
        }
        return results;
    }

    public static Map<EntryLevelSystemCall, Set<DataType>> lookUpEntryLevelSystemCallsWithParameterOfTypes(BPArchitectureVersion version, Collection<DataType> datatypes) {
        HashMap<EntryLevelSystemCall, Set<DataType>> results = new HashMap<EntryLevelSystemCall, Set<DataType>>();
        for (AbstractUserAction action : BPArchitectureModelLookup.lookUpAllUserActions(version)) {
            if (!(action instanceof EntryLevelSystemCall)) continue;
            EntryLevelSystemCall entryLevelSystemCall = (EntryLevelSystemCall)action;
            OperationSignature signature = entryLevelSystemCall.getOperationSignature__EntryLevelSystemCall();
            for (DataType datatype : datatypes) {
                for (Parameter parameter : signature.getParameters__OperationSignature()) {
                    if (!parameter.getDataType__Parameter().equals(datatype)) continue;
                    MapUtil.putOrAddToMap(results, (Object)entryLevelSystemCall, (Object)datatype);
                }
                if (!datatype.equals(signature.getReturnType__OperationSignature())) continue;
                MapUtil.putOrAddToMap(results, (Object)entryLevelSystemCall, (Object)datatype);
            }
        }
        return results;
    }

    public static List<EntryLevelSystemCall> lookUpEntryLevelSystemCallsWithSignatures(BPArchitectureVersion version, Collection<OperationSignature> signatures) {
        LinkedList<EntryLevelSystemCall> results = new LinkedList<EntryLevelSystemCall>();
        for (AbstractUserAction action : BPArchitectureModelLookup.lookUpAllUserActions(version)) {
            if (!(action instanceof EntryLevelSystemCall) || !signatures.contains(((EntryLevelSystemCall)action).getOperationSignature__EntryLevelSystemCall())) continue;
            results.add((EntryLevelSystemCall)action);
        }
        return results;
    }

    public static Map<ActorStep, Set<DataObject<?>>> lookUpActorStepsWithDataObjects(BPArchitectureVersion version, Collection<DataObject<?>> dataObjects) {
        HashMap results = new HashMap();
        for (AbstractUserAction action : BPArchitectureModelLookup.lookUpAllUserActions(version)) {
            if (!(action instanceof ActorStep)) continue;
            BPArchitectureModelLookup.collectActorStepsWithDataObjects(dataObjects, results, (ActorStep)action);
        }
        return results;
    }

    private static void collectActorStepsWithDataObjects(Collection<DataObject<?>> dataObjects, Map<ActorStep, Set<DataObject<?>>> results, ActorStep actorStep) {
        for (DataObject<?> dataObject : dataObjects) {
            if (!actorStep.getInputDataObjects().contains(dataObject) && !actorStep.getOutputDataObjects().contains(dataObject)) continue;
            if (!results.containsKey(actorStep)) {
                results.put(actorStep, new HashSet());
            }
            results.get(actorStep).add(dataObject);
        }
    }

    public static List<ActorStep> lookUpActorStepsWithRoles(BPArchitectureVersion version, Collection<Role> roles) {
        LinkedList<ActorStep> results = new LinkedList<ActorStep>();
        for (AbstractUserAction action : BPArchitectureModelLookup.lookUpAllUserActions(version)) {
            ActorStep actorStep;
            if (!(action instanceof ActorStep) || !roles.contains((actorStep = (ActorStep)action).getResponsibleRole())) continue;
            results.add(actorStep);
        }
        return results;
    }

    public static Map<AbstractUserAction, List<ActorStep>> lookUpUserActionsAfterMarkedActorSteps(Collection<ActorStep> initiallyMarkedActorSteps, BPArchitectureVersion version) {
        HashMap<AbstractUserAction, List<ActorStep>> results = new HashMap<AbstractUserAction, List<ActorStep>>();
        Map<DataObject<?>, Set<DataObject<?>>> dataObjectContainerMap = BPArchitectureModelLookup.lookUpAllDataObjectsWithContainers(version);
        for (Map.Entry<String, UsageModel> usageModelEntry : version.getUsageModels().entrySet()) {
            for (UsageScenario usageScenario : usageModelEntry.getValue().getUsageScenario_UsageModel()) {
                results.putAll(BPArchitectureModelLookup.lookUpUserActionsAfterMarkedActorSteps(initiallyMarkedActorSteps, new LinkedList<ActorStep>(), usageScenario.getScenarioBehaviour_UsageScenario(), dataObjectContainerMap));
            }
        }
        return results;
    }

    private static Map<AbstractUserAction, List<ActorStep>> lookUpUserActionsAfterMarkedActorSteps(Collection<ActorStep> initiallyMarkedActorSteps, Collection<ActorStep> precedingMarkedActorSteps, ScenarioBehaviour scenarioBehaviour, Map<DataObject<?>, Set<DataObject<?>>> dataObjectContainerMap) {
        HashMap<AbstractUserAction, List<ActorStep>> results = new HashMap<AbstractUserAction, List<ActorStep>>();
        Start currentUserAction = BPArchitectureModelLookup.lookUpStartInScenarioBehavior(scenarioBehaviour);
        while (currentUserAction != null) {
            if (currentUserAction instanceof Loop) {
                results.putAll(BPArchitectureModelLookup.lookUpUserActionsAfterMarkedActorSteps(initiallyMarkedActorSteps, precedingMarkedActorSteps, ((Loop)currentUserAction).getBodyBehaviour_Loop(), dataObjectContainerMap));
            } else if (currentUserAction instanceof Branch) {
                results.putAll(BPArchitectureModelLookup.lookUpUserActionsAfterMarkedActorSteps(initiallyMarkedActorSteps, precedingMarkedActorSteps, (Branch)currentUserAction, dataObjectContainerMap));
            } else if (currentUserAction instanceof ActorStep) {
                BPArchitectureModelLookup.collectActorStepWithDependency(initiallyMarkedActorSteps, precedingMarkedActorSteps, (ActorStep)currentUserAction, results);
            } else if (currentUserAction instanceof EntryLevelSystemCall) {
                BPArchitectureModelLookup.collectEntryLevelSystemCallWithDependency(precedingMarkedActorSteps, (EntryLevelSystemCall)currentUserAction, dataObjectContainerMap, results);
            }
            currentUserAction = currentUserAction.getSuccessor();
        }
        return results;
    }

    private static Start lookUpStartInScenarioBehavior(ScenarioBehaviour scenarioBehaviour) {
        Start result = null;
        for (AbstractUserAction userAction : scenarioBehaviour.getActions_ScenarioBehaviour()) {
            if (!(userAction instanceof Start)) continue;
            result = (Start)userAction;
            break;
        }
        return result;
    }

    private static Map<AbstractUserAction, List<ActorStep>> lookUpUserActionsAfterMarkedActorSteps(Collection<ActorStep> initiallyMarkedActorSteps, Collection<ActorStep> precedingMarkedActorSteps, Branch branch, Map<DataObject<?>, Set<DataObject<?>>> dataObjectContainerMap) {
        HashMap<AbstractUserAction, List<ActorStep>> results = new HashMap<AbstractUserAction, List<ActorStep>>();
        LinkedList<ActorStep> markedActorStepsInAllBranches = new LinkedList<ActorStep>();
        for (BranchTransition branchTransition : branch.getBranchTransitions_Branch()) {
            LinkedList<ActorStep> markedActorStepsInCurrentBranch = new LinkedList<ActorStep>(precedingMarkedActorSteps);
            results.putAll(BPArchitectureModelLookup.lookUpUserActionsAfterMarkedActorSteps(initiallyMarkedActorSteps, markedActorStepsInCurrentBranch, branchTransition.getBranchedBehaviour_BranchTransition(), dataObjectContainerMap));
            markedActorStepsInCurrentBranch.removeAll(precedingMarkedActorSteps);
            markedActorStepsInAllBranches.addAll(markedActorStepsInCurrentBranch);
        }
        precedingMarkedActorSteps.addAll(markedActorStepsInAllBranches);
        return results;
    }

    private static void collectActorStepWithDependency(Collection<ActorStep> initiallyMarkedActorSteps, Collection<ActorStep> precedingMarkedActorSteps, ActorStep currentActorStep, Map<AbstractUserAction, List<ActorStep>> userActionsToBeMarked) {
        LinkedList<ActorStep> relevantPredecessorsForCurrentStep = new LinkedList<ActorStep>();
        for (ActorStep precedingActorStep : precedingMarkedActorSteps) {
            ArrayList sharedDataObjects = new ArrayList(precedingActorStep.getOutputDataObjects());
            sharedDataObjects.retainAll(BPArchitectureModelLookup.lookUpContainedDataObjects(currentActorStep.getInputDataObjects()));
            if (sharedDataObjects.isEmpty()) continue;
            relevantPredecessorsForCurrentStep.add(precedingActorStep);
        }
        if (!relevantPredecessorsForCurrentStep.isEmpty() || initiallyMarkedActorSteps.contains(currentActorStep)) {
            precedingMarkedActorSteps.add(currentActorStep);
            if (!relevantPredecessorsForCurrentStep.isEmpty()) {
                userActionsToBeMarked.put((AbstractUserAction)currentActorStep, relevantPredecessorsForCurrentStep);
            }
        }
    }

    private static void collectEntryLevelSystemCallWithDependency(Collection<ActorStep> precedingMarkedActorSteps, EntryLevelSystemCall currentELSC, Map<DataObject<?>, Set<DataObject<?>>> dataObjectContainerMap, Map<AbstractUserAction, List<ActorStep>> userActionsToBeMarked) {
        LinkedList<ActorStep> relevantPredecessorsForCurrentStep = new LinkedList<ActorStep>();
        block0: for (ActorStep precedingActorStep : precedingMarkedActorSteps) {
            HashSet outputAndContainerDataObjects = new HashSet(precedingActorStep.getOutputDataObjects());
            for (DataObject outputDataObject : precedingActorStep.getOutputDataObjects()) {
                outputAndContainerDataObjects.addAll(dataObjectContainerMap.get(outputDataObject));
            }
            for (DataObject currentOutputDataObject : outputAndContainerDataObjects) {
                for (Parameter currentELSCParameter : currentELSC.getOperationSignature__EntryLevelSystemCall().getParameters__OperationSignature()) {
                    if (!currentOutputDataObject.getDataTypes().contains((Object)currentELSCParameter.getDataType__Parameter())) continue;
                    relevantPredecessorsForCurrentStep.add(precedingActorStep);
                    continue block0;
                }
            }
        }
        if (!relevantPredecessorsForCurrentStep.isEmpty()) {
            userActionsToBeMarked.put((AbstractUserAction)currentELSC, relevantPredecessorsForCurrentStep);
        }
    }

    public static List<DataObject<?>> lookUpAllDataObjects(BPArchitectureVersion version) {
        ArrayList result = new ArrayList();
        result.addAll((Collection<DataObject<?>>)version.getDataModel().getDataObjects());
        return result;
    }

    public static Map<DataObject<?>, Set<DataObject<?>>> lookUpAllDataObjectsWithContainers(BPArchitectureVersion version) {
        HashMap result = new HashMap();
        LinkedList dataObjectsToVisit = new LinkedList(BPArchitectureModelLookup.lookUpAllDataObjects(version));
        for (DataObject dataObject : dataObjectsToVisit) {
            result.put(dataObject, new HashSet());
        }
        while (!dataObjectsToVisit.isEmpty()) {
            DataObject dataObject = (DataObject)dataObjectsToVisit.remove(0);
            for (DataObject parentDataObject : (Set)result.get(dataObject)) {
                ((Set)result.get(dataObject)).addAll((Collection)result.get(parentDataObject));
            }
            if (dataObject instanceof CollectionDataObject) {
                for (DataObject innerDataObject : ((CollectionDataObject)dataObject).getInnerDataObjects()) {
                    ((Set)result.get(innerDataObject)).add(dataObject);
                    if (innerDataObject.equals(dataObject) || result.containsKey(innerDataObject)) continue;
                    dataObjectsToVisit.add(innerDataObject);
                }
                continue;
            }
            if (!(dataObject instanceof CompositeDataObject)) continue;
            for (InnerDataObjectDeclaration innerDataObjectDeclaration : ((CompositeDataObject)dataObject).getInnerDataObjectDeclarations()) {
                ((Set)result.get(innerDataObjectDeclaration.getDataObject())).add(dataObject);
                if (innerDataObjectDeclaration.getDataObject().equals(dataObject) || result.containsKey(innerDataObjectDeclaration.getDataObject())) continue;
                dataObjectsToVisit.add(innerDataObjectDeclaration.getDataObject());
            }
        }
        return result;
    }

    public static Set<DataObject<?>> lookUpContainedDataObjects(Collection<DataObject<?>> dataObjects) {
        HashSet results = new HashSet();
        LinkedList dataObjectsToVisit = new LinkedList(dataObjects);
        while (!dataObjectsToVisit.isEmpty()) {
            DataObject currentDataObject = (DataObject)dataObjectsToVisit.remove(0);
            results.add(currentDataObject);
            if (currentDataObject instanceof CompositeDataObject) {
                for (InnerDataObjectDeclaration innerDataObjectDeclaration : ((CompositeDataObject)currentDataObject).getInnerDataObjectDeclarations()) {
                    if (dataObjectsToVisit.contains(innerDataObjectDeclaration.getDataObject()) || results.contains(innerDataObjectDeclaration.getDataObject())) continue;
                    dataObjectsToVisit.add(innerDataObjectDeclaration.getDataObject());
                }
                continue;
            }
            if (!(currentDataObject instanceof CollectionDataObject)) continue;
            for (DataObject innerDataObject : ((CollectionDataObject)currentDataObject).getInnerDataObjects()) {
                if (dataObjectsToVisit.contains(innerDataObject) || results.contains(innerDataObject)) continue;
                dataObjectsToVisit.add(innerDataObject);
            }
        }
        return results;
    }

    public static Map<DataObject<?>, Set<DataObject<?>>> lookUpCompositeAndCollectionDataObjectsWithDataObjects(BPArchitectureVersion version, Collection<DataObject<?>> dataObjects) {
        HashMap results = new HashMap();
        List<DataObject<?>> allDataObjects = BPArchitectureModelLookup.lookUpAllDataObjects(version);
        LinkedList dataObjectsToVisit = new LinkedList(dataObjects);
        while (!dataObjectsToVisit.isEmpty()) {
            DataObject simpleDataObject = (DataObject)dataObjectsToVisit.remove(0);
            for (DataObject<?> resultCandidate : allDataObjects) {
                CompositeDataObject complexDataObject;
                if (resultCandidate instanceof CompositeDataObject) {
                    complexDataObject = (CompositeDataObject)resultCandidate;
                    for (InnerDataObjectDeclaration innerDeclaration : complexDataObject.getInnerDataObjectDeclarations()) {
                        if (!innerDeclaration.getDataObject().equals(simpleDataObject)) continue;
                        if (!dataObjectsToVisit.contains(complexDataObject) && !results.containsKey(complexDataObject)) {
                            dataObjectsToVisit.add((DataObject<?>)complexDataObject);
                        }
                        MapUtil.putOrAddToMap(results, resultCandidate, (Object)simpleDataObject);
                    }
                    continue;
                }
                if (!(resultCandidate instanceof CollectionDataObject)) continue;
                complexDataObject = (CollectionDataObject)resultCandidate;
                for (DataObject innerDataObject : complexDataObject.getInnerDataObjects()) {
                    if (!innerDataObject.equals(simpleDataObject)) continue;
                    if (!dataObjectsToVisit.contains(complexDataObject) && !results.containsKey(complexDataObject)) {
                        dataObjectsToVisit.add((DataObject<?>)complexDataObject);
                    }
                    MapUtil.putOrAddToMap(results, resultCandidate, (Object)simpleDataObject);
                }
            }
        }
        return results;
    }

    public static Map<DataObject<?>, Set<DataType>> lookUpDataObjectsWithDataTypes(BPArchitectureVersion version, Collection<DataType> datatypes) {
        HashMap results = new HashMap();
        for (DataObject dataObject : version.getDataModel().getDataObjects()) {
            for (DataType dataType : datatypes) {
                if (!dataObject.getDataTypes().contains((Object)dataType)) continue;
                MapUtil.putOrAddToMap(results, (Object)dataObject, (Object)dataType);
            }
        }
        return results;
    }

    public static Map<DataType, Set<DataObject<?>>> lookUpDataTypesWithDataObjects(BPArchitectureVersion version, Collection<DataObject<?>> dataObjects) {
        HashMap results = new HashMap();
        for (DataType dataType : version.getRepository().getDataTypes__Repository()) {
            for (DataObject<?> dataObject : dataObjects) {
                if (!dataObject.getDataTypes().contains((Object)dataType)) continue;
                MapUtil.putOrAddToMap(results, (Object)dataType, dataObject);
            }
        }
        return results;
    }

    public static Map<DataType, Set<DataType>> lookUpCompositeAndCollectionDataTypesOfDataTypes(BPArchitectureVersion version, Collection<DataType> dataTypes) {
        HashMap<DataType, Set<DataType>> results = new HashMap<DataType, Set<DataType>>();
        List<DataType> allDataTypes = BPArchitectureModelLookup.lookUpAllDataTypes(version);
        LinkedList<DataType> dataTypesToVisit = new LinkedList<DataType>(dataTypes);
        while (!dataTypesToVisit.isEmpty()) {
            DataType simpleDataType = (DataType)dataTypesToVisit.remove(0);
            for (DataType resultCandidate : allDataTypes) {
                CompositeDataType complexDataType;
                if (resultCandidate instanceof CompositeDataType) {
                    complexDataType = (CompositeDataType)resultCandidate;
                    for (InnerDeclaration innerDeclaration : complexDataType.getInnerDeclaration_CompositeDataType()) {
                        if (!innerDeclaration.getDatatype_InnerDeclaration().equals(simpleDataType)) continue;
                        if (!dataTypesToVisit.contains(complexDataType) && !results.containsKey(complexDataType)) {
                            dataTypesToVisit.add((DataType)complexDataType);
                        }
                        MapUtil.putOrAddToMap(results, (Object)complexDataType, (Object)simpleDataType);
                    }
                    continue;
                }
                if (!(resultCandidate instanceof CollectionDataType) || !(complexDataType = (CollectionDataType)resultCandidate).getInnerType_CollectionDataType().equals(simpleDataType)) continue;
                if (!dataTypesToVisit.contains(complexDataType) && !results.containsKey(complexDataType)) {
                    dataTypesToVisit.add((DataType)complexDataType);
                }
                MapUtil.putOrAddToMap(results, (Object)complexDataType, (Object)simpleDataType);
            }
        }
        return results;
    }

    public static List<ReleaseDeviceResourceAction> lookUpReleaseDeviceResourceActionsWithDeviceResources(BPArchitectureVersion version, Collection<DeviceResource> deviceResources) {
        LinkedList<ReleaseDeviceResourceAction> results = new LinkedList<ReleaseDeviceResourceAction>();
        for (AbstractUserAction action : BPArchitectureModelLookup.lookUpAllUserActions(version)) {
            if (!(action instanceof ReleaseDeviceResourceAction) || !deviceResources.contains(((ReleaseDeviceResourceAction)action).getPassiveresource_ReleaseAction())) continue;
            results.add((ReleaseDeviceResourceAction)action);
        }
        return results;
    }

    public static List<DataType> lookUpAllDataTypes(BPArchitectureVersion version) {
        LinkedList<DataType> result = new LinkedList<DataType>();
        result.addAll((Collection<DataType>)version.getRepository().getDataTypes__Repository());
        return result;
    }

    public static void lookUpInterfacesAndSignaturesWithEntryLevelSystemCalls(BPArchitectureVersion version, Collection<EntryLevelSystemCall> entryLevelSystemCalls, Map<Interface, Set<Signature>> affectedInterfaces, Map<Signature, EntryLevelSystemCall> affectedSignatures) {
        for (Interface interfac : version.getRepository().getInterfaces__Repository()) {
            if (!(interfac instanceof OperationInterface)) continue;
            OperationInterface operationInterface = (OperationInterface)interfac;
            HashMap<OperationSignature, EntryLevelSystemCall> matchingSignatures = new HashMap<OperationSignature, EntryLevelSystemCall>();
            for (EntryLevelSystemCall elsc : entryLevelSystemCalls) {
                matchingSignatures.put(elsc.getOperationSignature__EntryLevelSystemCall(), elsc);
            }
            MapUtil.retainAll(matchingSignatures, (Collection)operationInterface.getSignatures__OperationInterface());
            MapUtil.putOrAddToMap(affectedInterfaces, (Object)operationInterface, matchingSignatures.keySet());
            affectedSignatures.putAll(matchingSignatures);
        }
    }

    public static List<AbstractUserAction> lookUpAllUserActions(BPArchitectureVersion version) {
        LinkedList<AbstractUserAction> results = new LinkedList<AbstractUserAction>();
        for (Map.Entry<String, UsageModel> usageModelEntry : version.getUsageModels().entrySet()) {
            for (UsageScenario usageScenario : usageModelEntry.getValue().getUsageScenario_UsageModel()) {
                results.addAll(BPArchitectureModelLookup.lookUpAllUserActions(usageScenario.getScenarioBehaviour_UsageScenario()));
            }
        }
        return results;
    }

    public static List<AbstractUserAction> lookUpAllUserActions(ScenarioBehaviour scenarioBehaviour) {
        LinkedList<AbstractUserAction> results = new LinkedList<AbstractUserAction>();
        for (AbstractUserAction abstractUserAction : scenarioBehaviour.getActions_ScenarioBehaviour()) {
            results.addAll(BPArchitectureModelLookup.lookUpAllUserActions(abstractUserAction));
        }
        return results;
    }

    public static List<AbstractUserAction> lookUpAllUserActions(AbstractUserAction action) {
        LinkedList<AbstractUserAction> results = new LinkedList<AbstractUserAction>();
        results.add(action);
        if (action instanceof Activity) {
            results.addAll(BPArchitectureModelLookup.lookUpAllUserActions(((Activity)action).getScenario()));
        } else if (action instanceof Branch) {
            for (BranchTransition branchTransition : ((Branch)action).getBranchTransitions_Branch()) {
                results.addAll(BPArchitectureModelLookup.lookUpAllUserActions(branchTransition.getBranchedBehaviour_BranchTransition()));
            }
        } else if (action instanceof Loop) {
            results.addAll(BPArchitectureModelLookup.lookUpAllUserActions(((Loop)action).getBodyBehaviour_Loop()));
        }
        return results;
    }

    public static List<AbstractUserAction> lookUpUserActionsUpToReleaseDeviceResource(AcquireDeviceResourceAction acquireDeviceResourceAction, Collection<AcquireDeviceResourceAction> acquireActionsProcessed, Collection<ReleaseDeviceResourceAction> releaseActionsProcessed) {
        LinkedList<AbstractUserAction> results = new LinkedList<AbstractUserAction>();
        AbstractUserAction currentAction = acquireDeviceResourceAction.getSuccessor();
        int numOpenAcquiresForThatResource = 1;
        acquireActionsProcessed.add(acquireDeviceResourceAction);
        while (currentAction != null) {
            results.add(currentAction);
            if (currentAction instanceof AcquireDeviceResourceAction && ((AcquireDeviceResourceAction)currentAction).getPassiveresource_AcquireAction().equals(acquireDeviceResourceAction.getPassiveresource_AcquireAction())) {
                ++numOpenAcquiresForThatResource;
                acquireActionsProcessed.add((AcquireDeviceResourceAction)currentAction);
            }
            if (currentAction instanceof ReleaseDeviceResourceAction && ((ReleaseDeviceResourceAction)currentAction).getPassiveresource_ReleaseAction().equals(acquireDeviceResourceAction.getPassiveresource_AcquireAction())) {
                --numOpenAcquiresForThatResource;
                releaseActionsProcessed.add((ReleaseDeviceResourceAction)currentAction);
            }
            if (numOpenAcquiresForThatResource == 0) {
                return results;
            }
            currentAction = currentAction.getSuccessor();
        }
        acquireActionsProcessed.clear();
        acquireActionsProcessed.add(acquireDeviceResourceAction);
        releaseActionsProcessed.clear();
        return null;
    }
}

