/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ipd.sdq.dsexplore.qml.pcm.reader;

import de.uka.ipd.sdq.dsexplore.qml.contract.Constraint;
import de.uka.ipd.sdq.dsexplore.qml.contract.EnumOperator;
import de.uka.ipd.sdq.dsexplore.qml.contract.EvaluationAspect;
import de.uka.ipd.sdq.dsexplore.qml.contract.GenericQMLContract;
import de.uka.ipd.sdq.dsexplore.qml.contract.Goal;
import de.uka.ipd.sdq.dsexplore.qml.contract.NumericLiteral;
import de.uka.ipd.sdq.dsexplore.qml.contract.Objective;
import de.uka.ipd.sdq.dsexplore.qml.contract.Restriction;
import de.uka.ipd.sdq.dsexplore.qml.contract.SimpleQMLContract;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType;
import de.uka.ipd.sdq.dsexplore.qml.declarations.QMLDeclarations;
import de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.EnumRelationSemantics;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.EvaluationAspectWithContext;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.InfeasibilityConstraintBuilder;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.ObjectiveBuilder;
import de.uka.ipd.sdq.dsexplore.qml.pcm.datastructures.builder.SatisfactionConstraintBuilder;
import de.uka.ipd.sdq.dsexplore.qml.profile.Requirement;
import de.uka.ipd.sdq.dsexplore.qml.profile.SimpleQMLProfile;
import de.uka.ipd.sdq.dsexplore.qml.reader.QMLDeclarationsReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opt4j.core.Constraint;
import org.opt4j.core.Criterion;
import org.opt4j.core.InfeasibilityConstraint;
import org.opt4j.core.Objective;
import org.opt4j.core.SatisfactionConstraint;
import org.palladiosimulator.pcm.usagemodel.UsageModel;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;

public class PCMDeclarationsReader {
    protected final String[] PCMProfilePaths;
    protected static HashMap<String, EvaluationAspectWithContext> retranslationMap = new HashMap();
    protected QMLDeclarationsReader qmlReader = new QMLDeclarationsReader();
    protected List<SimpleQMLProfile> pcmProfiles = new ArrayList<SimpleQMLProfile>();
    protected List<EvaluationAspectWithContext> pcmConstraints = new ArrayList<EvaluationAspectWithContext>();
    protected List<EvaluationAspectWithContext> pcmObjectives = new ArrayList<EvaluationAspectWithContext>();

    public PCMDeclarationsReader(String PCMProfilePath) {
        this.PCMProfilePaths = new String[]{PCMProfilePath};
        this.init();
    }

    public QMLContractType getContractTypeForUsageModel(UsageModel usageModel) {
        for (SimpleQMLProfile sqc : this.pcmProfiles) {
            if (!this.equalUsageModels(usageModel, sqc.getUsageModel())) continue;
            for (Requirement requirement : sqc.getRequirements()) {
                for (GenericQMLContract contract : requirement.getRequireContract()) {
                    if (!(contract instanceof SimpleQMLContract)) continue;
                    SimpleQMLContract simpleContract = (SimpleQMLContract)contract;
                    return simpleContract.getContractType();
                }
            }
        }
        return null;
    }

    protected void init() {
        this.initPCMProfiles();
        this.initPCMConstraintsAndObjectives();
    }

    private void initPCMProfiles() {
        int i = 0;
        while (i < this.PCMProfilePaths.length) {
            String PCMProfilePath = this.PCMProfilePaths[i];
            QMLDeclarations declarations = this.qmlReader.getQMLDeclarations(PCMProfilePath);
            this.pcmProfiles.addAll(this.qmlReader.getSimpleQMLProfiles(declarations));
            if (declarations != null && this.qmlReader.getRefinedQMLProfiles(declarations).size() > 0) {
                throw new RuntimeException("Refined QML profiles not supported!");
            }
            ++i;
        }
    }

    private void initPCMConstraintsAndObjectives() {
        for (SimpleQMLProfile simpleProfile : this.pcmProfiles) {
            for (Requirement requirement : simpleProfile.getRequirements()) {
                for (GenericQMLContract contract : requirement.getRequireContract()) {
                    if (contract instanceof SimpleQMLContract) {
                        SimpleQMLContract simpleContract = (SimpleQMLContract)contract;
                        for (de.uka.ipd.sdq.dsexplore.qml.contract.Criterion criterion : simpleContract.getCriteria()) {
                            for (EvaluationAspect aspect : criterion.getAspects()) {
                                if (criterion instanceof Objective) {
                                    this.pcmObjectives.add(new EvaluationAspectWithContext(simpleContract.getContractType(), criterion.getDimension(), criterion, aspect, simpleProfile.getUsageModel(), requirement));
                                    continue;
                                }
                                this.pcmConstraints.add(new EvaluationAspectWithContext(simpleContract.getContractType(), criterion.getDimension(), criterion, aspect, simpleProfile.getUsageModel(), requirement));
                            }
                        }
                        continue;
                    }
                    throw new RuntimeException("Unsupported QML Contract! Simple QML Contract expected");
                }
            }
        }
    }

    public List<EvaluationAspectWithContext> getDimensionObjectiveContextsForUsageModel(UsageModel usageModel, String dimensionId) {
        return new ArrayList<EvaluationAspectWithContext>(this.getDimensionCriterionContextsForUsageModel(usageModel, dimensionId, Objective.class));
    }

    public List<EvaluationAspectWithContext> getDimensionConstraintContextsForUsageModel(UsageModel usageModel, String dimensionId) {
        return new ArrayList<EvaluationAspectWithContext>(this.getDimensionCriterionContextsForUsageModel(usageModel, dimensionId, Constraint.class));
    }

    protected List<EvaluationAspectWithContext> getDimensionCriterionContextsForUsageModel(UsageModel usageModel, String dimensionId, Class<? extends de.uka.ipd.sdq.dsexplore.qml.contract.Criterion> CriterionClass) {
        ArrayList<EvaluationAspectWithContext> returnList = new ArrayList<EvaluationAspectWithContext>();
        List<EvaluationAspectWithContext> tmpList = this.getDimensionCriterionContexts(dimensionId, CriterionClass);
        for (EvaluationAspectWithContext aspect : tmpList) {
            if (!this.equalUsageModels(usageModel, aspect.getUsageModel())) continue;
            returnList.add(aspect);
        }
        return returnList;
    }

    protected boolean equalUsageModels(UsageModel um1, UsageModel um2) {
        if (um1 == um2) {
            return true;
        }
        if (um1.getUsageScenario_UsageModel().size() != 0 && um2.getUsageScenario_UsageModel().size() != 0) {
            String us1_id = ((UsageScenario)um1.getUsageScenario_UsageModel().get(0)).getId();
            for (UsageScenario us2 : um2.getUsageScenario_UsageModel()) {
                if (!us2.getId().equals(us1_id)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    protected List<EvaluationAspectWithContext> getDimensionCriterionContexts(String dimensionId, Class<? extends de.uka.ipd.sdq.dsexplore.qml.contract.Criterion> criterionClass) {
        ArrayList<EvaluationAspectWithContext> list = new ArrayList<EvaluationAspectWithContext>();
        List<EvaluationAspectWithContext> criterionList = criterionClass == Objective.class ? this.pcmObjectives : this.pcmConstraints;
        for (EvaluationAspectWithContext aspect : criterionList) {
            if (!aspect.getDimension().getId().equals(dimensionId)) continue;
            list.add(aspect);
        }
        return list;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InfeasibilityConstraint translateEvalAspectToInfeasibilityConstraint(EvaluationAspectWithContext aspectContext, InfeasibilityConstraintBuilder builder) {
        EvaluationAspect aspect = aspectContext.getEvaluationAspect();
        if (!(aspect.getAspectRequirement() instanceof Restriction)) throw new RuntimeException("Aspect must have aspect requirement of type Restriction to derive InfeasibilityConstraint.");
        if (((Restriction)aspect.getAspectRequirement()).getOperator() != EnumOperator.LESS) throw new RuntimeException("Unsupported constraint operator in aspect. Only LESS (<) supported so far.");
        if (!(((Restriction)aspect.getAspectRequirement()).getAspectRequirementLiteral() instanceof NumericLiteral)) {
            throw new RuntimeException("Unsupported Constraint literal in aspect. Only numeric literals are supported so far.");
        }
        InfeasibilityConstraint constraint = builder.createInfeasibilityConstraint(aspect.getId(), Constraint.Direction.less, ((NumericLiteral)((Restriction)aspect.getAspectRequirement()).getAspectRequirementLiteral()).getValue());
        retranslationMap.put(constraint.getName(), aspectContext);
        return constraint;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SatisfactionConstraint translateEvalAspectToSatisfactionConstraint(EvaluationAspectWithContext aspectContext, org.opt4j.core.Objective objective, SatisfactionConstraintBuilder builder) {
        EvaluationAspect aspect = aspectContext.getEvaluationAspect();
        SatisfactionConstraint constraint = null;
        if ((Goal)aspect.getAspectRequirement() == null) {
            constraint = objective.getSign() == Objective.Sign.MIN ? builder.createSatisfactionConstraint(aspect.getId(), Constraint.Direction.less, Double.NEGATIVE_INFINITY, objective) : builder.createSatisfactionConstraint(aspect.getId(), Constraint.Direction.greater, Double.POSITIVE_INFINITY, objective);
        } else {
            if (!(aspect.getAspectRequirement() instanceof Goal)) throw new RuntimeException("Aspect must have aspect requirement of type Goal to derive SatisfactionConstraint!");
            if (!(((Goal)aspect.getAspectRequirement()).getAspectRequirementLiteral() instanceof NumericLiteral)) throw new RuntimeException("Unsupported Goal literal in aspect. Only numeric literals supported in Goal aspect requirements so far.");
            constraint = objective.getSign() == Objective.Sign.MIN ? builder.createSatisfactionConstraint(aspect.getId(), Constraint.Direction.less, ((NumericLiteral)((Goal)aspect.getAspectRequirement()).getAspectRequirementLiteral()).getValue(), objective) : builder.createSatisfactionConstraint(aspect.getId(), Constraint.Direction.greater, ((NumericLiteral)((Goal)aspect.getAspectRequirement()).getAspectRequirementLiteral()).getValue(), objective);
        }
        retranslationMap.put(constraint.getName(), aspectContext);
        return constraint;
    }

    public org.opt4j.core.Objective translateEvalAspectToObjective(String qualityAttribute, EvaluationAspectWithContext aspectContext, ObjectiveBuilder builder) {
        org.opt4j.core.Objective objective = aspectContext.getDimension().getType().getRelationSemantics().getRelSem() == EnumRelationSemantics.DECREASING ? builder.createObjective(qualityAttribute, Objective.Sign.MIN) : builder.createObjective(qualityAttribute, Objective.Sign.MAX);
        retranslationMap.put(objective.getName(), aspectContext);
        return objective;
    }

    public static EvaluationAspectWithContext retranslateCriterionToEvaluationAspect(Criterion criterion) {
        return retranslationMap.get(criterion.getName());
    }
}

