/**
 */
package de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.provider;

import de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.util.DimensiontypesAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class DimensiontypesItemProviderAdapterFactory extends DimensiontypesAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DimensiontypesItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.DimensionTypeSet} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DimensionTypeSetItemProvider dimensionTypeSetItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.DimensionTypeSet}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDimensionTypeSetAdapter() {
		if (dimensionTypeSetItemProvider == null) {
			dimensionTypeSetItemProvider = new DimensionTypeSetItemProvider(this);
		}

		return dimensionTypeSetItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.RelationSemantics} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationSemanticsItemProvider relationSemanticsItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.RelationSemantics}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelationSemanticsAdapter() {
		if (relationSemanticsItemProvider == null) {
			relationSemanticsItemProvider = new RelationSemanticsItemProvider(this);
		}

		return relationSemanticsItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.Element} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ElementItemProvider elementItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.Element}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createElementAdapter() {
		if (elementItemProvider == null) {
			elementItemProvider = new ElementItemProvider(this);
		}

		return elementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.Order} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OrderItemProvider orderItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.Order}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOrderAdapter() {
		if (orderItemProvider == null) {
			orderItemProvider = new OrderItemProvider(this);
		}

		return orderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.DimensionTypeEnum} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DimensionTypeEnumItemProvider dimensionTypeEnumItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.DimensionTypeEnum}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDimensionTypeEnumAdapter() {
		if (dimensionTypeEnumItemProvider == null) {
			dimensionTypeEnumItemProvider = new DimensionTypeEnumItemProvider(this);
		}

		return dimensionTypeEnumItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.DimensionTypeNumeric} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DimensionTypeNumericItemProvider dimensionTypeNumericItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.DimensionTypeNumeric}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDimensionTypeNumericAdapter() {
		if (dimensionTypeNumericItemProvider == null) {
			dimensionTypeNumericItemProvider = new DimensionTypeNumericItemProvider(this);
		}

		return dimensionTypeNumericItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.NumericRange} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NumericRangeItemProvider numericRangeItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.NumericRange}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNumericRangeAdapter() {
		if (numericRangeItemProvider == null) {
			numericRangeItemProvider = new NumericRangeItemProvider(this);
		}

		return numericRangeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.DimensionTypeRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DimensionTypeRepositoryItemProvider dimensionTypeRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.DimensionTypeRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDimensionTypeRepositoryAdapter() {
		if (dimensionTypeRepositoryItemProvider == null) {
			dimensionTypeRepositoryItemProvider = new DimensionTypeRepositoryItemProvider(this);
		}

		return dimensionTypeRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.DimensionTypeScale} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DimensionTypeScaleItemProvider dimensionTypeScaleItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.DimensionTypeScale}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDimensionTypeScaleAdapter() {
		if (dimensionTypeScaleItemProvider == null) {
			dimensionTypeScaleItemProvider = new DimensionTypeScaleItemProvider(this);
		}

		return dimensionTypeScaleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.ScaleElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ScaleElementItemProvider scaleElementItemProvider;

	/**
	 * This creates an adapter for a {@link de.uka.ipd.sdq.dsexplore.qml.dimensiontypes.ScaleElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createScaleElementAdapter() {
		if (scaleElementItemProvider == null) {
			scaleElementItemProvider = new ScaleElementItemProvider(this);
		}

		return scaleElementItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (dimensionTypeSetItemProvider != null) dimensionTypeSetItemProvider.dispose();
		if (relationSemanticsItemProvider != null) relationSemanticsItemProvider.dispose();
		if (elementItemProvider != null) elementItemProvider.dispose();
		if (orderItemProvider != null) orderItemProvider.dispose();
		if (dimensionTypeEnumItemProvider != null) dimensionTypeEnumItemProvider.dispose();
		if (dimensionTypeNumericItemProvider != null) dimensionTypeNumericItemProvider.dispose();
		if (numericRangeItemProvider != null) numericRangeItemProvider.dispose();
		if (dimensionTypeRepositoryItemProvider != null) dimensionTypeRepositoryItemProvider.dispose();
		if (dimensionTypeScaleItemProvider != null) dimensionTypeScaleItemProvider.dispose();
		if (scaleElementItemProvider != null) scaleElementItemProvider.dispose();
	}

}
