/*
 * Decompiled with CFR 0.152.
 */
package de.uhd.ifi.se.pcm.bppcm.datamodel.util;

import de.uhd.ifi.se.pcm.bppcm.datamodel.CollectionDataObject;
import de.uhd.ifi.se.pcm.bppcm.datamodel.CompositeDataObject;
import de.uhd.ifi.se.pcm.bppcm.datamodel.DataModel;
import de.uhd.ifi.se.pcm.bppcm.datamodel.DataObject;
import de.uhd.ifi.se.pcm.bppcm.datamodel.DatamodelPackage;
import de.uhd.ifi.se.pcm.bppcm.datamodel.InnerDataObjectDeclaration;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;

public class DatamodelValidator
extends EObjectValidator {
    public static final DatamodelValidator INSTANCE = new DatamodelValidator();
    public static final String DIAGNOSTIC_SOURCE = "de.uhd.ifi.se.pcm.bppcm.datamodel";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected static final String COLLECTION_DATA_OBJECT__INNER_TYPE_SHOULD_MATCH_INNER_OBJECTS__EEXPRESSION = "self.innerDataObjects->forAll(innerDataObject|innerDataObject.dataType=self.dataType.oclAsType(repository::CollectionDataType).innerType_CollectionDataType)";
    protected static final String COMPOSITE_DATA_OBJECT__INNER_DECLARATIONS_SHOULD_MATCH_TYPES_INNER_DECLARATIONS__EEXPRESSION = "self.innerDataObjectDeclarations->forAll(innerDataObjectDeclaration|self.dataType.oclAsType(repository::CompositeDataType).innerDeclaration_CompositeDataType->one(innerDataTypeDeclaration|innerDataTypeDeclaration.entityName=innerDataObjectDeclaration.entityName and innerDataTypeDeclaration.datatype_InnerDeclaration=innerDataObjectDeclaration.dataObject.dataType))";

    protected EPackage getEPackage() {
        return DatamodelPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateDataObject((DataObject)value, diagnostics, context);
            }
            case 1: {
                return this.validateCollectionDataObject((CollectionDataObject)value, diagnostics, context);
            }
            case 2: {
                return this.validateCompositeDataObject((CompositeDataObject)value, diagnostics, context);
            }
            case 3: {
                return this.validateDataModel((DataModel)value, diagnostics, context);
            }
            case 4: {
                return this.validateInnerDataObjectDeclaration((InnerDataObjectDeclaration)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateDataObject(DataObject<?> dataObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dataObject, diagnostics, context);
    }

    public boolean validateCollectionDataObject(CollectionDataObject collectionDataObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(collectionDataObject, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(collectionDataObject, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(collectionDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(collectionDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(collectionDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(collectionDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(collectionDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(collectionDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(collectionDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCollectionDataObject_InnerTypeShouldMatchInnerObjects(collectionDataObject, diagnostics, context);
        }
        return result;
    }

    public boolean validateCollectionDataObject_InnerTypeShouldMatchInnerObjects(CollectionDataObject collectionDataObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(DatamodelPackage.Literals.COLLECTION_DATA_OBJECT, collectionDataObject, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "InnerTypeShouldMatchInnerObjects", COLLECTION_DATA_OBJECT__INNER_TYPE_SHOULD_MATCH_INNER_OBJECTS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateCompositeDataObject(CompositeDataObject compositeDataObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(compositeDataObject, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(compositeDataObject, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(compositeDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(compositeDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryBidirectionalReferenceIsPaired(compositeDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(compositeDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(compositeDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(compositeDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(compositeDataObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateCompositeDataObject_InnerDeclarationsShouldMatchTypesInnerDeclarations(compositeDataObject, diagnostics, context);
        }
        return result;
    }

    public boolean validateCompositeDataObject_InnerDeclarationsShouldMatchTypesInnerDeclarations(CompositeDataObject compositeDataObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(DatamodelPackage.Literals.COMPOSITE_DATA_OBJECT, compositeDataObject, diagnostics, context, "http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot", "InnerDeclarationsShouldMatchTypesInnerDeclarations", COMPOSITE_DATA_OBJECT__INNER_DECLARATIONS_SHOULD_MATCH_TYPES_INNER_DECLARATIONS__EEXPRESSION, 4, DIAGNOSTIC_SOURCE, 0);
    }

    public boolean validateDataModel(DataModel dataModel, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(dataModel, diagnostics, context);
    }

    public boolean validateInnerDataObjectDeclaration(InnerDataObjectDeclaration innerDataObjectDeclaration, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(innerDataObjectDeclaration, diagnostics, context);
    }

    public ResourceLocator getResourceLocator() {
        return super.getResourceLocator();
    }
}

