/*
 * Decompiled with CFR 0.152.
 */
package de.uhd.ifi.se.pcm.bppcm.ui;

import de.uhd.ifi.se.pcm.bppcm.spec.ProcessTriggerPeriodSpecification;
import de.uhd.ifi.se.pcm.bppcm.ui.Activator;
import de.uhd.ifi.se.pcm.bppcm.ui.DayProfilesPage;
import de.uhd.ifi.se.pcm.bppcm.ui.DayProfilesWizard;
import de.uhd.ifi.se.pcm.bppcm.ui.EditPeriodPage;
import de.uhd.ifi.se.pcm.bppcm.ui.ProcessCalendar;
import java.text.SimpleDateFormat;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class EditDayProfile
extends WizardPage {
    private Text text1;
    private Text text2;
    private Text text3;
    private Text text4;
    protected List periodsList;
    private Composite container;
    protected ProcessCalendar calendar;
    private IWizardPage pageOne;
    protected DayProfilesWizard wizard;

    public EditDayProfile(ProcessCalendar processCalendar, IWizardPage one, DayProfilesWizard w) {
        super("Edit a DayProfile");
        this.setTitle("Edit a DayProfile, press the 'Add'-Button to add a new Period");
        this.pageOne = one;
        this.setDescription(" ");
        this.setControl((Control)this.text1);
        this.calendar = processCalendar;
        this.wizard = w;
    }

    public void createControl(Composite parent) {
        this.container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.container.setLayout((Layout)layout);
        Composite nameContainer = new Composite(this.container, 0);
        GridLayout layoutNameContainer = new GridLayout();
        nameContainer.setLayout((Layout)layoutNameContainer);
        layoutNameContainer.numColumns = 2;
        nameContainer.setLayoutData((Object)new GridData(768));
        Label label1 = new Label(nameContainer, 0);
        label1.setText("Day Profile Name: ");
        this.text1 = new Text(nameContainer, 2052);
        this.text1.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (!EditDayProfile.this.text1.getText().isEmpty()) {
                    int index = ((DayProfilesPage)EditDayProfile.this.pageOne).getList().getSelectionIndex();
                    String name = EditDayProfile.this.text1.getText();
                    EditDayProfile.this.calendar.dayprofiles.get(index).setName(name);
                    EditDayProfile.this.setPageComplete(true);
                }
            }
        });
        GridData gd = new GridData(768);
        this.text1.setLayoutData((Object)gd);
        Group group = new Group(this.container, 4);
        GridLayout layoutGroup = new GridLayout();
        layoutGroup.numColumns = 2;
        group.setLayout((Layout)layoutGroup);
        group.setText("A new Period");
        group.setLayoutData((Object)new GridData(768));
        Label label2 = new Label((Composite)group, 0);
        label2.setText("Start Time Point: ");
        this.text2 = new Text((Composite)group, 2052);
        this.text2.setText("00:00:00");
        Label label3 = new Label((Composite)group, 0);
        label3.setText("End Time Point: ");
        this.text3 = new Text((Composite)group, 2052);
        this.text3.setText("00:00:00");
        Label label4 = new Label((Composite)group, 0);
        label4.setText("Inter Arrival Time: ");
        this.text4 = new Text((Composite)group, 2052);
        this.text4.setText("default");
        this.text4.setLayoutData((Object)gd);
        Composite container2 = new Composite(this.container, 0);
        GridLayout layoutContainer2 = new GridLayout();
        container2.setLayout((Layout)layoutContainer2);
        layoutContainer2.numColumns = 2;
        container2.setLayoutData((Object)new GridData(768));
        Label help = new Label(container2, 0);
        help.setText("");
        Composite buttons = new Composite(container2, 0);
        GridLayout layoutButtons = new GridLayout();
        buttons.setLayout((Layout)layoutButtons);
        layoutButtons.numColumns = 2;
        Button add = new Button(buttons, 8);
        add.setText("Add");
        add.setImage(Activator.getImageDescriptor("/icons/add.png").createImage());
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditDayProfile.this.setDescription(" ");
                String start = EditDayProfile.this.text2.getText();
                String end = EditDayProfile.this.text3.getText();
                if (start.matches("^(?:(?:([01]?\\d|2[0-3]):)?([0-5]?\\d):)?([0-5]?\\d)$") && end.matches("^(?:(?:([01]?\\d|2[0-3]):)?([0-5]?\\d):)?([0-5]?\\d)$")) {
                    String[] partsStart = start.split(":");
                    String hoursPartsStart = partsStart[0];
                    String minutesPartsStart = partsStart[1];
                    String secondsPartsStart = partsStart[2];
                    int hoursStart = Integer.parseInt(hoursPartsStart);
                    int minutesStart = Integer.parseInt(minutesPartsStart);
                    int secondsStart = Integer.parseInt(secondsPartsStart);
                    String[] partsEnd = end.split(":");
                    String hoursPartsEnd = partsEnd[0];
                    String minutesPartsEnd = partsEnd[1];
                    String secondsPartsEnd = partsEnd[2];
                    int hoursEnd = Integer.parseInt(hoursPartsEnd);
                    int minutesEnd = Integer.parseInt(minutesPartsEnd);
                    int secondsEnd = Integer.parseInt(secondsPartsEnd);
                    int startInt = secondsStart + 60 * minutesStart + 3600 * hoursStart;
                    int endInt = secondsEnd + 60 * minutesEnd + 3600 * hoursEnd;
                    int i = ((DayProfilesPage)EditDayProfile.this.pageOne).getList().getSelectionIndex();
                    boolean notOverlap = true;
                    int j = 0;
                    while (j < EditDayProfile.this.calendar.dayprofiles.get(i).getPeriods().size()) {
                        String st = EditDayProfile.this.calendar.dayprofiles.get(i).getPeriods().get(j).getStartTimePoint().toPattern();
                        String en = EditDayProfile.this.calendar.dayprofiles.get(i).getPeriods().get(j).getEndTimePointtime().toPattern();
                        String[] partsSt = st.split(":");
                        String hoursPartsSt = partsSt[0];
                        String minutesPartsSt = partsSt[1];
                        String secondsPartsSt = partsSt[2];
                        int hoursSt = Integer.parseInt(hoursPartsSt);
                        int minutesSt = Integer.parseInt(minutesPartsSt);
                        int secondsSt = Integer.parseInt(secondsPartsSt);
                        String[] partsEn = en.split(":");
                        String hoursPartsEn = partsEn[0];
                        String minutesPartsEn = partsEn[1];
                        String secondsPartsEn = partsEn[2];
                        int hoursEn = Integer.parseInt(hoursPartsEn);
                        int minutesEn = Integer.parseInt(minutesPartsEn);
                        int secondsEn = Integer.parseInt(secondsPartsEn);
                        int startIntValue = secondsSt + 60 * minutesSt + 3600 * hoursSt;
                        int endIntValue = secondsEn + 60 * minutesEn + 3600 * hoursEn;
                        if (startInt < endIntValue && endInt > startIntValue) {
                            notOverlap = false;
                            EditDayProfile.this.setDescription("this period overlaps with an already existing period");
                        }
                        ++j;
                    }
                    if (notOverlap) {
                        if (startInt < endInt) {
                            EditDayProfile.this.addInterval(start, end);
                            EditDayProfile.this.setDescription(" ");
                        } else {
                            EditDayProfile.this.setDescription("end time is earlier than start time");
                        }
                    }
                } else {
                    EditDayProfile.this.setDescription("invalid period definition");
                }
            }
        });
        Button delete = new Button(buttons, 8);
        delete.setText("Delete");
        delete.setImage(Activator.getImageDescriptor("/icons/delete.png").createImage());
        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditDayProfile.this.periodsList.getSelection() != null) {
                    int index = EditDayProfile.this.periodsList.getSelectionIndex();
                    int i = ((DayProfilesPage)EditDayProfile.this.pageOne).getList().getSelectionIndex();
                    EditDayProfile.this.calendar.dayprofiles.get(i).getPeriods().remove(index);
                    EditDayProfile.this.periodsList.remove(index);
                    EditDayProfile.this.setPageComplete(false);
                }
            }
        });
        Label label5 = new Label(container2, 0);
        label5.setText("Existing Periods: ");
        GridData gd1 = new GridData(1808);
        this.periodsList = new List(container2, 2562);
        this.periodsList.setLayoutData((Object)gd1);
        this.periodsList.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (EditDayProfile.this.periodsList.getSelectionCount() > 0) {
                    ((EditPeriodPage)EditDayProfile.this.wizard.three).fillTexts();
                    EditDayProfile.this.setPageComplete(true);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setControl((Control)this.container);
        this.setPageComplete(false);
    }

    public void addInterval(String start, String end) {
        int i = ((DayProfilesPage)this.pageOne).getList().getSelectionIndex();
        ProcessTriggerPeriodSpecification period = new ProcessTriggerPeriodSpecification();
        SimpleDateFormat startDate = new SimpleDateFormat(start);
        period.setStartTimePoint(startDate);
        SimpleDateFormat endDate = new SimpleDateFormat(end);
        period.setEndTimePointtime(endDate);
        String inter = this.text4.getText();
        period.setInterArrivalTime(inter);
        this.periodsList.add(String.valueOf(period.getStartTimePoint().toPattern()) + " - " + period.getEndTimePointtime().toPattern() + " : " + period.getInterArrivalTime());
        this.calendar.dayprofiles.get(i).getPeriods().add(period);
        this.text2.setText("00:00:00");
        this.text3.setText("00:00:00");
        this.text4.setText("default");
    }

    public void fillList() {
        this.periodsList.removeAll();
        int i = ((DayProfilesPage)this.pageOne).getList().getSelectionIndex();
        this.text1.setText(this.calendar.dayprofiles.get(i).getName());
        int j = 0;
        while (j < this.calendar.dayprofiles.get(i).getPeriods().size()) {
            this.periodsList.add(String.valueOf(this.calendar.dayprofiles.get(i).getPeriods().get(j).getStartTimePoint().toPattern()) + " - " + this.calendar.dayprofiles.get(i).getPeriods().get(j).getEndTimePointtime().toPattern() + " : " + this.calendar.dayprofiles.get(i).getPeriods().get(j).getInterArrivalTime());
            ++j;
        }
    }

    public String getText1() {
        return this.text1.getText();
    }
}

