/*
 * Decompiled with CFR 0.152.
 */
package de.uhd.ifi.se.pcm.bppcm.converter;

import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.BpusagemodelFactory;
import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.ProcessTriggerPeriod;
import de.uhd.ifi.se.pcm.bppcm.bpusagemodel.ProcessWorkload;
import de.uhd.ifi.se.pcm.bppcm.organizationenvironmentmodel.ActorResource;
import de.uhd.ifi.se.pcm.bppcm.organizationenvironmentmodel.OrganizationenvironmentmodelFactory;
import de.uhd.ifi.se.pcm.bppcm.organizationenvironmentmodel.WorkingPeriod;
import de.uhd.ifi.se.pcm.bppcm.ui.ActorCalendar;
import de.uhd.ifi.se.pcm.bppcm.ui.ProcessCalendar;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.palladiosimulator.pcm.core.CoreFactory;
import org.palladiosimulator.pcm.core.PCMRandomVariable;
import org.palladiosimulator.pcm.usagemodel.UsageScenario;
import org.palladiosimulator.pcm.usagemodel.Workload;

public class CalendarModelConverter {
    protected ProcessCalendar processCalendar;
    protected ActorCalendar actorCalendar;
    private PCMRandomVariable v;
    protected String timeUnit;
    protected String oldTimeUnit;

    public CalendarModelConverter(ProcessCalendar calendar) {
        this.processCalendar = calendar;
        this.timeUnit = calendar.getSelectedTimeUnit();
        this.oldTimeUnit = calendar.getOldTimeUnit();
    }

    public CalendarModelConverter(ProcessCalendar pCalendar, ActorCalendar aCalendar) {
        this.processCalendar = pCalendar;
        this.actorCalendar = aCalendar;
        this.timeUnit = pCalendar.getSelectedTimeUnit();
        this.oldTimeUnit = pCalendar.getOldTimeUnit();
    }

    public void updateUsageModel(ArrayList<UsageScenario> scenarioList, UsageScenario selectedScenario) {
        int y = 0;
        while (y < scenarioList.size()) {
            ProcessTriggerPeriod p;
            int i;
            Workload w = scenarioList.get(y).getWorkload_UsageScenario();
            assert (w instanceof ProcessWorkload) : "only ProcessWorkloads allowed";
            if (scenarioList.get(y).equals(selectedScenario) && selectedScenario.equals(this.processCalendar.selectedScenario)) {
                ((ProcessWorkload)w).getProcessTriggerPeriods().clear();
                i = 0;
                while (i < this.processCalendar.getDays().size()) {
                    int j = 0;
                    while (j < this.processCalendar.getDays().get(i).getProfile().getPeriods().size()) {
                        p = BpusagemodelFactory.eINSTANCE.createProcessTriggerPeriod();
                        SimpleDateFormat start = this.processCalendar.getDays().get(i).getProfile().getPeriods().get(j).getStartTimePoint();
                        p.setPeriodStartTimePoint(this.calculateTimeUnits(start, i));
                        SimpleDateFormat end = this.processCalendar.getDays().get(i).getProfile().getPeriods().get(j).getEndTimePointtime();
                        p.setPeriodEndTimePoint(this.calculateTimeUnits(end, i));
                        this.v = CoreFactory.eINSTANCE.createPCMRandomVariable();
                        this.v.setSpecification(this.processCalendar.getDays().get(i).getProfile().getPeriods().get(j).getInterArrivalTime());
                        p.setInterArrivalTime_ProcessWorkload(this.v);
                        ((ProcessWorkload)w).getProcessTriggerPeriods().add((Object)p);
                        ++j;
                    }
                    ++i;
                }
            } else if (!this.processCalendar.scenarioDayProfilesLists.get(y).equals(this.processCalendar.helpList)) {
                ((ProcessWorkload)w).getProcessTriggerPeriods().clear();
                i = 0;
                while (i < this.processCalendar.getDays().size()) {
                    int x = 0;
                    int z = 0;
                    while (z < this.processCalendar.scenarioDayProfilesLists.get(y).size()) {
                        if (this.processCalendar.getDays().get(i).getProfile().getName().equals(this.processCalendar.scenarioDayProfilesLists.get(y).get(z).getName())) {
                            x = z;
                        }
                        ++z;
                    }
                    int j = 0;
                    while (j < this.processCalendar.scenarioDayProfilesLists.get(y).get(x).getPeriods().size()) {
                        p = BpusagemodelFactory.eINSTANCE.createProcessTriggerPeriod();
                        SimpleDateFormat start = this.processCalendar.scenarioDayProfilesLists.get(y).get(x).getPeriods().get(j).getStartTimePoint();
                        p.setPeriodStartTimePoint(this.calculateTimeUnits(start, i));
                        SimpleDateFormat end = this.processCalendar.scenarioDayProfilesLists.get(y).get(x).getPeriods().get(j).getEndTimePointtime();
                        p.setPeriodEndTimePoint(this.calculateTimeUnits(end, i));
                        this.v = CoreFactory.eINSTANCE.createPCMRandomVariable();
                        this.v.setSpecification(this.processCalendar.scenarioDayProfilesLists.get(y).get(x).getPeriods().get(j).getInterArrivalTime());
                        p.setInterArrivalTime_ProcessWorkload(this.v);
                        ((ProcessWorkload)w).getProcessTriggerPeriods().add((Object)p);
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.updateListUSM(w);
            }
            ++y;
        }
    }

    private double calculateTimeUnits(SimpleDateFormat date, int i) {
        double time = 0.0;
        String stringDate = date.toPattern();
        String[] partsOne = stringDate.split(":");
        String hoursString = partsOne[0];
        String minutesString = partsOne[1];
        String secondsString = partsOne[2];
        int hours = Integer.parseInt(hoursString);
        int minutes = Integer.parseInt(minutesString);
        int seconds = Integer.parseInt(secondsString);
        if (this.timeUnit.equals("Milliseconds") || this.timeUnit.equals("Milliseconds\n")) {
            time += (double)(hours * 60 * 60 * 1000);
            time += (double)(minutes * 60 * 1000);
            time += (double)(seconds * 1000);
            time += (double)(i * 24 * 60 * 60 * 1000);
        } else if (this.timeUnit.equals("Seconds") || this.timeUnit.equals("Seconds\n")) {
            time += (double)(hours * 60 * 60);
            time += (double)(minutes * 60);
            time += (double)seconds;
            time += (double)(i * 24 * 60 * 60);
        } else if (this.timeUnit.equals("Minutes") || this.timeUnit.equals("Minutes\n")) {
            time += (double)(hours * 60);
            time += (double)minutes;
            time += (double)(seconds / 60);
            time += (double)(i * 24 * 60);
        } else if (this.timeUnit.equals("Hours") || this.timeUnit.equals("Hours\n")) {
            time += (double)hours;
            time += (double)(minutes / 60);
            time += (double)(seconds / 3600);
            time += (double)(i * 24);
        }
        return time;
    }

    public double calculate(double t) {
        if (!this.oldTimeUnit.equals(this.timeUnit)) {
            if (this.oldTimeUnit.equals("Milliseconds\n") || this.oldTimeUnit.equals("Milliseconds")) {
                if (this.timeUnit.equals("Seconds") || this.timeUnit.equals("Seconds\n")) {
                    t /= 1000.0;
                } else if (this.timeUnit.equals("Minutes") || this.timeUnit.equals("Minutes\n")) {
                    t /= 60000.0;
                } else if (this.timeUnit.equals("Hours") || this.timeUnit.equals("Hours\n")) {
                    t /= 3600000.0;
                }
            } else if (this.oldTimeUnit.equals("Seconds\n") || this.oldTimeUnit.equals("Seconds")) {
                if (this.timeUnit.equals("Milliseconds") || this.timeUnit.equals("Milliseconds\n")) {
                    t *= 1000.0;
                } else if (this.timeUnit.equals("Minutes") || this.timeUnit.equals("Minutes\n")) {
                    t /= 60.0;
                } else if (this.timeUnit.equals("Hours") || this.timeUnit.equals("Hours\n")) {
                    t /= 3600.0;
                }
            } else if (this.oldTimeUnit.equals("Minutes\n") || this.oldTimeUnit.equals("Minutes")) {
                if (this.timeUnit.equals("Milliseconds") || this.timeUnit.equals("Milliseconds\n")) {
                    t = t * 1000.0 * 60.0;
                } else if (this.timeUnit.equals("Seconds") || this.timeUnit.equals("Seconds\n")) {
                    t *= 60.0;
                } else if (this.timeUnit.equals("Hours") || this.timeUnit.equals("Hours\n")) {
                    t /= 60.0;
                }
            } else if (this.oldTimeUnit.equals("Hours\n") || this.oldTimeUnit.equals("Hours")) {
                if (this.timeUnit.equals("Milliseconds") || this.timeUnit.equals("Milliseconds\n")) {
                    t = t * 1000.0 * 60.0 * 60.0;
                } else if (this.timeUnit.equals("Seconds") || this.timeUnit.equals("Seconds\n")) {
                    t = t * 60.0 * 60.0;
                } else if (this.timeUnit.equals("Minutes") || this.timeUnit.equals("Minutes\n")) {
                    t *= 60.0;
                }
            }
        }
        return t;
    }

    public void updateOganizationEnvironmentModel(ActorResource selectedActor, ArrayList<ActorResource> actorList) {
        int y = 0;
        while (y < actorList.size()) {
            WorkingPeriod p;
            int i;
            if (selectedActor.equals(actorList.get(y)) && selectedActor.equals(this.actorCalendar.selectedActor)) {
                selectedActor.getWorkingPeriods().clear();
                i = 0;
                while (i < this.actorCalendar.getDays().size()) {
                    int j = 0;
                    while (j < this.actorCalendar.getDays().get(i).getProfile().getPeriods().size()) {
                        p = OrganizationenvironmentmodelFactory.eINSTANCE.createWorkingPeriod();
                        SimpleDateFormat start = this.actorCalendar.getDays().get(i).getProfile().getPeriods().get(j).getStartTimePoint();
                        p.setPeriodStartTimePoint(this.calculateTimeUnits(start, i));
                        SimpleDateFormat end = this.actorCalendar.getDays().get(i).getProfile().getPeriods().get(j).getEndTimePointtime();
                        p.setPeriodEndTimePoint(this.calculateTimeUnits(end, i));
                        selectedActor.getWorkingPeriods().add((Object)p);
                        ++j;
                    }
                    ++i;
                }
            } else if (!this.actorCalendar.actorDayProfilesLists.get(y).equals(this.actorCalendar.helpList)) {
                actorList.get(y).getWorkingPeriods().clear();
                i = 0;
                while (i < this.actorCalendar.getDays().size()) {
                    int x = 0;
                    int z = 0;
                    while (z < this.actorCalendar.actorDayProfilesLists.get(y).size()) {
                        if (this.actorCalendar.getDays().get(i).getProfile().getName().equals(this.actorCalendar.actorDayProfilesLists.get(y).get(z).getName())) {
                            x = z;
                        }
                        ++z;
                    }
                    int j = 0;
                    while (j < this.actorCalendar.actorDayProfilesLists.get(y).get(x).getPeriods().size()) {
                        p = OrganizationenvironmentmodelFactory.eINSTANCE.createWorkingPeriod();
                        SimpleDateFormat start = this.actorCalendar.actorDayProfilesLists.get(y).get(x).getPeriods().get(j).getStartTimePoint();
                        p.setPeriodStartTimePoint(this.calculateTimeUnits(start, i));
                        SimpleDateFormat end = this.actorCalendar.actorDayProfilesLists.get(y).get(x).getPeriods().get(j).getEndTimePointtime();
                        p.setPeriodEndTimePoint(this.calculateTimeUnits(end, i));
                        actorList.get(y).getWorkingPeriods().add((Object)p);
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.updateListOEM(actorList, y);
            }
            ++y;
        }
    }

    public void updateUSM(ArrayList<UsageScenario> scenarioList) {
        int y = 0;
        while (y < scenarioList.size()) {
            Workload w = scenarioList.get(y).getWorkload_UsageScenario();
            assert (w instanceof ProcessWorkload) : "only ProcessWorkloads allowed";
            this.updateListUSM(w);
            ++y;
        }
    }

    public void updateOEM(ArrayList<ActorResource> actorList) {
        int y = 0;
        while (y < actorList.size()) {
            this.updateListOEM(actorList, y);
            ++y;
        }
    }

    public void updateListOEM(ArrayList<ActorResource> actorList, int y) {
        ArrayList<WorkingPeriod> period = new ArrayList<WorkingPeriod>();
        int i = 0;
        while (i < actorList.get(y).getWorkingPeriods().size()) {
            WorkingPeriod p = OrganizationenvironmentmodelFactory.eINSTANCE.createWorkingPeriod();
            double start = ((WorkingPeriod)actorList.get(y).getWorkingPeriods().get(i)).getPeriodStartTimePoint();
            p.setPeriodStartTimePoint(this.calculate(start));
            double end = ((WorkingPeriod)actorList.get(y).getWorkingPeriods().get(i)).getPeriodEndTimePoint();
            p.setPeriodEndTimePoint(this.calculate(end));
            period.add(p);
            ++i;
        }
        actorList.get(y).getWorkingPeriods().clear();
        i = 0;
        while (i < period.size()) {
            actorList.get(y).getWorkingPeriods().add((Object)((WorkingPeriod)period.get(i)));
            ++i;
        }
    }

    public void updateListUSM(Workload w) {
        ArrayList<ProcessTriggerPeriod> period = new ArrayList<ProcessTriggerPeriod>();
        int i = 0;
        while (i < ((ProcessWorkload)w).getProcessTriggerPeriods().size()) {
            ProcessTriggerPeriod p = BpusagemodelFactory.eINSTANCE.createProcessTriggerPeriod();
            double start = ((ProcessTriggerPeriod)((ProcessWorkload)w).getProcessTriggerPeriods().get(i)).getPeriodStartTimePoint();
            p.setPeriodStartTimePoint(this.calculate(start));
            double end = ((ProcessTriggerPeriod)((ProcessWorkload)w).getProcessTriggerPeriods().get(i)).getPeriodEndTimePoint();
            p.setPeriodEndTimePoint(this.calculate(end));
            this.v = CoreFactory.eINSTANCE.createPCMRandomVariable();
            this.v.setSpecification(((ProcessTriggerPeriod)((ProcessWorkload)w).getProcessTriggerPeriods().get(i)).getInterArrivalTime_ProcessWorkload().getSpecification());
            p.setInterArrivalTime_ProcessWorkload(this.v);
            period.add(p);
            ++i;
        }
        ((ProcessWorkload)w).getProcessTriggerPeriods().clear();
        i = 0;
        while (i < period.size()) {
            ((ProcessWorkload)w).getProcessTriggerPeriods().add((Object)((ProcessTriggerPeriod)period.get(i)));
            ++i;
        }
    }
}

