/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.test;

import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMark;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyContext;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import edu.kit.ipd.sdq.kamp.core.Activity;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelFactoryFacade;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersionPersistency;
import edu.kit.ipd.sdq.kamp.core.DifferenceCalculation;
import edu.kit.ipd.sdq.kamp.core.EnrichedWorkplanDerivation;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class KAMPApplicationTest {
    ArchitectureVersion baseArchitectureVersion;

    @Before
    public void setUp() throws Exception {
        this.baseArchitectureVersion = KAMPApplicationTest.setupBasePCMModel("basemodel");
        ArchitectureVersionPersistency.save(this.baseArchitectureVersion.getName(), this.baseArchitectureVersion);
    }

    private static ArchitectureVersion setupBasePCMModel(String name) {
        ArchitectureVersion baseversion = ArchitectureModelFactoryFacade.createEmptyModel(name);
        BasicComponent client = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Client");
        BasicComponent server = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Server");
        BasicComponent database = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Database");
        OperationInterface clientInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ClientInterface");
        OperationInterface serverInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ServerInterface");
        OperationInterface databaseInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "DatabaseInterface");
        ArchitectureModelFactoryFacade.createProvidedRole(client, clientInterface);
        ArchitectureModelFactoryFacade.createRequiredRole(client, serverInterface);
        ArchitectureModelFactoryFacade.createProvidedRole(server, serverInterface);
        ArchitectureModelFactoryFacade.createRequiredRole(server, databaseInterface);
        ArchitectureModelFactoryFacade.createProvidedRole(database, databaseInterface);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)client, baseversion);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)server, baseversion);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)database, baseversion);
        ArchitectureModelFactoryFacade.createAssemblyConnector((RepositoryComponent)server, (RepositoryComponent)client, baseversion);
        ArchitectureModelFactoryFacade.createAssemblyConnector((RepositoryComponent)database, (RepositoryComponent)server, baseversion);
        ArchitectureModelFactoryFacade.setupComponentInternalDependenciesPessimistic(baseversion);
        return baseversion;
    }

    @After
    public void tearDown() {
        this.baseArchitectureVersion.delete();
        this.baseArchitectureVersion = null;
    }

    @Test
    public void testWholeAnalysis() {
        ArchitectureVersion subVersion = ArchitectureVersionPersistency.createArchitectureVersionClone(this.baseArchitectureVersion, "SubVersion(InsertDatabaseCache)");
        BasicComponent cacheComponent = ArchitectureModelFactoryFacade.createBasicComponent(subVersion, "DatabaseCache");
        OperationInterface dbInterface = (OperationInterface)ArchitectureModelLookup.lookUpInterfaceByName(subVersion, "DatabaseInterface");
        ArchitectureModelFactoryFacade.createProvidedRole(cacheComponent, dbInterface);
        ArchitectureModelFactoryFacade.createRequiredRole(cacheComponent, dbInterface);
        RepositoryComponent server = ArchitectureModelLookup.lookUpComponentByName(subVersion, "Server");
        RepositoryComponent database = ArchitectureModelLookup.lookUpComponentByName(subVersion, "Database");
        AssemblyContext databaseContext = ArchitectureModelLookup.lookUpAssemblyContextsForRepositoryComponents(subVersion, database).get(0);
        Assert.assertTrue((String)"Database Context not found", (databaseContext != null ? 1 : 0) != 0);
        AssemblyContext serverContext = ArchitectureModelLookup.lookUpAssemblyContextsForRepositoryComponents(subVersion, server).get(0);
        Assert.assertTrue((String)"Server Context not found", (serverContext != null ? 1 : 0) != 0);
        List<AssemblyConnector> assemblyConnectors = ArchitectureModelLookup.lookUpAssemblyConnectorsBetweenAssemblyContexts(databaseContext, serverContext);
        Assert.assertTrue((String)"Assembly connector not found", (assemblyConnectors.size() == 1 ? 1 : 0) != 0);
        ArchitectureModelFactoryFacade.deleteAssemblyConnector(assemblyConnectors.get(0));
        Assert.assertTrue((String)"Assembly connectors not deleted properly", (ArchitectureModelLookup.lookUpAssemblyConnectorsBetweenAssemblyContexts(databaseContext, serverContext).size() == 0 ? 1 : 0) != 0);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)cacheComponent, subVersion);
        Assert.assertTrue((String)"Assembly context for cache not properly created", (ArchitectureModelLookup.lookUpAssemblyContextsForRepositoryComponents(subVersion, (RepositoryComponent)cacheComponent).size() == 1 ? 1 : 0) != 0);
        AssemblyContext cacheAssemblyContext = ArchitectureModelLookup.lookUpAssemblyContextsForRepositoryComponents(subVersion, (RepositoryComponent)cacheComponent).get(0);
        ArchitectureModelFactoryFacade.createAssemblyConnector((RepositoryComponent)cacheComponent, server, subVersion);
        Assert.assertTrue((String)"Assembly connector between server and cache not created properly", (ArchitectureModelLookup.lookUpAssemblyConnectorsBetweenAssemblyContexts(cacheAssemblyContext, serverContext).size() == 1 ? 1 : 0) != 0);
        ArchitectureModelFactoryFacade.createAssemblyConnector(database, (RepositoryComponent)cacheComponent, subVersion);
        Assert.assertTrue((String)"Assembly connectors not deleted properly", (ArchitectureModelLookup.lookUpAssemblyConnectorsBetweenAssemblyContexts(databaseContext, cacheAssemblyContext).size() == 1 ? 1 : 0) != 0);
        ArchitectureModelFactoryFacade.assignInternalModificationMarkToComponent(subVersion, database);
        InternalModificationMark internalModificationMark = ArchitectureModelLookup.lookUpInternalModificationMarkForComponent(subVersion, database);
        Assert.assertTrue((String)"InternalModificationMark not found", (internalModificationMark != null ? 1 : 0) != 0);
        List<Activity> baseActivityList = DifferenceCalculation.deriveWorkplan(this.baseArchitectureVersion, subVersion);
        Assert.assertTrue((String)"No activities detected", (!baseActivityList.isEmpty() ? 1 : 0) != 0);
        System.out.println("Base Activity List:");
        this.printActivities(baseActivityList, "Top:");
        Assert.assertTrue((String)"Different number of base activities expected", (baseActivityList.size() == 2 ? 1 : 0) != 0);
        List<Activity> enrichedActivityList = EnrichedWorkplanDerivation.deriveEnrichedWorkplan(this.baseArchitectureVersion, subVersion, baseActivityList);
        Assert.assertTrue((String)"No enriched activities detected", (!enrichedActivityList.isEmpty() ? 1 : 0) != 0);
        Assert.assertTrue((String)"No difference to base activity list", (enrichedActivityList.size() == baseActivityList.size() ? 1 : 0) != 0);
        System.out.println("Enriched Activity List:");
        this.printActivities(baseActivityList, "Top:");
    }

    private void printActivities(List<Activity> activityList, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        for (Activity activity : activityList) {
            System.out.println(String.valueOf(prefix) + " " + (Object)((Object)activity.getBasicActivity()) + " " + (Object)((Object)activity.getElementType()) + " " + activity.getElementName());
            if (!activity.getSubactivities().isEmpty()) {
                this.printActivities(activity.getSubactivities(), String.valueOf(prefix) + "=");
            }
            if (activity.getFollowupActivities().isEmpty()) continue;
            this.printActivities(activity.getFollowupActivities(), String.valueOf(prefix) + "->");
        }
    }
}

