/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.test;

import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.repository.ProvidedRole;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import de.uka.ipd.sdq.pcm.repository.RequiredRole;
import edu.kit.ipd.sdq.kamp.core.Activity;
import edu.kit.ipd.sdq.kamp.core.ActivityElementType;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelFactoryFacade;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersionPersistency;
import edu.kit.ipd.sdq.kamp.core.BasicActivity;
import edu.kit.ipd.sdq.kamp.core.DifferenceCalculation;
import java.io.IOException;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DifferenceKind;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DifferenceDetectionTest {
    ArchitectureVersion baseArchitectureVersion;
    ArchitectureVersion targetArchitectureVersion;

    @Before
    public void setUp() throws Exception {
        this.baseArchitectureVersion = DifferenceDetectionTest.setupBasePCMModel("basemodel");
        ArchitectureVersionPersistency.save(this.baseArchitectureVersion.getName(), this.baseArchitectureVersion);
        this.targetArchitectureVersion = this.saveAsAndReload(this.baseArchitectureVersion, "targetmodel");
    }

    private ArchitectureVersion saveAsAndReload(ArchitectureVersion saveVersion, String targetname) {
        try {
            ArchitectureVersionPersistency.save(targetname, saveVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArchitectureVersion loadVersion = null;
        try {
            loadVersion = ArchitectureVersionPersistency.load(targetname, targetname);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return loadVersion;
    }

    @After
    public void tearDown() {
        this.baseArchitectureVersion.delete();
        this.targetArchitectureVersion.delete();
        this.baseArchitectureVersion = null;
        this.targetArchitectureVersion = null;
    }

    private static ArchitectureVersion setupBasePCMModel(String name) {
        ArchitectureVersion baseversion = ArchitectureModelFactoryFacade.createEmptyModel(name);
        BasicComponent client = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Client");
        BasicComponent server = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Server");
        BasicComponent database = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Database");
        OperationInterface clientInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ClientInterface");
        OperationInterface serverInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ServerInterface");
        OperationInterface databaseInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "DatabaseInterface");
        ArchitectureModelFactoryFacade.createProvidedRole(client, clientInterface);
        ArchitectureModelFactoryFacade.createRequiredRole(client, serverInterface);
        ArchitectureModelFactoryFacade.createProvidedRole(server, serverInterface);
        ArchitectureModelFactoryFacade.createRequiredRole(server, databaseInterface);
        ArchitectureModelFactoryFacade.createProvidedRole(database, databaseInterface);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)client, baseversion);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)server, baseversion);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)database, baseversion);
        return baseversion;
    }

    @Test
    public void testDeepClone() {
        Assert.assertTrue((String)"TargetRepository is null", (this.targetArchitectureVersion.getRepository() != null ? 1 : 0) != 0);
        System.out.println("baseModelId:  " + this.baseArchitectureVersion.getRepository().getId());
        System.out.println("targetModelId:" + this.targetArchitectureVersion.getRepository().getId());
        Assert.assertTrue((String)"Repository-ID-Check failed", (boolean)this.baseArchitectureVersion.getRepository().getId().equals(this.targetArchitectureVersion.getRepository().getId()));
        Assert.assertTrue((String)"Number of Components different", (this.baseArchitectureVersion.getRepository().getComponents__Repository().size() == this.targetArchitectureVersion.getRepository().getComponents__Repository().size() ? 1 : 0) != 0);
        int i = 0;
        while (i < this.baseArchitectureVersion.getRepository().getComponents__Repository().size()) {
            RepositoryComponent targetComponent;
            RepositoryComponent sourceComponent = (RepositoryComponent)this.baseArchitectureVersion.getRepository().getComponents__Repository().get(i);
            Assert.assertTrue((String)"Components are identical", (sourceComponent != (targetComponent = (RepositoryComponent)this.targetArchitectureVersion.getRepository().getComponents__Repository().get(i)) ? 1 : 0) != 0);
            Assert.assertTrue((String)"Component-ID-Check failed", (boolean)sourceComponent.getId().equals(targetComponent.getId()));
            Assert.assertTrue((String)"Component: number of provided roles different", (sourceComponent.getProvidedRoles_InterfaceProvidingEntity().size() == targetComponent.getProvidedRoles_InterfaceProvidingEntity().size() ? 1 : 0) != 0);
            Assert.assertTrue((String)"Component: number of required roles different", (sourceComponent.getRequiredRoles_InterfaceRequiringEntity().size() == targetComponent.getRequiredRoles_InterfaceRequiringEntity().size() ? 1 : 0) != 0);
            ++i;
        }
        Assert.assertTrue((String)"Interface for Provided Role is null", (((OperationProvidedRole)((RepositoryComponent)this.targetArchitectureVersion.getRepository().getComponents__Repository().get(0)).getProvidedRoles_InterfaceProvidingEntity().get(0)).getProvidedInterface__OperationProvidedRole() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Number of Interfaces in Repository different", (this.baseArchitectureVersion.getRepository().getInterfaces__Repository().size() == this.targetArchitectureVersion.getRepository().getInterfaces__Repository().size() ? 1 : 0) != 0);
        Assert.assertTrue((String)"Number of Datatypes in Repository different", (this.baseArchitectureVersion.getRepository().getDataTypes__Repository().size() == this.targetArchitectureVersion.getRepository().getDataTypes__Repository().size() ? 1 : 0) != 0);
    }

    @Test
    public void testEMFCompareDiffUsage() {
        BasicComponent testComponent = ArchitectureModelFactoryFacade.createBasicComponent(this.targetArchitectureVersion, "AddedTestComponent");
        OperationInterface testInterface = ArchitectureModelFactoryFacade.createInterface(this.targetArchitectureVersion, "AddedTestInterface");
        ArchitectureModelFactoryFacade.createProvidedRole(testComponent, testInterface);
        MatchModel matchModel = null;
        try {
            matchModel = MatchService.doMatch((EObject)this.targetArchitectureVersion.getRepository(), (EObject)this.baseArchitectureVersion.getRepository(), null);
        }
        catch (InterruptedException e) {
            Assert.fail((String)("Model Matching interrupted, " + e.getMessage()));
        }
        Assert.assertTrue((String)"MatchModel null", (matchModel != null ? 1 : 0) != 0);
        if (matchModel != null) {
            DiffModel diff = DiffService.doDiff((MatchModel)matchModel);
            Assert.assertTrue((String)"DiffModel null", (diff != null ? 1 : 0) != 0);
            Assert.assertTrue((String)"DiffModel is empty (no contents)", (!diff.eContents().isEmpty() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDifferenceCalculationOnRepository() {
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        System.out.println("elements from tree-iterator:");
        TreeIterator iterator = diff.eAllContents();
        while (iterator.hasNext()) {
            EObject el = (EObject)iterator.next();
            System.out.println(String.valueOf(el.eClass().getName()) + ": " + el.toString());
        }
        System.out.println("elements from differences-list:");
        for (DiffElement diffElement : diff.getDifferences()) {
            OperationInterface operationInterface;
            BasicComponent basicComponent;
            ModelElementChangeLeftTarget element;
            System.out.println(">>> " + diffElement.eClass().getName());
            System.out.println(diffElement.toString());
            System.out.println("kind: " + diffElement.getKind().toString());
            System.out.println("has subdiffs: " + !diffElement.getSubDiffElements().isEmpty());
            if (diffElement instanceof ModelElementChangeLeftTarget) {
                element = (ModelElementChangeLeftTarget)diffElement;
                System.out.println("Left Element: " + element.getLeftElement());
                System.out.println("Right Parent: " + element.getRightParent());
                if (element.getLeftElement() instanceof BasicComponent) {
                    basicComponent = (BasicComponent)element.getLeftElement();
                    System.out.println("Action: Basic Component " + basicComponent + " Added");
                } else if (element.getLeftElement() instanceof OperationInterface) {
                    operationInterface = (OperationInterface)element.getLeftElement();
                    System.out.println("Action: Interface " + operationInterface + " Added");
                } else if (element.getLeftElement() instanceof OperationRequiredRole) {
                    OperationRequiredRole requiredRole = (OperationRequiredRole)element.getLeftElement();
                    System.out.println("Action: OperationRequiredRole " + requiredRole + " Added");
                } else if (element.getLeftElement() instanceof OperationProvidedRole) {
                    OperationProvidedRole providedRole = (OperationProvidedRole)element.getLeftElement();
                    System.out.println("Action: OperationProvidedRole " + providedRole + " Added");
                } else {
                    System.out.println("not matched");
                }
            } else if (diffElement instanceof ModelElementChangeRightTarget) {
                element = (ModelElementChangeRightTarget)diffElement;
                System.out.println("Right Element: " + element.getRightElement());
                System.out.println("Left Parent: " + element.getLeftParent());
                if (element.getRightElement() instanceof BasicComponent) {
                    basicComponent = (BasicComponent)element.getRightElement();
                    System.out.println("Action: Basic Component " + basicComponent + " Deleted");
                } else if (element.getRightElement() instanceof OperationInterface) {
                    operationInterface = (OperationInterface)element.getRightElement();
                    System.out.println("Action: Interface " + operationInterface + " Deleted");
                } else {
                    System.out.println("not matched");
                }
            } else if (diffElement instanceof UpdateReference) {
                element = (UpdateReference)diffElement;
                System.out.println("Left Element: " + element.getLeftElement());
                System.out.println("Left Target: " + element.getLeftTarget());
                System.out.println("Right Element: " + element.getRightElement());
                System.out.println("Right Target: " + element.getRightTarget());
                if (element.getKind() == DifferenceKind.CHANGE && element.getRightTarget() == null && element.getLeftElement() instanceof ProvidedRole && element.getLeftTarget() instanceof OperationInterface) {
                    System.out.println("Action: Interface for Provided Role deleted.");
                } else if (element.getKind() == DifferenceKind.CHANGE && element.getRightTarget() == null && element.getLeftElement() instanceof RequiredRole && element.getLeftTarget() instanceof OperationInterface) {
                    System.out.println("Action: Interface for Required Role deleted.");
                } else {
                    System.out.println("not matched");
                }
            } else {
                System.out.println("not matched");
            }
            System.out.println("----");
        }
    }

    @Test
    public void testDifferenceDetectionRules_AddedBasicComponent() {
        ArchitectureModelFactoryFacade.createBasicComponent(this.targetArchitectureVersion, "AddedTestComponent");
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        List<DiffElement> diffElements = DifferenceCalculation.foundAddedBasicComponent(diff);
        Assert.assertTrue((String)"Added Basic Component Not Found", (diffElements.size() == 1 ? 1 : 0) != 0);
        EObject component = DifferenceCalculation.retrieveArchitectureElement(diffElements.get(0));
        Assert.assertTrue((String)"Added Basic Component Not Retrieved Properly", (component != null && component instanceof BasicComponent ? 1 : 0) != 0);
    }

    @Test
    public void testDifferenceDetectionRules_RemovedBasicComponent() {
        EcoreUtil.delete((EObject)((EObject)this.targetArchitectureVersion.getRepository().getComponents__Repository().get(0)));
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        List<DiffElement> diffElements = DifferenceCalculation.foundDeletedBasicComponent(diff);
        Assert.assertTrue((String)"Deleted Basic Component Not Found", (diffElements.size() == 1 ? 1 : 0) != 0);
        EObject component = DifferenceCalculation.retrieveArchitectureElement(diffElements.get(0));
        Assert.assertTrue((String)"Deleted Basic Component Not Retrieved Properly", (component != null && component instanceof BasicComponent ? 1 : 0) != 0);
    }

    @Test
    public void testDifferenceDetectionRules_AddedInterface() {
        ArchitectureModelFactoryFacade.createInterface(this.targetArchitectureVersion, "AddedTestInterface");
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        List<DiffElement> diffElements = DifferenceCalculation.foundAddedInterface(diff);
        Assert.assertTrue((String)"Added Interface Not Found", (diffElements.size() == 1 ? 1 : 0) != 0);
        EObject interf = DifferenceCalculation.retrieveArchitectureElement(diffElements.get(0));
        Assert.assertTrue((String)"Added Interface Not Retrieved Properly", (interf != null && interf instanceof OperationInterface ? 1 : 0) != 0);
    }

    @Test
    public void testDifferenceDetectionRules_RemovedInterface() {
        EcoreUtil.delete((EObject)((EObject)this.targetArchitectureVersion.getRepository().getInterfaces__Repository().get(0)));
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        List<DiffElement> diffElements = DifferenceCalculation.foundDeletedInterface(diff);
        Assert.assertTrue((String)"Deleted Interface Not Found", (diffElements.size() == 1 ? 1 : 0) != 0);
        EObject interf = DifferenceCalculation.retrieveArchitectureElement(diffElements.get(0));
        Assert.assertTrue((String)"Deleted Interface Not Retrieved Properly", (interf != null && interf instanceof OperationInterface ? 1 : 0) != 0);
    }

    @Test
    public void testDifferenceDetectionRules_RemovedInterfaceForProvidedRole() {
        EcoreUtil.delete((EObject)((EObject)this.targetArchitectureVersion.getRepository().getInterfaces__Repository().get(0)));
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        List<DiffElement> diffElements = DifferenceCalculation.foundDeletedInterfaceForProvidedRole(diff);
        Assert.assertTrue((String)"Deleted Interface For ProvidedRole Not Found", (diffElements.size() == 1 ? 1 : 0) != 0);
        EObject role = DifferenceCalculation.retrieveArchitectureElement(diffElements.get(0));
        Assert.assertTrue((String)"Provided Role with Deleted Interface Not Retrieved Properly", (role != null && role instanceof ProvidedRole ? 1 : 0) != 0);
    }

    @Test
    public void testDifferenceDetectionRules_RemovedInterfaceForRequiredRole() {
        EcoreUtil.delete((EObject)((EObject)this.targetArchitectureVersion.getRepository().getInterfaces__Repository().get(1)));
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        List<DiffElement> diffElements = DifferenceCalculation.foundDeletedInterfaceForRequiredRole(diff);
        Assert.assertTrue((String)"Deleted Interface For RequiredRole Not Found", (diffElements.size() == 1 ? 1 : 0) != 0);
        EObject role = DifferenceCalculation.retrieveArchitectureElement(diffElements.get(0));
        Assert.assertTrue((String)"Required Role with Deleted Interface Not Retrieved Properly", (role != null && role instanceof RequiredRole ? 1 : 0) != 0);
    }

    @Test
    public void testDifferenceDetectionRules_AddProvidedRole() {
        OperationInterface testInterface = ArchitectureModelFactoryFacade.createInterface(this.targetArchitectureVersion, "AddedTestInterface");
        ArchitectureModelFactoryFacade.createProvidedRole((BasicComponent)this.targetArchitectureVersion.getRepository().getComponents__Repository().get(0), testInterface);
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        List<DiffElement> diffElements = DifferenceCalculation.foundAddedProvidedRole(diff);
        Assert.assertTrue((String)"Added Provided Role not found", (diffElements.size() == 1 ? 1 : 0) != 0);
        EObject role = DifferenceCalculation.retrieveArchitectureElement(diffElements.get(0));
        Assert.assertTrue((String)"Added Provided Role not Retrieved Properly", (role != null && role instanceof ProvidedRole ? 1 : 0) != 0);
    }

    @Test
    public void testDifferenceDetectionRules_AddRequiredRole() {
        OperationInterface testInterface = ArchitectureModelFactoryFacade.createInterface(this.targetArchitectureVersion, "AddedTestInterface");
        ArchitectureModelFactoryFacade.createRequiredRole((BasicComponent)this.targetArchitectureVersion.getRepository().getComponents__Repository().get(0), testInterface);
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        List<DiffElement> diffElements = DifferenceCalculation.foundAddedRequiredRole(diff);
        Assert.assertTrue((String)"Added Required Role not found", (diffElements.size() == 1 ? 1 : 0) != 0);
        EObject role = DifferenceCalculation.retrieveArchitectureElement(diffElements.get(0));
        Assert.assertTrue((String)"Added Required Role not Retrieved Properly", (role != null && role instanceof RequiredRole ? 1 : 0) != 0);
    }

    @Test
    public void testDifferenceDetectionRules_DeleteProvidedRole() {
        EcoreUtil.delete((EObject)((EObject)((RepositoryComponent)this.targetArchitectureVersion.getRepository().getComponents__Repository().get(0)).getProvidedRoles_InterfaceProvidingEntity().get(0)));
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        List<DiffElement> diffElements = DifferenceCalculation.foundDeletedProvidedRole(diff);
        Assert.assertTrue((String)"Deleted Provided Role not found", (diffElements.size() == 1 ? 1 : 0) != 0);
        EObject role = DifferenceCalculation.retrieveArchitectureElement(diffElements.get(0));
        Assert.assertTrue((String)"Deleted Provided Role not Retrieved Properly", (role != null && role instanceof ProvidedRole ? 1 : 0) != 0);
    }

    @Test
    public void testDifferenceDetectionRules_DeleteRequiredRole() {
        EcoreUtil.delete((EObject)((EObject)((RepositoryComponent)this.targetArchitectureVersion.getRepository().getComponents__Repository().get(0)).getRequiredRoles_InterfaceRequiringEntity().get(0)));
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        List<DiffElement> diffElements = DifferenceCalculation.foundDeletedRequiredRole(diff);
        Assert.assertTrue((String)"Deleted Required Role not found", (diffElements.size() == 1 ? 1 : 0) != 0);
        EObject role = DifferenceCalculation.retrieveArchitectureElement(diffElements.get(0));
        Assert.assertTrue((String)"Deleted Provided Role not Retrieved Properly", (role != null && role instanceof RequiredRole ? 1 : 0) != 0);
    }

    @Test
    public void testWorkplanGeneration_AddBasicComponent() {
        ArchitectureModelFactoryFacade.createBasicComponent(this.targetArchitectureVersion, "AddedTestComponent");
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getRepository(), (EObject)this.targetArchitectureVersion.getRepository());
        List<Activity> workplan = DifferenceCalculation.deriveBaseWorkPlan(diff);
        Assert.assertTrue((String)"Added Basic Component Not Found", (!workplan.isEmpty() && workplan.get(0).getBasicActivity() == BasicActivity.ADD && workplan.get(0).getElementType() == ActivityElementType.COMPONENT ? 1 : 0) != 0);
    }

    @Test
    public void testDifferenceCalculationOnSystem() {
        RepositoryComponent client = ArchitectureModelLookup.lookUpComponentByName(this.targetArchitectureVersion, "Client");
        RepositoryComponent server = ArchitectureModelLookup.lookUpComponentByName(this.targetArchitectureVersion, "Server");
        ArchitectureModelFactoryFacade.createAssemblyConnector(client, server, this.targetArchitectureVersion);
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getSystem(), (EObject)this.targetArchitectureVersion.getSystem());
        System.out.println("elements from tree-iterator:");
        TreeIterator iterator = diff.eAllContents();
        while (iterator.hasNext()) {
            EObject el = (EObject)iterator.next();
            System.out.println(String.valueOf(el.eClass().getName()) + ": " + el.toString());
        }
        System.out.println("elements from differences-list:");
        for (DiffElement diffElement : diff.getDifferences()) {
            System.out.println(">>> " + diffElement.eClass().getName());
            System.out.println(diffElement.toString());
            System.out.println("kind: " + diffElement.getKind().toString());
            System.out.println("has subdiffs: " + !diffElement.getSubDiffElements().isEmpty());
        }
    }

    @Test
    public void testDifferenceDetectionRules_System_AssemblyConnectorAdded() {
        RepositoryComponent client = ArchitectureModelLookup.lookUpComponentByName(this.targetArchitectureVersion, "Client");
        RepositoryComponent server = ArchitectureModelLookup.lookUpComponentByName(this.targetArchitectureVersion, "Server");
        ArchitectureModelFactoryFacade.createAssemblyConnector(client, server, this.targetArchitectureVersion);
        DiffModel diff = DifferenceCalculation.calculateDiffModel((EObject)this.baseArchitectureVersion.getSystem(), (EObject)this.targetArchitectureVersion.getSystem());
        List<DiffElement> diffElements = DifferenceCalculation.foundAddedAssemblyConnector(diff);
        Assert.assertTrue((String)"Added Assembly Connector Not Found", (diffElements.size() == 1 ? 1 : 0) != 0);
        EObject connector = DifferenceCalculation.retrieveArchitectureElement(diffElements.get(0));
        Assert.assertTrue((String)"Added Assembly Connector Not Retrieved Properly", (connector != null && connector instanceof AssemblyConnector ? 1 : 0) != 0);
    }

    @Test
    public void testArchitectureModelLookup_lookUpComponentByName() {
        String testcomponentName = "LookUpComponent";
        BasicComponent testComponent = ArchitectureModelFactoryFacade.createBasicComponent(this.baseArchitectureVersion, testcomponentName);
        BasicComponent foundComponent = (BasicComponent)ArchitectureModelLookup.lookUpComponentByName(this.baseArchitectureVersion, testcomponentName);
        Assert.assertTrue((String)"Component not found", (foundComponent != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Wrong Component found", (foundComponent == testComponent ? 1 : 0) != 0);
        BasicComponent errorComponent = (BasicComponent)ArchitectureModelLookup.lookUpComponentByName(this.baseArchitectureVersion, null);
        Assert.assertTrue((String)"LookUp of missing component not resulted in null", (errorComponent == null ? 1 : 0) != 0);
    }
}

