/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.test;

import de.uka.ipd.sdq.componentInternalDependencies.RoleToRoleDependency;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.ProvidedRole;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import de.uka.ipd.sdq.pcm.repository.RequiredRole;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelFactoryFacade;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersionPersistency;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ChangePropagationDetectionTest {
    ArchitectureVersion baseArchitectureVersion;
    ArchitectureVersion targetArchitectureVersion;

    @Before
    public void setUp() throws Exception {
        this.baseArchitectureVersion = ChangePropagationDetectionTest.setupBasePCMModel("basemodel");
        ArchitectureVersionPersistency.save(this.baseArchitectureVersion.getName(), this.baseArchitectureVersion);
        this.targetArchitectureVersion = ArchitectureVersionPersistency.saveAsAndReload(this.baseArchitectureVersion, "targetmodel");
    }

    private static ArchitectureVersion setupBasePCMModel(String name) {
        ArchitectureVersion baseversion = ArchitectureModelFactoryFacade.createEmptyModel(name);
        BasicComponent client = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Client");
        BasicComponent server = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Server");
        BasicComponent database = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Database");
        OperationInterface clientInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ClientInterface");
        OperationInterface serverInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ServerInterface");
        OperationInterface databaseInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "DatabaseInterface");
        ArchitectureModelFactoryFacade.createProvidedRole(client, clientInterface);
        ArchitectureModelFactoryFacade.createRequiredRole(client, serverInterface);
        ArchitectureModelFactoryFacade.createProvidedRole(server, serverInterface);
        ArchitectureModelFactoryFacade.createRequiredRole(server, databaseInterface);
        ArchitectureModelFactoryFacade.createProvidedRole(database, databaseInterface);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)client, baseversion);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)server, baseversion);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)database, baseversion);
        return baseversion;
    }

    @After
    public void tearDown() {
        this.baseArchitectureVersion.delete();
        this.targetArchitectureVersion.delete();
        this.baseArchitectureVersion = null;
        this.targetArchitectureVersion = null;
    }

    @Test
    public void testComponentInternalDependencies_Creation() {
        BasicComponent client = (BasicComponent)ArchitectureModelLookup.lookUpComponentByName(this.baseArchitectureVersion, "Client");
        ProvidedRole providedRole = (ProvidedRole)client.getProvidedRoles_InterfaceProvidingEntity().get(0);
        RequiredRole requiredRole = (RequiredRole)client.getRequiredRoles_InterfaceRequiringEntity().get(0);
        ArchitectureModelFactoryFacade.createComponentInternalDependency(this.baseArchitectureVersion, providedRole, requiredRole);
        RoleToRoleDependency dependency = ArchitectureModelLookup.lookUpComponentInternalDependency(this.baseArchitectureVersion, client);
        Assert.assertTrue((String)"Created Component Internal Dependency not found.", (dependency != null ? 1 : 0) != 0);
    }

    @Test
    public void testComponentInternalDependencies_LookUpDependentProvidedRolesForRequiredRole() {
        BasicComponent client = (BasicComponent)ArchitectureModelLookup.lookUpComponentByName(this.baseArchitectureVersion, "Client");
        OperationInterface secondInterf = ArchitectureModelFactoryFacade.createInterface(this.baseArchitectureVersion, "SecondInterface");
        OperationInterface thirdInterf = ArchitectureModelFactoryFacade.createInterface(this.baseArchitectureVersion, "ThirdInterface");
        ArchitectureModelFactoryFacade.createProvidedRole(client, secondInterf);
        ArchitectureModelFactoryFacade.createProvidedRole(client, thirdInterf);
        ProvidedRole firstProvidedRole = (ProvidedRole)client.getProvidedRoles_InterfaceProvidingEntity().get(0);
        ProvidedRole thirdProvidedRole = (ProvidedRole)client.getProvidedRoles_InterfaceProvidingEntity().get(2);
        RequiredRole requiredRole = (RequiredRole)client.getRequiredRoles_InterfaceRequiringEntity().get(0);
        ArchitectureModelFactoryFacade.createComponentInternalDependency(this.baseArchitectureVersion, firstProvidedRole, requiredRole);
        ArchitectureModelFactoryFacade.createComponentInternalDependency(this.baseArchitectureVersion, thirdProvidedRole, requiredRole);
        List<ProvidedRole> dependentProvidedRoles = ArchitectureModelLookup.lookUpDependentProvidedRolesForRequiredRole(this.baseArchitectureVersion, requiredRole);
        Assert.assertTrue((String)"Dependent ProvidedRoles not detected properly.", (dependentProvidedRoles.size() == 2 && dependentProvidedRoles.contains(firstProvidedRole) && dependentProvidedRoles.contains(thirdProvidedRole) ? 1 : 0) != 0);
    }
}

