/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.test;

import edu.kit.ipd.sdq.kamp.core.ArchitectureModelFactoryFacade;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersionPersistency;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class ArchitectureVersionPersistencyTest {
    @Test
    public void testEmptyModelCreation() {
        String name = "basemodel";
        ArchitectureVersion version = ArchitectureModelFactoryFacade.createEmptyModel(name);
        Assert.assertTrue((String)"Version null", (version != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Name not set properly", (boolean)name.equals(version.getName()));
        Assert.assertTrue((String)"Repository not set properly", (version.getRepository() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"System not set properly", (version.getSystem() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"InternalModificationModel not set properly", (version.getInternalModificationMarkRepository() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"ComponentInternalDepModel not set properly", (version.getComponentInternalDependencyRepository() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"FieldOfActivityModel not set properly", (version.getFieldOfActivityRepository() != null ? 1 : 0) != 0);
    }

    @Test
    public void testModelStoreAndLoad() {
        String baseName = "basemodel";
        ArchitectureVersion saveVersion = ArchitectureModelFactoryFacade.createEmptyModel(baseName);
        try {
            ArchitectureVersionPersistency.save(baseName, saveVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArchitectureVersion loadVersion = null;
        try {
            loadVersion = ArchitectureVersionPersistency.load(baseName, baseName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Assert.assertTrue((String)"Version null", (loadVersion != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Name not loaded properly", (boolean)baseName.equals(loadVersion.getName()));
        Assert.assertTrue((String)"Repository not loaded properly", (loadVersion.getRepository() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"System not set properly", (loadVersion.getSystem() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"InternalModificationModel not loaded properly", (loadVersion.getInternalModificationMarkRepository() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"ComponentInternalDepModel not loaded properly", (loadVersion.getComponentInternalDependencyRepository() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"FieldOfActivityModel not loaded properly", (loadVersion.getFieldOfActivityRepository() != null ? 1 : 0) != 0);
    }
}

