/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.test;

import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyContext;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelFactoryFacade;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.ProvidingRequiredRolePair;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ArchitectureModelFactoryTest {
    @Test
    public void testAssemblyConnectorCreation() {
        ArchitectureVersion version = ArchitectureModelFactoryFacade.createEmptyModel("test");
        BasicComponent provider = ArchitectureModelFactoryFacade.createBasicComponent(version, "provider");
        Assert.assertTrue((String)"Provider component not properly created", (provider != null && provider.getEntityName().equals("provider") ? 1 : 0) != 0);
        BasicComponent user = ArchitectureModelFactoryFacade.createBasicComponent(version, "user");
        Assert.assertTrue((String)"User component not properly created", (user != null && user.getEntityName().equals("user") ? 1 : 0) != 0);
        OperationInterface providerInterface = ArchitectureModelFactoryFacade.createInterface(version, "providerInterface");
        Assert.assertTrue((String)"Provider interface not properly created", (providerInterface != null && providerInterface.getEntityName().equals("providerInterface") ? 1 : 0) != 0);
        ArchitectureModelFactoryFacade.createProvidedRole(provider, providerInterface);
        Assert.assertTrue((String)"Provided role not properly created", (provider.getProvidedRoles_InterfaceProvidingEntity().size() == 1 && ((OperationProvidedRole)provider.getProvidedRoles_InterfaceProvidingEntity().get(0)).getProvidedInterface__OperationProvidedRole() == providerInterface ? 1 : 0) != 0);
        ArchitectureModelFactoryFacade.createRequiredRole(user, providerInterface);
        Assert.assertTrue((String)"Required role not properly created", (user.getRequiredRoles_InterfaceRequiringEntity().size() == 1 && ((OperationRequiredRole)user.getRequiredRoles_InterfaceRequiringEntity().get(0)).getRequiredInterface__OperationRequiredRole() == providerInterface ? 1 : 0) != 0);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)provider, version);
        List<AssemblyContext> assemblyContextsForProvider = ArchitectureModelLookup.lookUpAssemblyContextsForRepositoryComponents(version, (RepositoryComponent)provider);
        Assert.assertTrue((String)"Assembly context for provider not properly created", (assemblyContextsForProvider.size() == 1 && assemblyContextsForProvider.get(0).getEncapsulatedComponent__AssemblyContext() == provider ? 1 : 0) != 0);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)user, version);
        List<AssemblyContext> assemblyContextsForUser = ArchitectureModelLookup.lookUpAssemblyContextsForRepositoryComponents(version, (RepositoryComponent)user);
        Assert.assertTrue((String)"Assembly context for user not properly created", (assemblyContextsForUser.size() == 1 && assemblyContextsForUser.get(0).getEncapsulatedComponent__AssemblyContext() == user ? 1 : 0) != 0);
        List<ProvidingRequiredRolePair> matchingRolePairs = ArchitectureModelLookup.lookUpMatchingRolePairs((RepositoryComponent)provider, (RepositoryComponent)user);
        Assert.assertTrue((String)"Matching roles not found", (matchingRolePairs.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Found providing role not from provider", (matchingRolePairs.get(0).getProvidedRole() == provider.getProvidedRoles_InterfaceProvidingEntity().get(0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Found requiring role not from user", (matchingRolePairs.get(0).getRequiredRole() == user.getRequiredRoles_InterfaceRequiringEntity().get(0) ? 1 : 0) != 0);
        Assert.assertTrue((String)"Found matching role do not have similar interface types", (((OperationRequiredRole)matchingRolePairs.get(0).getRequiredRole()).getRequiredInterface__OperationRequiredRole() == ((OperationProvidedRole)matchingRolePairs.get(0).getProvidedRole()).getProvidedInterface__OperationProvidedRole() ? 1 : 0) != 0);
        ArchitectureModelFactoryFacade.createAssemblyConnector((RepositoryComponent)provider, (RepositoryComponent)user, version);
        Assert.assertTrue((String)"AssemblyConnector not found in System", (version.getSystem().getConnectors__ComposedStructure().size() == 1 && version.getSystem().getConnectors__ComposedStructure().get(0) instanceof AssemblyConnector ? 1 : 0) != 0);
        AssemblyConnector connector = (AssemblyConnector)version.getSystem().getConnectors__ComposedStructure().get(0);
        Assert.assertTrue((String)"Provided role of Assembly connector not properly created", (connector.getProvidedRole_AssemblyConnector() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Required role of Assembly connector not properly created", (connector.getRequiredRole_AssemblyConnector() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Provided assembly context of Assembly connector not properly created", (connector.getProvidingAssemblyContext_AssemblyConnector() != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"Required assembly context of Assembly connector not properly created", (connector.getRequiringAssemblyContext_AssemblyConnector() != null ? 1 : 0) != 0);
    }
}

