/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.test;

import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMark;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelFactoryFacade;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersionPersistency;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AnnotationModelsTest {
    ArchitectureVersion baseArchitectureVersion;
    ArchitectureVersion targetArchitectureVersion;

    @Before
    public void setUp() throws Exception {
        this.baseArchitectureVersion = AnnotationModelsTest.setupBasePCMModel("basemodel");
        ArchitectureVersionPersistency.save(this.baseArchitectureVersion.getName(), this.baseArchitectureVersion);
        this.targetArchitectureVersion = ArchitectureVersionPersistency.saveAsAndReload(this.baseArchitectureVersion, "targetmodel");
    }

    private static ArchitectureVersion setupBasePCMModel(String name) {
        ArchitectureVersion baseversion = ArchitectureModelFactoryFacade.createEmptyModel(name);
        BasicComponent client = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Client");
        BasicComponent server = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Server");
        BasicComponent database = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Database");
        OperationInterface clientInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ClientInterface");
        OperationInterface serverInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ServerInterface");
        OperationInterface databaseInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "DatabaseInterface");
        ArchitectureModelFactoryFacade.createProvidedRole(client, clientInterface);
        ArchitectureModelFactoryFacade.createRequiredRole(client, serverInterface);
        ArchitectureModelFactoryFacade.createProvidedRole(server, serverInterface);
        ArchitectureModelFactoryFacade.createRequiredRole(server, databaseInterface);
        ArchitectureModelFactoryFacade.createProvidedRole(database, databaseInterface);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)client, baseversion);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)server, baseversion);
        ArchitectureModelFactoryFacade.createAssemblyContext((RepositoryComponent)database, baseversion);
        return baseversion;
    }

    @After
    public void tearDown() {
        this.baseArchitectureVersion.delete();
        this.targetArchitectureVersion.delete();
        this.baseArchitectureVersion = null;
        this.targetArchitectureVersion = null;
    }

    @Test
    public void testInternalModificationMark_CreationAndLookUp() {
        BasicComponent client = (BasicComponent)ArchitectureModelLookup.lookUpComponentByName(this.baseArchitectureVersion, "Client");
        ArchitectureModelFactoryFacade.assignInternalModificationMarkToComponent(this.baseArchitectureVersion, (RepositoryComponent)client);
        InternalModificationMark internalModificationMark = ArchitectureModelLookup.lookUpInternalModificationMarkForComponent(this.baseArchitectureVersion, (RepositoryComponent)client);
        Assert.assertTrue((String)"InternalModificationMark not found", (internalModificationMark != null ? 1 : 0) != 0);
        Assert.assertTrue((String)"InternalModificationMark not assigned to expected component", (internalModificationMark.getComponent() == client ? 1 : 0) != 0);
        BasicComponent server = (BasicComponent)ArchitectureModelLookup.lookUpComponentByName(this.baseArchitectureVersion, "Server");
        InternalModificationMark internalModificationMarkServer = ArchitectureModelLookup.lookUpInternalModificationMarkForComponent(this.baseArchitectureVersion, (RepositoryComponent)server);
        Assert.assertTrue((String)"Lookup of missing internal modification mark not resulted in null", (internalModificationMarkServer == null ? 1 : 0) != 0);
    }
}

