/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.core;

import edu.kit.ipd.sdq.kamp.core.Activity;
import edu.kit.ipd.sdq.kamp.core.ActivityElementType;
import edu.kit.ipd.sdq.kamp.core.ActivityType;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.BasicActivity;
import java.util.ArrayList;
import java.util.List;

public class EnrichedWorkplanDerivation {
    public static List<Activity> deriveEnrichedWorkplan(ArchitectureVersion baseArchitectureVersion, ArchitectureVersion subVersion, List<Activity> baseActivityList) {
        EnrichedWorkplanDerivation.deriveCodingActivities(EnrichedWorkplanDerivation.calculateFlattenendActivityList(baseActivityList));
        EnrichedWorkplanDerivation.deriveBuildConfigurationActivities(EnrichedWorkplanDerivation.calculateFlattenendActivityList(baseActivityList));
        EnrichedWorkplanDerivation.deriveBuildExecutionActivities(EnrichedWorkplanDerivation.calculateFlattenendActivityList(baseActivityList));
        EnrichedWorkplanDerivation.deriveTestDevelopmentActivities(EnrichedWorkplanDerivation.calculateFlattenendActivityList(baseActivityList));
        EnrichedWorkplanDerivation.deriveTestExecutionActivities(EnrichedWorkplanDerivation.calculateFlattenendActivityList(baseActivityList));
        EnrichedWorkplanDerivation.deriveReleaseConfigurationActivities(EnrichedWorkplanDerivation.calculateFlattenendActivityList(baseActivityList));
        EnrichedWorkplanDerivation.deriveReleaseExecutionActivities(EnrichedWorkplanDerivation.calculateFlattenendActivityList(baseActivityList));
        EnrichedWorkplanDerivation.deriveDeploymentConfigurationActivities(EnrichedWorkplanDerivation.calculateFlattenendActivityList(baseActivityList));
        EnrichedWorkplanDerivation.deriveDeploymentExecutionActivities(EnrichedWorkplanDerivation.calculateFlattenendActivityList(baseActivityList));
        return baseActivityList;
    }

    public static List<Activity> calculateFlattenendActivityList(List<Activity> activityList) {
        ArrayList<Activity> flatActivityList = new ArrayList<Activity>();
        for (Activity activity : activityList) {
            flatActivityList.add(activity);
            if (!activity.getSubactivities().isEmpty()) {
                flatActivityList.addAll(activity.getSubactivities());
                flatActivityList.addAll(EnrichedWorkplanDerivation.calculateFlattenendActivityList(activity.getSubactivities()));
            }
            if (activity.getFollowupActivities().isEmpty()) continue;
            flatActivityList.addAll(activity.getFollowupActivities());
            flatActivityList.addAll(EnrichedWorkplanDerivation.calculateFlattenendActivityList(activity.getFollowupActivities()));
        }
        return flatActivityList;
    }

    private static void deriveCodingActivities(List<Activity> baseActivityList) {
        for (Activity activity : baseActivityList) {
            Activity newActivity;
            if (activity.getElementType() == ActivityElementType.COMPONENT && activity.getBasicActivity() == BasicActivity.ADD) {
                newActivity = new Activity(ActivityType.IMPLEMENTATION_SOURCECODE, ActivityElementType.SOURCECODE, "source code", BasicActivity.ADD, "add source code");
                activity.addFollowupactivity(newActivity);
                continue;
            }
            if (activity.getElementType() == ActivityElementType.COMPONENT && activity.getBasicActivity() == BasicActivity.REMOVE) {
                newActivity = new Activity(ActivityType.IMPLEMENTATION_SOURCECODE, ActivityElementType.SOURCECODE, "source code", BasicActivity.REMOVE, "remove source code");
                activity.addFollowupactivity(newActivity);
                continue;
            }
            if (activity.getElementType() != ActivityElementType.COMPONENT || activity.getBasicActivity() != BasicActivity.MODIFY) continue;
            newActivity = new Activity(ActivityType.IMPLEMENTATION_SOURCECODE, ActivityElementType.SOURCECODE, "source code", BasicActivity.MODIFY, "modify source code");
            activity.addFollowupactivity(newActivity);
        }
    }

    private static void deriveBuildConfigurationActivities(List<Activity> activityList) {
        for (Activity activity : activityList) {
            Activity newActivity;
            if (activity.getElementType() == ActivityElementType.SOURCECODE && activity.getBasicActivity() == BasicActivity.ADD) {
                newActivity = new Activity(ActivityType.BUILDCONFIGURATION, ActivityElementType.BUILDCONFIGURATION, "buildconfiguration", BasicActivity.MODIFY, "modify build configuration " + activity.getElementName());
                activity.addFollowupactivity(newActivity);
                continue;
            }
            if (activity.getElementType() == ActivityElementType.SOURCECODE && activity.getBasicActivity() == BasicActivity.MODIFY) {
                newActivity = new Activity(ActivityType.BUILDCONFIGURATION, ActivityElementType.BUILDCONFIGURATION, "buildconfiguration", BasicActivity.MODIFY, "modify build configuration " + activity.getElementName());
                activity.addFollowupactivity(newActivity);
                continue;
            }
            if (activity.getElementType() != ActivityElementType.SOURCECODE || activity.getBasicActivity() != BasicActivity.REMOVE) continue;
            newActivity = new Activity(ActivityType.BUILDCONFIGURATION, ActivityElementType.BUILDCONFIGURATION, "buildconfiguration", BasicActivity.MODIFY, "modify build configuration for " + activity.getElementName());
            activity.addFollowupactivity(newActivity);
        }
    }

    private static void deriveBuildExecutionActivities(List<Activity> activityList) {
        for (Activity activity : activityList) {
            Activity newActivity;
            if (activity.getElementType() == ActivityElementType.SOURCECODE && activity.getBasicActivity() == BasicActivity.ADD) {
                newActivity = new Activity(ActivityType.BUILDEXECUTION, ActivityElementType.BUILDCONFIGURATION, "buildconfiguration", BasicActivity.EXECUTE, "execute build");
                activity.addFollowupactivity(newActivity);
                continue;
            }
            if (activity.getElementType() != ActivityElementType.SOURCECODE || activity.getBasicActivity() != BasicActivity.MODIFY) continue;
            newActivity = new Activity(ActivityType.BUILDEXECUTION, ActivityElementType.BUILDCONFIGURATION, "buildconfiguration", BasicActivity.EXECUTE, "execute build");
            activity.addFollowupactivity(newActivity);
        }
    }

    private static void deriveTestDevelopmentActivities(List<Activity> baseActivityList) {
        for (Activity activity : baseActivityList) {
            Activity newActivity;
            if (activity.getElementType() == ActivityElementType.PROVIDEDROLE && activity.getBasicActivity() == BasicActivity.ADD) {
                newActivity = new Activity(ActivityType.TESTDEVELOPMENT, ActivityElementType.TESTCASE, "test case", BasicActivity.ADD, "add test case for added provided role");
                activity.addFollowupactivity(newActivity);
                continue;
            }
            if (activity.getElementType() == ActivityElementType.PROVIDEDROLE && activity.getBasicActivity() == BasicActivity.REMOVE) {
                newActivity = new Activity(ActivityType.TESTDEVELOPMENT, ActivityElementType.TESTCASE, "test case", BasicActivity.REMOVE, "remove test case for removed provided role");
                activity.addFollowupactivity(newActivity);
                continue;
            }
            if (activity.getElementType() != ActivityElementType.PROVIDEDROLE || activity.getBasicActivity() != BasicActivity.MODIFY) continue;
            newActivity = new Activity(ActivityType.TESTDEVELOPMENT, ActivityElementType.TESTCASE, "test case", BasicActivity.CHECKANDUPDATE, "check and update test cases for provided role");
            activity.addFollowupactivity(newActivity);
        }
    }

    private static void deriveTestExecutionActivities(List<Activity> baseActivityList) {
        for (Activity activity : baseActivityList) {
            Activity newActivity;
            if (activity.getElementType() == ActivityElementType.PROVIDEDROLE && activity.getBasicActivity() == BasicActivity.ADD) {
                newActivity = new Activity(ActivityType.TESTEXECUTION, ActivityElementType.TESTCASE, "test case", BasicActivity.EXECUTE, "execute test case(s)");
                activity.addFollowupactivity(newActivity);
                continue;
            }
            if (activity.getElementType() == ActivityElementType.PROVIDEDROLE && activity.getBasicActivity() == BasicActivity.REMOVE) {
                newActivity = new Activity(ActivityType.TESTEXECUTION, ActivityElementType.TESTCASE, "test case", BasicActivity.EXECUTE, "execute test case(s)");
                activity.addFollowupactivity(newActivity);
                continue;
            }
            if (activity.getElementType() != ActivityElementType.PROVIDEDROLE || activity.getBasicActivity() != BasicActivity.MODIFY) continue;
            newActivity = new Activity(ActivityType.TESTEXECUTION, ActivityElementType.TESTCASE, "test case", BasicActivity.EXECUTE, "execute test case(s)");
            activity.addFollowupactivity(newActivity);
        }
    }

    private static void deriveReleaseConfigurationActivities(List<Activity> baseActivityList) {
        for (Activity activity : baseActivityList) {
            if (activity.getElementType() != ActivityElementType.BUILDCONFIGURATION || activity.getBasicActivity() != BasicActivity.MODIFY) continue;
            Activity newActivity = new Activity(ActivityType.RELEASECONFIGURATION, ActivityElementType.RELEASECONFIGURATION, "release configuration", BasicActivity.MODIFY, "modify release configuration");
            activity.addFollowupactivity(newActivity);
        }
    }

    private static void deriveReleaseExecutionActivities(List<Activity> baseActivityList) {
        for (Activity activity : baseActivityList) {
            if (activity.getElementType() != ActivityElementType.BUILDCONFIGURATION || activity.getBasicActivity() != BasicActivity.EXECUTE) continue;
            Activity newActivity = new Activity(ActivityType.RELEASEEXECUTION, ActivityElementType.RELEASECONFIGURATION, "release configuration", BasicActivity.EXECUTE, "execute release configuration");
            activity.addFollowupactivity(newActivity);
        }
    }

    private static void deriveDeploymentConfigurationActivities(List<Activity> baseActivityList) {
        for (Activity activity : baseActivityList) {
            if (activity.getType() != ActivityType.RELEASEEXECUTION || activity.getBasicActivity() != BasicActivity.EXECUTE) continue;
            Activity newActivity = new Activity(ActivityType.DEPLOYMENTCONFIGURATION, ActivityElementType.DEPLOYMENTCONFIGURATION, "deployment configuration", BasicActivity.MODIFY, "modify deployment configuration");
            activity.addFollowupactivity(newActivity);
        }
    }

    private static void deriveDeploymentExecutionActivities(List<Activity> baseActivityList) {
        for (Activity activity : baseActivityList) {
            if (activity.getType() != ActivityType.RELEASEEXECUTION || activity.getBasicActivity() != BasicActivity.EXECUTE) continue;
            Activity newActivity = new Activity(ActivityType.DEPLOYMENTEXECUTION, ActivityElementType.DEPLOYMENTCONFIGURATION, "deployment configuration", BasicActivity.EXECUTE, "execute deployment");
            activity.addFollowupactivity(newActivity);
        }
    }
}

