/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.core;

import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMark;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.repository.ProvidedRole;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import de.uka.ipd.sdq.pcm.repository.RequiredRole;
import de.uka.ipd.sdq.pcm.repository.Signature;
import edu.kit.ipd.sdq.kamp.core.Activity;
import edu.kit.ipd.sdq.kamp.core.ActivityElementType;
import edu.kit.ipd.sdq.kamp.core.ActivityType;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.BasicActivity;
import edu.kit.ipd.sdq.kamp.core.SubactivityDerivation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DifferenceKind;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;

public class DifferenceCalculation {
    public static DiffModel calculateDiffModel(EObject source, EObject target) {
        MatchModel matchModel = null;
        try {
            matchModel = MatchService.doMatch((EObject)target, (EObject)source, null);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        DiffModel diff = null;
        if (matchModel != null) {
            diff = DiffService.doDiff((MatchModel)matchModel);
        }
        return diff;
    }

    public static boolean checkDiffElement(DiffElement diffElement, Class diffElementType, DifferenceKind kind) {
        return diffElementType.isInstance(diffElement) && diffElement.getKind() == kind;
    }

    public static boolean checkUpdateReference(UpdateReference diffElement, Class leftElementType, Class leftTargetType) {
        return leftElementType.isInstance(diffElement.getLeftElement()) && leftTargetType.isInstance(diffElement.getLeftTarget());
    }

    public static boolean checkModelElementChangeLeftTarget(ModelElementChangeLeftTarget diffElement, Class leftElementType) {
        return leftElementType.isInstance(diffElement.getLeftElement());
    }

    public static boolean checkModelElementChangeRightTarget(ModelElementChangeRightTarget diffElement, Class leftElementType) {
        return leftElementType.isInstance(diffElement.getRightElement());
    }

    public static boolean detectionRuleAddedBasicComponent(DiffElement diffElement) {
        return DifferenceCalculation.checkDiffElement(diffElement, ModelElementChangeLeftTarget.class, DifferenceKind.ADDITION) && DifferenceCalculation.checkModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement, BasicComponent.class);
    }

    public static boolean detectionRuleDeletedBasicComponent(DiffElement diffElement) {
        return DifferenceCalculation.checkDiffElement(diffElement, ModelElementChangeRightTarget.class, DifferenceKind.DELETION) && DifferenceCalculation.checkModelElementChangeRightTarget((ModelElementChangeRightTarget)diffElement, BasicComponent.class);
    }

    public static boolean detectionRuleAddedInterface(DiffElement diffElement) {
        return DifferenceCalculation.checkDiffElement(diffElement, ModelElementChangeLeftTarget.class, DifferenceKind.ADDITION) && DifferenceCalculation.checkModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement, OperationInterface.class);
    }

    public static boolean detectionRuleDeletedInterface(DiffElement diffElement) {
        return DifferenceCalculation.checkDiffElement(diffElement, ModelElementChangeRightTarget.class, DifferenceKind.DELETION) && DifferenceCalculation.checkModelElementChangeRightTarget((ModelElementChangeRightTarget)diffElement, OperationInterface.class);
    }

    public static boolean detectionRuleDeletedInterfaceForProvidedRole(DiffElement diffElement) {
        return DifferenceCalculation.checkDiffElement(diffElement, UpdateReference.class, DifferenceKind.CHANGE) && DifferenceCalculation.checkUpdateReference((UpdateReference)diffElement, ProvidedRole.class, OperationInterface.class);
    }

    public static boolean detectionRuleDeletedInterfaceForRequiredRole(DiffElement diffElement) {
        return DifferenceCalculation.checkDiffElement(diffElement, UpdateReference.class, DifferenceKind.CHANGE) && DifferenceCalculation.checkUpdateReference((UpdateReference)diffElement, RequiredRole.class, OperationInterface.class);
    }

    public static boolean detectionRuleAddedProvidedRole(DiffElement diffElement) {
        return DifferenceCalculation.checkDiffElement(diffElement, ModelElementChangeLeftTarget.class, DifferenceKind.ADDITION) && DifferenceCalculation.checkModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement, OperationProvidedRole.class);
    }

    public static boolean detectionRuleAddedRequiredRole(DiffElement diffElement) {
        return DifferenceCalculation.checkDiffElement(diffElement, ModelElementChangeLeftTarget.class, DifferenceKind.ADDITION) && DifferenceCalculation.checkModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement, OperationRequiredRole.class);
    }

    public static boolean detectionRuleDeletedProvidedRole(DiffElement diffElement) {
        return DifferenceCalculation.checkDiffElement(diffElement, ModelElementChangeRightTarget.class, DifferenceKind.DELETION) && DifferenceCalculation.checkModelElementChangeRightTarget((ModelElementChangeRightTarget)diffElement, OperationProvidedRole.class);
    }

    public static boolean detectionRuleDeletedRequiredRole(DiffElement diffElement) {
        return DifferenceCalculation.checkDiffElement(diffElement, ModelElementChangeRightTarget.class, DifferenceKind.DELETION) && DifferenceCalculation.checkModelElementChangeRightTarget((ModelElementChangeRightTarget)diffElement, OperationRequiredRole.class);
    }

    public static EObject retrieveArchitectureElement(DiffElement diffElement) {
        if (diffElement instanceof ModelElementChangeRightTarget) {
            return ((ModelElementChangeRightTarget)diffElement).getRightElement();
        }
        if (diffElement instanceof ModelElementChangeLeftTarget) {
            return ((ModelElementChangeLeftTarget)diffElement).getLeftElement();
        }
        if (diffElement instanceof UpdateReference) {
            return ((UpdateReference)diffElement).getLeftElement();
        }
        return null;
    }

    public static List<DiffElement> foundAddedBasicComponent(DiffModel diff) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diff.getDifferences()) {
            if (!DifferenceCalculation.detectionRuleAddedBasicComponent(diffElement)) continue;
            result.add(diffElement);
        }
        return result;
    }

    public static List<DiffElement> foundAddedInterface(DiffModel diff) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diff.getDifferences()) {
            if (!DifferenceCalculation.detectionRuleAddedInterface(diffElement)) continue;
            result.add(diffElement);
        }
        return result;
    }

    public static List<DiffElement> foundDeletedBasicComponent(DiffModel diff) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diff.getDifferences()) {
            if (!DifferenceCalculation.detectionRuleDeletedBasicComponent(diffElement)) continue;
            result.add(diffElement);
        }
        return result;
    }

    public static List<DiffElement> foundDeletedInterface(DiffModel diff) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diff.getDifferences()) {
            if (!DifferenceCalculation.detectionRuleDeletedInterface(diffElement)) continue;
            result.add(diffElement);
        }
        return result;
    }

    public static List<DiffElement> foundDeletedInterfaceForProvidedRole(DiffModel diff) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diff.getDifferences()) {
            if (!DifferenceCalculation.detectionRuleDeletedInterfaceForProvidedRole(diffElement)) continue;
            result.add(diffElement);
        }
        return result;
    }

    public static List<DiffElement> foundDeletedInterfaceForRequiredRole(DiffModel diff) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diff.getDifferences()) {
            if (!DifferenceCalculation.detectionRuleDeletedInterfaceForRequiredRole(diffElement)) continue;
            result.add(diffElement);
        }
        return result;
    }

    public static List<DiffElement> foundAddedProvidedRole(DiffModel diff) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diff.getDifferences()) {
            if (!DifferenceCalculation.detectionRuleAddedProvidedRole(diffElement)) continue;
            result.add(diffElement);
        }
        return result;
    }

    public static List<DiffElement> foundAddedRequiredRole(DiffModel diff) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diff.getDifferences()) {
            if (!DifferenceCalculation.detectionRuleAddedRequiredRole(diffElement)) continue;
            result.add(diffElement);
        }
        return result;
    }

    public static List<DiffElement> foundDeletedProvidedRole(DiffModel diff) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diff.getDifferences()) {
            if (!DifferenceCalculation.detectionRuleDeletedProvidedRole(diffElement)) continue;
            result.add(diffElement);
        }
        return result;
    }

    public static List<DiffElement> foundDeletedRequiredRole(DiffModel diff) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diff.getDifferences()) {
            if (!DifferenceCalculation.detectionRuleDeletedRequiredRole(diffElement)) continue;
            result.add(diffElement);
        }
        return result;
    }

    public static List<Activity> deriveBaseWorkPlan(DiffModel diff) {
        ArrayList<Activity> workplan = new ArrayList<Activity>();
        for (DiffElement diffElement : diff.getDifferences()) {
            Activity newActivity;
            OperationInterface architectureElement;
            if (DifferenceCalculation.detectionRuleAddedInterface(diffElement)) {
                architectureElement = (OperationInterface)DifferenceCalculation.retrieveArchitectureElement(diffElement);
                newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.INTERFACE, architectureElement.getEntityName(), BasicActivity.ADD, "add interface");
                workplan.add(newActivity);
                newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities(architectureElement, BasicActivity.ADD));
                continue;
            }
            if (DifferenceCalculation.detectionRuleDeletedInterface(diffElement)) {
                architectureElement = (OperationInterface)DifferenceCalculation.retrieveArchitectureElement(diffElement);
                newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.INTERFACE, architectureElement.getEntityName(), BasicActivity.REMOVE, "remove interface");
                workplan.add(newActivity);
                newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities(architectureElement, BasicActivity.REMOVE));
                continue;
            }
            if (DifferenceCalculation.detectionRuleAddedBasicComponent(diffElement)) {
                architectureElement = (BasicComponent)DifferenceCalculation.retrieveArchitectureElement(diffElement);
                newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.COMPONENT, architectureElement.getEntityName(), BasicActivity.ADD, "add component");
                workplan.add(newActivity);
                newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities((BasicComponent)architectureElement, BasicActivity.ADD));
                continue;
            }
            if (DifferenceCalculation.detectionRuleDeletedBasicComponent(diffElement)) {
                architectureElement = (BasicComponent)DifferenceCalculation.retrieveArchitectureElement(diffElement);
                newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.COMPONENT, architectureElement.getEntityName(), BasicActivity.REMOVE, "remove component");
                workplan.add(newActivity);
                newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities((BasicComponent)architectureElement, BasicActivity.REMOVE));
                continue;
            }
            if (DifferenceCalculation.detectionRuleAddedProvidedRole(diffElement)) {
                architectureElement = (OperationProvidedRole)DifferenceCalculation.retrieveArchitectureElement(diffElement);
                newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.PROVIDEDROLE, architectureElement.getEntityName(), BasicActivity.ADD, "add provided role");
                workplan.add(newActivity);
                newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities((OperationProvidedRole)architectureElement, BasicActivity.ADD));
                continue;
            }
            if (DifferenceCalculation.detectionRuleDeletedProvidedRole(diffElement)) {
                architectureElement = (OperationProvidedRole)DifferenceCalculation.retrieveArchitectureElement(diffElement);
                newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.PROVIDEDROLE, architectureElement.getEntityName(), BasicActivity.REMOVE, "remove provided role");
                workplan.add(newActivity);
                newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities((OperationProvidedRole)architectureElement, BasicActivity.REMOVE));
                continue;
            }
            if (DifferenceCalculation.detectionRuleAddedRequiredRole(diffElement)) {
                architectureElement = (OperationRequiredRole)DifferenceCalculation.retrieveArchitectureElement(diffElement);
                newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.REQUIREDROLE, architectureElement.getEntityName(), BasicActivity.ADD, "add required role");
                workplan.add(newActivity);
                newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities((OperationRequiredRole)architectureElement, BasicActivity.REMOVE));
                continue;
            }
            if (!DifferenceCalculation.detectionRuleDeletedRequiredRole(diffElement)) continue;
            architectureElement = (OperationRequiredRole)DifferenceCalculation.retrieveArchitectureElement(diffElement);
            newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.REQUIREDROLE, architectureElement.getEntityName(), BasicActivity.REMOVE, "remove required role");
            workplan.add(newActivity);
            newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities((OperationRequiredRole)architectureElement, BasicActivity.REMOVE));
        }
        return workplan;
    }

    public static List<DiffElement> foundAddedAssemblyConnector(DiffModel diff) {
        ArrayList<DiffElement> result = new ArrayList<DiffElement>();
        for (DiffElement diffElement : diff.getDifferences()) {
            if (!DifferenceCalculation.detectionRuleAddedAssemblyConnector(diffElement)) continue;
            result.add(diffElement);
        }
        return result;
    }

    public static boolean detectionRuleAddedAssemblyConnector(DiffElement diffElement) {
        return DifferenceCalculation.checkDiffElement(diffElement, ModelElementChangeLeftTarget.class, DifferenceKind.ADDITION) && DifferenceCalculation.checkModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement, AssemblyConnector.class);
    }

    public static List<Activity> deriveWorkplan(ArchitectureVersion baseVersion, ArchitectureVersion targetVersion) {
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        DiffModel repositoryDiff = DifferenceCalculation.calculateDiffModel((EObject)baseVersion.getRepository(), (EObject)targetVersion.getRepository());
        DiffModel systemDiff = DifferenceCalculation.calculateDiffModel((EObject)baseVersion.getSystem(), (EObject)targetVersion.getSystem());
        List<Activity> repositoryActivities = DifferenceCalculation.deriveBaseWorkPlan(repositoryDiff);
        activityList.addAll(repositoryActivities);
        List<Activity> systemActivities = DifferenceCalculation.deriveBaseWorkPlan(systemDiff);
        activityList.addAll(systemActivities);
        List<Activity> internalModificationActivities = DifferenceCalculation.deriveInternalModifications(targetVersion);
        activityList.addAll(internalModificationActivities);
        return activityList;
    }

    private static List<Activity> deriveInternalModifications(ArchitectureVersion targetVersion) {
        ArrayList<Activity> activityList = new ArrayList<Activity>();
        for (InternalModificationMark internalModificationMark : targetVersion.getInternalModificationMarkRepository().getInternalModificationMark()) {
            RepositoryComponent component = internalModificationMark.getComponent();
            EList providedRoles = internalModificationMark.getProvidedRole();
            EList signatures = internalModificationMark.getSignature();
            DifferenceCalculation.fixInternalModificationMark(internalModificationMark);
            if (component == null) continue;
            Activity componentActivity = new Activity(ActivityType.INTERNALMODIFICATIONMARK, ActivityElementType.COMPONENT, component.getEntityName(), BasicActivity.MODIFY, "modify component (internally)");
            activityList.add(componentActivity);
            for (ProvidedRole providedRole : providedRoles) {
                Activity providedRoleActivity = new Activity(ActivityType.INTERNALMODIFICATIONMARK, ActivityElementType.PROVIDEDROLE, providedRole.getEntityName(), BasicActivity.MODIFY, "modify provided role (internally)");
                componentActivity.addSubactivity(providedRoleActivity);
                for (Signature signature : signatures) {
                    Activity providedOperationActivity = new Activity(ActivityType.INTERNALMODIFICATIONMARK, ActivityElementType.PROVIDEDOPERATION, signature.getEntityName(), BasicActivity.MODIFY, "modify provided operation (internally)");
                    providedRoleActivity.addSubactivity(providedOperationActivity);
                }
            }
        }
        return activityList;
    }

    private static void fixInternalModificationMark(InternalModificationMark internalModificationMark) {
        if (internalModificationMark.getComponent() == null && internalModificationMark.getProvidedRole() != null && !internalModificationMark.getProvidedRole().isEmpty()) {
            internalModificationMark.setComponent((RepositoryComponent)((ProvidedRole)internalModificationMark.getProvidedRole().get(0)).getProvidingEntity_ProvidedRole());
        }
    }
}

