/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.core;

import de.uka.ipd.sdq.componentInternalDependencies.ComponentInternalDependencyRepository;
import de.uka.ipd.sdq.fieldOfActivityAnnotations.FieldOfActivityAnnotationsRepository;
import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMarkRepository;
import de.uka.ipd.sdq.pcm.repository.Repository;
import de.uka.ipd.sdq.pcm.system.System;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class ArchitectureVersionPersistency {
    public static void save(String nameprefix, ArchitectureVersion version) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        String repositoryfilePath = String.valueOf(nameprefix) + ".repository";
        if (version.getRepository() != null) {
            ArchitectureVersionPersistency.saveEmfModelToResource((EObject)version.getRepository(), repositoryfilePath, (ResourceSet)resourceSet);
        }
        String systemfilePath = String.valueOf(nameprefix) + ".system";
        if (version.getSystem() != null) {
            ArchitectureVersionPersistency.saveEmfModelToResource((EObject)version.getSystem(), systemfilePath, (ResourceSet)resourceSet);
        }
        String fieldOfActivityRepositoryFilePath = String.valueOf(nameprefix) + ".fieldofactivityannotations";
        if (version.getFieldOfActivityRepository() != null) {
            ArchitectureVersionPersistency.saveEmfModelToResource((EObject)version.getFieldOfActivityRepository(), fieldOfActivityRepositoryFilePath, (ResourceSet)resourceSet);
        }
        String internalModFilePath = String.valueOf(nameprefix) + ".internalmodificationmarks";
        if (version.getInternalModificationMarkRepository() != null) {
            ArchitectureVersionPersistency.saveEmfModelToResource((EObject)version.getInternalModificationMarkRepository(), internalModFilePath, (ResourceSet)resourceSet);
        }
        String cidepfilePath = String.valueOf(nameprefix) + ".componentinternaldependencies";
        if (version.getComponentInternalDependencyRepository() != null) {
            ArchitectureVersionPersistency.saveEmfModelToResource((EObject)version.getComponentInternalDependencyRepository(), cidepfilePath, (ResourceSet)resourceSet);
        }
    }

    public static ArchitectureVersion load(String loadprefix, String versionname) throws IOException {
        ResourceSetImpl loadResourceSet = new ResourceSetImpl();
        String repositoryfilePath = String.valueOf(loadprefix) + ".repository";
        String systemfilePath = String.valueOf(loadprefix) + ".system";
        String fieldOfActivityRepositoryFilePath = String.valueOf(loadprefix) + ".fieldofactivityannotations";
        String internalModFilePath = String.valueOf(loadprefix) + ".internalmodificationmarks";
        String cidepfilePath = String.valueOf(loadprefix) + ".componentinternaldependencies";
        Repository repository = (Repository)ArchitectureVersionPersistency.loadEmfModelFromResource(repositoryfilePath, (ResourceSet)loadResourceSet);
        System system = (System)ArchitectureVersionPersistency.loadEmfModelFromResource(systemfilePath, (ResourceSet)loadResourceSet);
        FieldOfActivityAnnotationsRepository fieldOfActivityRepository = (FieldOfActivityAnnotationsRepository)ArchitectureVersionPersistency.loadEmfModelFromResource(fieldOfActivityRepositoryFilePath, (ResourceSet)loadResourceSet);
        InternalModificationMarkRepository internalModificationMarkRepository = (InternalModificationMarkRepository)ArchitectureVersionPersistency.loadEmfModelFromResource(internalModFilePath, (ResourceSet)loadResourceSet);
        ComponentInternalDependencyRepository componentInternalDependencyRepository = (ComponentInternalDependencyRepository)ArchitectureVersionPersistency.loadEmfModelFromResource(cidepfilePath, (ResourceSet)loadResourceSet);
        return new ArchitectureVersion(versionname, repository, system, fieldOfActivityRepository, internalModificationMarkRepository, componentInternalDependencyRepository);
    }

    private static void saveEmfModelToResource(EObject model, String filePath, ResourceSet resourceSet) {
        if (filePath != null) {
            URI saveURI = URI.createFileURI((String)filePath);
            Resource resource = resourceSet.createResource(saveURI);
            resource.getContents().add((Object)model);
            try {
                resource.save(Collections.EMPTY_MAP);
            }
            catch (IOException e) {
                throw new RuntimeException("Saving of resource failed", e);
            }
        }
    }

    private static EObject loadEmfModelFromResource(String filePath, ResourceSet resourceSet) {
        if (filePath != null) {
            URI loadURI = URI.createFileURI((String)filePath);
            try {
                return ModelUtils.load((URI)loadURI, (ResourceSet)resourceSet);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static ArchitectureVersion saveAsAndReload(ArchitectureVersion saveVersion, String targetname) {
        try {
            ArchitectureVersionPersistency.save(targetname, saveVersion);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ArchitectureVersion loadVersion = null;
        try {
            loadVersion = ArchitectureVersionPersistency.load(targetname, targetname);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return loadVersion;
    }

    public static ArchitectureVersion createArchitectureVersionClone(ArchitectureVersion baseversion, String targetname) {
        ArchitectureVersion targetversion = ArchitectureVersionPersistency.saveAsAndReload(baseversion, targetname);
        return targetversion;
    }
}

