/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.core;

import de.uka.ipd.sdq.componentInternalDependencies.RoleToRoleDependency;
import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMark;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyContext;
import de.uka.ipd.sdq.pcm.core.composition.Connector;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.CompositeComponent;
import de.uka.ipd.sdq.pcm.repository.Interface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.repository.ProvidedRole;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import de.uka.ipd.sdq.pcm.repository.RequiredRole;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.ProvidingRequiredRolePair;
import java.util.ArrayList;
import java.util.List;

public class ArchitectureModelLookup {
    public static List<AssemblyContext> lookUpAssemblyContextsForRepositoryComponents(ArchitectureVersion version, RepositoryComponent component) {
        ArrayList<AssemblyContext> assemblyContexts = new ArrayList<AssemblyContext>();
        for (AssemblyContext assemblyContext : version.getSystem().getAssemblyContexts__ComposedStructure()) {
            if (assemblyContext.getEncapsulatedComponent__AssemblyContext() != component) continue;
            assemblyContexts.add(assemblyContext);
        }
        assemblyContexts.addAll(ArchitectureModelLookup.lookUpAssemblyContextsInCompositeComponents(version, component));
        return assemblyContexts;
    }

    public static List<AssemblyConnector> lookUpAssemblyConnectorsBetweenAssemblyContexts(AssemblyContext providingAssemblyContext, AssemblyContext requiringAssemblyContext) {
        ArrayList<AssemblyConnector> assemblyConnectors = new ArrayList<AssemblyConnector>();
        for (Connector connector : providingAssemblyContext.getParentStructure__AssemblyContext().getConnectors__ComposedStructure()) {
            AssemblyConnector assemblyConnector;
            if (!(connector instanceof AssemblyConnector) || (assemblyConnector = (AssemblyConnector)connector).getProvidingAssemblyContext_AssemblyConnector() != providingAssemblyContext || assemblyConnector.getRequiringAssemblyContext_AssemblyConnector() != requiringAssemblyContext) continue;
            assemblyConnectors.add(assemblyConnector);
        }
        return assemblyConnectors;
    }

    private static List<AssemblyContext> lookUpAssemblyContextsInCompositeComponents(ArchitectureVersion version, RepositoryComponent component) {
        ArrayList<AssemblyContext> assemblyContexts = new ArrayList<AssemblyContext>();
        for (RepositoryComponent repcomponent : version.getRepository().getComponents__Repository()) {
            if (!(repcomponent instanceof CompositeComponent)) continue;
            for (AssemblyContext assemblyContext : ((CompositeComponent)repcomponent).getAssemblyContexts__ComposedStructure()) {
                if (assemblyContext.getEncapsulatedComponent__AssemblyContext() != component) continue;
                assemblyContexts.add(assemblyContext);
            }
        }
        return assemblyContexts;
    }

    public static List<ProvidingRequiredRolePair> lookUpMatchingRolePairs(RepositoryComponent providingComponent, RepositoryComponent requiringComponent) {
        ArrayList<ProvidingRequiredRolePair> pairs = new ArrayList<ProvidingRequiredRolePair>();
        for (ProvidedRole providedRole : providingComponent.getProvidedRoles_InterfaceProvidingEntity()) {
            for (RequiredRole requiredRole : requiringComponent.getRequiredRoles_InterfaceRequiringEntity()) {
                if (!(providedRole instanceof OperationProvidedRole) || !(requiredRole instanceof OperationRequiredRole) || ((OperationProvidedRole)providedRole).getProvidedInterface__OperationProvidedRole() != ((OperationRequiredRole)requiredRole).getRequiredInterface__OperationRequiredRole()) continue;
                pairs.add(new ProvidingRequiredRolePair(providedRole, requiredRole));
            }
        }
        return pairs;
    }

    public static RepositoryComponent lookUpComponentByName(ArchitectureVersion version, String name) {
        for (RepositoryComponent repcomponent : version.getRepository().getComponents__Repository()) {
            if (!repcomponent.getEntityName().equals(name)) continue;
            return repcomponent;
        }
        return null;
    }

    public static Interface lookUpInterfaceByName(ArchitectureVersion version, String name) {
        for (Interface interf : version.getRepository().getInterfaces__Repository()) {
            if (!interf.getEntityName().equals(name)) continue;
            return interf;
        }
        return null;
    }

    public static InternalModificationMark lookUpInternalModificationMarkForComponent(ArchitectureVersion version, RepositoryComponent component) {
        for (InternalModificationMark mark : version.getInternalModificationMarkRepository().getInternalModificationMark()) {
            if (mark.getComponent() != component) continue;
            return mark;
        }
        return null;
    }

    public static RoleToRoleDependency lookUpComponentInternalDependency(ArchitectureVersion version, BasicComponent component) {
        for (RoleToRoleDependency dep : version.getComponentInternalDependencyRepository().getDependencies()) {
            if (dep.getProvidedRole().getProvidingEntity_ProvidedRole() != component) continue;
            return dep;
        }
        return null;
    }

    public static List<ProvidedRole> lookUpDependentProvidedRolesForRequiredRole(ArchitectureVersion version, RequiredRole requiredRole) {
        ArrayList<ProvidedRole> providedRoles = new ArrayList<ProvidedRole>();
        for (RoleToRoleDependency dep : version.getComponentInternalDependencyRepository().getDependencies()) {
            if (dep.getRequiredRole() != requiredRole) continue;
            providedRoles.add(dep.getProvidedRole());
        }
        return providedRoles;
    }
}

