/*
 * Decompiled with CFR 0.152.
 */
package edu.kit.ipd.sdq.kamp.core;

import de.uka.ipd.sdq.componentInternalDependencies.ComponentInternalDependenciesFactory;
import de.uka.ipd.sdq.componentInternalDependencies.ComponentInternalDependencyRepository;
import de.uka.ipd.sdq.componentInternalDependencies.RoleToRoleDependency;
import de.uka.ipd.sdq.fieldOfActivityAnnotations.FieldOfActivityAnnotationsFactory;
import de.uka.ipd.sdq.fieldOfActivityAnnotations.FieldOfActivityAnnotationsRepository;
import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMark;
import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMarkRepository;
import de.uka.ipd.sdq.internalmodificationmark.InternalmodificationmarkFactory;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyContext;
import de.uka.ipd.sdq.pcm.core.composition.CompositionFactory;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.repository.ProvidedRole;
import de.uka.ipd.sdq.pcm.repository.Repository;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import de.uka.ipd.sdq.pcm.repository.RepositoryFactory;
import de.uka.ipd.sdq.pcm.repository.RequiredRole;
import de.uka.ipd.sdq.pcm.system.System;
import de.uka.ipd.sdq.pcm.system.SystemFactory;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersionPersistency;
import edu.kit.ipd.sdq.kamp.core.ProvidingRequiredRolePair;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ArchitectureModelFactoryFacade {
    public static ArchitectureVersion createEmptyModel(String name) {
        Repository repository = ArchitectureModelFactoryFacade.createRepository(name);
        System system = ArchitectureModelFactoryFacade.createSystem();
        FieldOfActivityAnnotationsRepository fieldOfActivityRepository = ArchitectureModelFactoryFacade.createFieldOfActivityAnnotationsRepository();
        InternalModificationMarkRepository internalModificationMarkRepository = ArchitectureModelFactoryFacade.createInternalModificationMarkRepository();
        ComponentInternalDependencyRepository componentInternalDependencyRepository = ArchitectureModelFactoryFacade.createComponentInternalDependencyRepository();
        return new ArchitectureVersion(name, repository, system, fieldOfActivityRepository, internalModificationMarkRepository, componentInternalDependencyRepository);
    }

    public static Repository createRepository(String name) {
        Repository repository = RepositoryFactory.eINSTANCE.createRepository();
        repository.setEntityName(name);
        return repository;
    }

    public static BasicComponent createBasicComponent(ArchitectureVersion version, String name) {
        BasicComponent component = RepositoryFactory.eINSTANCE.createBasicComponent();
        component.setEntityName(name);
        version.getRepository().getComponents__Repository().add((Object)component);
        return component;
    }

    public static OperationInterface createInterface(ArchitectureVersion version, String name) {
        OperationInterface interf = RepositoryFactory.eINSTANCE.createOperationInterface();
        interf.setEntityName(name);
        version.getRepository().getInterfaces__Repository().add((Object)interf);
        return interf;
    }

    public static void createProvidedRole(BasicComponent component, OperationInterface interf) {
        OperationProvidedRole providedRole = RepositoryFactory.eINSTANCE.createOperationProvidedRole();
        providedRole.setProvidedInterface__OperationProvidedRole(interf);
        providedRole.setEntityName(interf.getEntityName());
        component.getProvidedRoles_InterfaceProvidingEntity().add((Object)providedRole);
    }

    public static void createRequiredRole(BasicComponent component, OperationInterface interf) {
        OperationRequiredRole requiredRole = RepositoryFactory.eINSTANCE.createOperationRequiredRole();
        requiredRole.setRequiredInterface__OperationRequiredRole(interf);
        requiredRole.setEntityName(interf.getEntityName());
        component.getRequiredRoles_InterfaceRequiringEntity().add((Object)requiredRole);
    }

    public static System createSystem() {
        return SystemFactory.eINSTANCE.createSystem();
    }

    public static ComponentInternalDependencyRepository createComponentInternalDependencyRepository() {
        return ComponentInternalDependenciesFactory.eINSTANCE.createComponentInternalDependencyRepository();
    }

    public static FieldOfActivityAnnotationsRepository createFieldOfActivityAnnotationsRepository() {
        return FieldOfActivityAnnotationsFactory.eINSTANCE.createFieldOfActivityAnnotationsRepository();
    }

    public static InternalModificationMarkRepository createInternalModificationMarkRepository() {
        return InternalmodificationmarkFactory.eINSTANCE.createInternalModificationMarkRepository();
    }

    public static void createAssemblyContext(RepositoryComponent component, ArchitectureVersion version) {
        AssemblyContext assemblyContext = CompositionFactory.eINSTANCE.createAssemblyContext();
        assemblyContext.setEntityName(component.getEntityName());
        assemblyContext.setEncapsulatedComponent__AssemblyContext(component);
        version.getSystem().getAssemblyContexts__ComposedStructure().add((Object)assemblyContext);
    }

    public static void createAssemblyConnector(RepositoryComponent providingComponent, RepositoryComponent requiringComponent, ArchitectureVersion version) {
        AssemblyConnector assemblyConnector = CompositionFactory.eINSTANCE.createAssemblyConnector();
        assemblyConnector.setEntityName(String.valueOf(requiringComponent.getEntityName()) + " -> " + providingComponent.getEntityName());
        AssemblyContext providingContext = ArchitectureModelLookup.lookUpAssemblyContextsForRepositoryComponents(version, providingComponent).get(0);
        AssemblyContext requiringContext = ArchitectureModelLookup.lookUpAssemblyContextsForRepositoryComponents(version, requiringComponent).get(0);
        assemblyConnector.setProvidingAssemblyContext_AssemblyConnector(providingContext);
        assemblyConnector.setRequiringAssemblyContext_AssemblyConnector(requiringContext);
        List<ProvidingRequiredRolePair> matchingRolePairs = ArchitectureModelLookup.lookUpMatchingRolePairs(providingComponent, requiringComponent);
        if (!matchingRolePairs.isEmpty()) {
            OperationProvidedRole providedRole = (OperationProvidedRole)matchingRolePairs.get(0).getProvidedRole();
            OperationRequiredRole requiredRole = (OperationRequiredRole)matchingRolePairs.get(0).getRequiredRole();
            assemblyConnector.setProvidedRole_AssemblyConnector(providedRole);
            assemblyConnector.setRequiredRole_AssemblyConnector(requiredRole);
        }
        providingContext.getParentStructure__AssemblyContext().getConnectors__ComposedStructure().add((Object)assemblyConnector);
    }

    public static void assignInternalModificationMarkToComponent(ArchitectureVersion version, RepositoryComponent component) {
        if (ArchitectureModelLookup.lookUpInternalModificationMarkForComponent(version, component) == null) {
            InternalModificationMark internalModificationMark = InternalmodificationmarkFactory.eINSTANCE.createInternalModificationMark();
            internalModificationMark.setComponent(component);
            version.getInternalModificationMarkRepository().getInternalModificationMark().add((Object)internalModificationMark);
        }
    }

    public static void createComponentInternalDependency(ArchitectureVersion version, ProvidedRole providedRole, RequiredRole requiredRole) {
        RoleToRoleDependency dependency = ComponentInternalDependenciesFactory.eINSTANCE.createRoleToRoleDependency();
        dependency.setProvidedRole(providedRole);
        dependency.setRequiredRole(requiredRole);
        version.getComponentInternalDependencyRepository().getDependencies().add((Object)dependency);
    }

    public static ArchitectureVersion createArchitectureVersionClone(ArchitectureVersion baseversion, String targetname) {
        ArchitectureVersion targetversion = ArchitectureVersionPersistency.saveAsAndReload(baseversion, targetname);
        return targetversion;
    }

    public static void deleteAssemblyConnector(AssemblyConnector assemblyConnector) {
        EcoreUtil.delete((EObject)assemblyConnector);
    }

    public static void deleteComponentConnector(BasicComponent basicComponent) {
        EcoreUtil.delete((EObject)basicComponent);
    }

    public static void setupComponentInternalDependenciesPessimistic(ArchitectureVersion version) {
        for (RepositoryComponent component : version.getRepository().getComponents__Repository()) {
            for (ProvidedRole providedRole : component.getProvidedRoles_InterfaceProvidingEntity()) {
                for (RequiredRole requiredRole : component.getRequiredRoles_InterfaceRequiringEntity()) {
                    ArchitectureModelFactoryFacade.createComponentInternalDependency(version, providedRole, requiredRole);
                }
            }
        }
    }
}

