package edu.kit.ipd.sdq.kamp.test;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.uka.ipd.sdq.componentInternalDependencies.RoleToRoleDependency;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.ProvidedRole;
import de.uka.ipd.sdq.pcm.repository.RequiredRole;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelFactoryFacade;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersionPersistency;

public class ChangePropagationDetectionTest {

	ArchitectureVersion baseArchitectureVersion;
	ArchitectureVersion targetArchitectureVersion;
	
	@Before
	public void setUp() throws Exception {
		baseArchitectureVersion = setupBasePCMModel("basemodel");
		ArchitectureVersionPersistency.save(baseArchitectureVersion.getName(), baseArchitectureVersion);
		targetArchitectureVersion = ArchitectureVersionPersistency.saveAsAndReload(baseArchitectureVersion, "targetmodel");
	}
	
	private static ArchitectureVersion setupBasePCMModel(String name) {
		ArchitectureVersion baseversion = ArchitectureModelFactoryFacade.createEmptyModel(name);

		BasicComponent client = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Client");
		BasicComponent server = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Server");
		BasicComponent database = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Database");
		
		OperationInterface clientInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ClientInterface");
		OperationInterface serverInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ServerInterface");
		OperationInterface databaseInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "DatabaseInterface");
		
		ArchitectureModelFactoryFacade.createProvidedRole(client, clientInterface);
		ArchitectureModelFactoryFacade.createRequiredRole(client, serverInterface);

		ArchitectureModelFactoryFacade.createProvidedRole(server, serverInterface);
		ArchitectureModelFactoryFacade.createRequiredRole(server, databaseInterface);

		ArchitectureModelFactoryFacade.createProvidedRole(database, databaseInterface);

		ArchitectureModelFactoryFacade.createAssemblyContext(client, baseversion);
		ArchitectureModelFactoryFacade.createAssemblyContext(server, baseversion);
		ArchitectureModelFactoryFacade.createAssemblyContext(database, baseversion);
		
		//ArchitectureModelFactoryFacade.createAssemblyConnector(server, client, baseversion);
		
		return baseversion;
	}
	
	@After
	public void tearDown() {
		baseArchitectureVersion.delete();
		targetArchitectureVersion.delete();
		baseArchitectureVersion = null;
		targetArchitectureVersion = null;
	}
	
	@Test 
	public void testComponentInternalDependencies_Creation() {
		BasicComponent client = (BasicComponent)ArchitectureModelLookup.lookUpComponentByName(baseArchitectureVersion, "Client");
	
		ProvidedRole providedRole = client.getProvidedRoles_InterfaceProvidingEntity().get(0);

		RequiredRole requiredRole = client.getRequiredRoles_InterfaceRequiringEntity().get(0);

		ArchitectureModelFactoryFacade.createComponentInternalDependency(baseArchitectureVersion, providedRole, requiredRole);
		
		RoleToRoleDependency dependency = ArchitectureModelLookup.lookUpComponentInternalDependency(baseArchitectureVersion, client);
		
		assertTrue("Created Component Internal Dependency not found.", dependency!=null);	
	}
	
	@Test 
	public void testComponentInternalDependencies_LookUpDependentProvidedRolesForRequiredRole() {
		BasicComponent client = (BasicComponent)ArchitectureModelLookup.lookUpComponentByName(baseArchitectureVersion, "Client");
	
		OperationInterface secondInterf = ArchitectureModelFactoryFacade.createInterface(baseArchitectureVersion, "SecondInterface");
		OperationInterface thirdInterf = ArchitectureModelFactoryFacade.createInterface(baseArchitectureVersion, "ThirdInterface");
		
		ArchitectureModelFactoryFacade.createProvidedRole(client, secondInterf);
		ArchitectureModelFactoryFacade.createProvidedRole(client, thirdInterf);
		
		ProvidedRole firstProvidedRole = client.getProvidedRoles_InterfaceProvidingEntity().get(0);
		// secondProvidedRole is omitted on purpose
		ProvidedRole thirdProvidedRole = client.getProvidedRoles_InterfaceProvidingEntity().get(2);
		RequiredRole requiredRole = client.getRequiredRoles_InterfaceRequiringEntity().get(0);

		ArchitectureModelFactoryFacade.createComponentInternalDependency(baseArchitectureVersion, firstProvidedRole, requiredRole);
		ArchitectureModelFactoryFacade.createComponentInternalDependency(baseArchitectureVersion, thirdProvidedRole, requiredRole);
		
		List<ProvidedRole> dependentProvidedRoles = ArchitectureModelLookup.lookUpDependentProvidedRolesForRequiredRole(baseArchitectureVersion, requiredRole);
		
		assertTrue("Dependent ProvidedRoles not detected properly.", 
				dependentProvidedRoles.size()==2 && 
				dependentProvidedRoles.contains(firstProvidedRole) && 
				dependentProvidedRoles.contains(thirdProvidedRole));	
	}

}
