package edu.kit.ipd.sdq.kamp.test;

import static org.junit.Assert.*;

import java.util.List;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

import de.uka.ipd.sdq.componentInternalDependencies.RoleToRoleDependency;
import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMark;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.ProvidedRole;
import de.uka.ipd.sdq.pcm.repository.RequiredRole;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelFactoryFacade;
import edu.kit.ipd.sdq.kamp.core.ArchitectureModelLookup;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersion;
import edu.kit.ipd.sdq.kamp.core.ArchitectureVersionPersistency;

public class AnnotationModelsTest {

	ArchitectureVersion baseArchitectureVersion;
	ArchitectureVersion targetArchitectureVersion;
	
	@Before
	public void setUp() throws Exception {
		baseArchitectureVersion = setupBasePCMModel("basemodel");
		ArchitectureVersionPersistency.save(baseArchitectureVersion.getName(), baseArchitectureVersion);
		targetArchitectureVersion = ArchitectureVersionPersistency.saveAsAndReload(baseArchitectureVersion, "targetmodel");
	}
	
	private static ArchitectureVersion setupBasePCMModel(String name) {
		ArchitectureVersion baseversion = ArchitectureModelFactoryFacade.createEmptyModel(name);

		BasicComponent client = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Client");
		BasicComponent server = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Server");
		BasicComponent database = ArchitectureModelFactoryFacade.createBasicComponent(baseversion, "Database");
		
		OperationInterface clientInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ClientInterface");
		OperationInterface serverInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "ServerInterface");
		OperationInterface databaseInterface = ArchitectureModelFactoryFacade.createInterface(baseversion, "DatabaseInterface");
		
		ArchitectureModelFactoryFacade.createProvidedRole(client, clientInterface);
		ArchitectureModelFactoryFacade.createRequiredRole(client, serverInterface);

		ArchitectureModelFactoryFacade.createProvidedRole(server, serverInterface);
		ArchitectureModelFactoryFacade.createRequiredRole(server, databaseInterface);

		ArchitectureModelFactoryFacade.createProvidedRole(database, databaseInterface);

		ArchitectureModelFactoryFacade.createAssemblyContext(client, baseversion);
		ArchitectureModelFactoryFacade.createAssemblyContext(server, baseversion);
		ArchitectureModelFactoryFacade.createAssemblyContext(database, baseversion);
		
		//ArchitectureModelFactoryFacade.createAssemblyConnector(server, client, baseversion);
		
		return baseversion;
	}
	
	@After
	public void tearDown() {
		baseArchitectureVersion.delete();
		targetArchitectureVersion.delete();
		baseArchitectureVersion = null;
		targetArchitectureVersion = null;
	}
	
	@Test 
	public void testInternalModificationMark_CreationAndLookUp() {
		BasicComponent client = (BasicComponent)ArchitectureModelLookup.lookUpComponentByName(baseArchitectureVersion, "Client");
		
		ArchitectureModelFactoryFacade.assignInternalModificationMarkToComponent(baseArchitectureVersion, client);

		InternalModificationMark internalModificationMark = ArchitectureModelLookup.lookUpInternalModificationMarkForComponent(baseArchitectureVersion, client);
		
		assertTrue("InternalModificationMark not found", internalModificationMark!=null);	
		assertTrue("InternalModificationMark not assigned to expected component", internalModificationMark.getComponent()==client);	
	
		BasicComponent server = (BasicComponent)ArchitectureModelLookup.lookUpComponentByName(baseArchitectureVersion, "Server");
		InternalModificationMark internalModificationMarkServer = ArchitectureModelLookup.lookUpInternalModificationMarkForComponent(baseArchitectureVersion, server);
		assertTrue("Lookup of missing internal modification mark not resulted in null", internalModificationMarkServer==null);	
	}

}
