package edu.kit.ipd.sdq.kamp.core;

import java.util.ArrayList;
import java.util.List;

import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.repository.OperationSignature;
import de.uka.ipd.sdq.pcm.repository.ProvidedRole;
import de.uka.ipd.sdq.pcm.repository.RequiredRole;

public class SubactivityDerivation {
	public static List<Activity> deriveSubactivities(BasicComponent basicComponent, BasicActivity basicActivity) {
		List<Activity> workplan = new ArrayList<Activity>();
		
		for (ProvidedRole providedRole : basicComponent.getProvidedRoles_InterfaceProvidingEntity()) {
			Activity newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.PROVIDEDROLE, providedRole.getEntityName(), basicActivity, basicActivity +" provided role");
			workplan.add(newActivity);
			newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities((OperationProvidedRole) providedRole, basicActivity));
		}

		for (RequiredRole requiredRole : basicComponent.getRequiredRoles_InterfaceRequiringEntity()) {
			Activity newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.REQUIREDROLE, requiredRole.getEntityName(), basicActivity, basicActivity +" required role");
			workplan.add(newActivity);
			newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities((OperationRequiredRole) requiredRole, basicActivity));
		}

		return workplan;
	}

	public static List<Activity> deriveSubactivities(OperationInterface operationInterface, BasicActivity basicActivity) {
		List<Activity> workplan = new ArrayList<Activity>();
		
		for (OperationSignature operationSignature : operationInterface.getSignatures__OperationInterface()) {
			workplan.add(new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.INTERFACESIGNATURE, operationSignature.getEntityName(), basicActivity, basicActivity +" interface signature"));
		}

		return workplan;
	}

	public static List<Activity> deriveSubactivities(OperationProvidedRole providedRole, BasicActivity basicActivity) {
		List<Activity> workplan = new ArrayList<Activity>();
		
		for (OperationSignature operationSignature : providedRole.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface()) {
			workplan.add(new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.PROVIDEDOPERATION, operationSignature.getEntityName(), basicActivity, basicActivity +" provided operation"));
		}

		return workplan;
	}
	
	public static List<Activity> deriveSubactivities(OperationRequiredRole requiredRole, BasicActivity basicActivity) {
		List<Activity> workplan = new ArrayList<Activity>();
		
		for (OperationSignature operationSignature : requiredRole.getRequiredInterface__OperationRequiredRole().getSignatures__OperationInterface()) {
			workplan.add(new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.REQUIREDOPERATION, operationSignature.getEntityName(), basicActivity, basicActivity +" required operation"));
		}

		return workplan;
	}

}
