package edu.kit.ipd.sdq.kamp.core;

import java.util.ArrayList;
import java.util.List;

public class EnrichedWorkplanDerivation {
	public static List<Activity> deriveEnrichedWorkplan(
			ArchitectureVersion baseArchitectureVersion,
			ArchitectureVersion subVersion, List<Activity> baseActivityList) {

		// derive coding activities
		deriveCodingActivities(calculateFlattenendActivityList(baseActivityList));

		// derive build configuration activities
		deriveBuildConfigurationActivities(calculateFlattenendActivityList(baseActivityList));

		// derive build execution activities
		deriveBuildExecutionActivities(calculateFlattenendActivityList(baseActivityList));
		
		// component interface tests
		// derive test development activities 
		deriveTestDevelopmentActivities(calculateFlattenendActivityList(baseActivityList));
		
		// derive test execution activities
		deriveTestExecutionActivities(calculateFlattenendActivityList(baseActivityList));

		// component internal tests
		// integration tests
		
		// derive release configuration activities 
		deriveReleaseConfigurationActivities(calculateFlattenendActivityList(baseActivityList));		

		// derive release configuration activities 
		deriveReleaseExecutionActivities(calculateFlattenendActivityList(baseActivityList));		

		// derive deployment configuration activities
		deriveDeploymentConfigurationActivities(calculateFlattenendActivityList(baseActivityList));		

		// derive deployment execution activities
		deriveDeploymentExecutionActivities(calculateFlattenendActivityList(baseActivityList));		

		return baseActivityList;
	}

	public static List<Activity> calculateFlattenendActivityList(List<Activity> activityList) {
		List<Activity> flatActivityList = new ArrayList<Activity>();
		
		for (Activity activity : activityList) {
			flatActivityList.add(activity);
			if (!activity.getSubactivities().isEmpty()) {
				flatActivityList.addAll(activity.getSubactivities());
				flatActivityList.addAll(calculateFlattenendActivityList(activity.getSubactivities()));
			}
			if (!activity.getFollowupActivities().isEmpty()) {
				flatActivityList.addAll(activity.getFollowupActivities());
				flatActivityList.addAll(calculateFlattenendActivityList(activity.getFollowupActivities()));
			}
		}
		
		return flatActivityList;
	}

	private static void deriveCodingActivities(List<Activity> baseActivityList) {
		for (Activity activity : baseActivityList) {
			if (activity.getElementType() == ActivityElementType.COMPONENT && activity.getBasicActivity()==BasicActivity.ADD) {
				Activity newActivity = new Activity(ActivityType.IMPLEMENTATION_SOURCECODE, ActivityElementType.SOURCECODE, "source code", BasicActivity.ADD, "add source code");
				activity.addFollowupactivity(newActivity);
			} else if (activity.getElementType() == ActivityElementType.COMPONENT && activity.getBasicActivity()==BasicActivity.REMOVE) {
				Activity newActivity = new Activity(ActivityType.IMPLEMENTATION_SOURCECODE, ActivityElementType.SOURCECODE, "source code", BasicActivity.REMOVE, "remove source code");
				activity.addFollowupactivity(newActivity);
			} else if (activity.getElementType() == ActivityElementType.COMPONENT && activity.getBasicActivity()==BasicActivity.MODIFY) {
				Activity newActivity = new Activity(ActivityType.IMPLEMENTATION_SOURCECODE, ActivityElementType.SOURCECODE, "source code", BasicActivity.MODIFY, "modify source code");
				activity.addFollowupactivity(newActivity);
			}
		}
	}
	
	private static void deriveBuildConfigurationActivities(
			List<Activity> activityList) {
		// TODO: update build annotations
		for (Activity activity : activityList) {
			if (activity.getElementType() == ActivityElementType.SOURCECODE && activity.getBasicActivity()==BasicActivity.ADD) {
				Activity newActivity = new Activity(ActivityType.BUILDCONFIGURATION, ActivityElementType.BUILDCONFIGURATION, "buildconfiguration", BasicActivity.MODIFY, "modify build configuration "+activity.getElementName());
				activity.addFollowupactivity(newActivity);
			} else if (activity.getElementType() == ActivityElementType.SOURCECODE && activity.getBasicActivity()==BasicActivity.MODIFY) {
				Activity newActivity = new Activity(ActivityType.BUILDCONFIGURATION, ActivityElementType.BUILDCONFIGURATION, "buildconfiguration", BasicActivity.MODIFY, "modify build configuration "+activity.getElementName());
				activity.addFollowupactivity(newActivity);
			} else if (activity.getElementType() == ActivityElementType.SOURCECODE && activity.getBasicActivity()==BasicActivity.REMOVE) {
				Activity newActivity = new Activity(ActivityType.BUILDCONFIGURATION, ActivityElementType.BUILDCONFIGURATION, "buildconfiguration", BasicActivity.MODIFY, "modify build configuration for "+activity.getElementName());
				activity.addFollowupactivity(newActivity);
			}
		}
	}

	
	private static void deriveBuildExecutionActivities(
			List<Activity> activityList) {
		for (Activity activity : activityList) {
			if (activity.getElementType() == ActivityElementType.SOURCECODE && activity.getBasicActivity()==BasicActivity.ADD) {
				Activity newActivity = new Activity(ActivityType.BUILDEXECUTION, ActivityElementType.BUILDCONFIGURATION, "buildconfiguration", BasicActivity.EXECUTE, "execute build");
				activity.addFollowupactivity(newActivity);
			} else if (activity.getElementType() == ActivityElementType.SOURCECODE && activity.getBasicActivity()==BasicActivity.MODIFY) {
				Activity newActivity = new Activity(ActivityType.BUILDEXECUTION, ActivityElementType.BUILDCONFIGURATION, "buildconfiguration", BasicActivity.EXECUTE, "execute build");
				activity.addFollowupactivity(newActivity);
			}
		}
	}
	
	private static void deriveTestDevelopmentActivities(
			List<Activity> baseActivityList) {
		// TODO: update test annotations
		for (Activity activity : baseActivityList) {
			if (activity.getElementType() == ActivityElementType.PROVIDEDROLE && activity.getBasicActivity()==BasicActivity.ADD) {
				Activity newActivity = new Activity(ActivityType.TESTDEVELOPMENT, ActivityElementType.TESTCASE, "test case", BasicActivity.ADD, "add test case for added provided role");
				activity.addFollowupactivity(newActivity);
			} else if (activity.getElementType() == ActivityElementType.PROVIDEDROLE && activity.getBasicActivity()==BasicActivity.REMOVE) {
				Activity newActivity = new Activity(ActivityType.TESTDEVELOPMENT, ActivityElementType.TESTCASE, "test case", BasicActivity.REMOVE, "remove test case for removed provided role");
				activity.addFollowupactivity(newActivity);
			} else if (activity.getElementType() == ActivityElementType.PROVIDEDROLE && activity.getBasicActivity()==BasicActivity.MODIFY) {
				Activity newActivity = new Activity(ActivityType.TESTDEVELOPMENT, ActivityElementType.TESTCASE, "test case", BasicActivity.CHECKANDUPDATE, "check and update test cases for provided role");
				activity.addFollowupactivity(newActivity);
			}
		}
	}
	
	private static void deriveTestExecutionActivities(
			List<Activity> baseActivityList) {
		// TODO: use test annotations for refinement
		for (Activity activity : baseActivityList) {
			if (activity.getElementType() == ActivityElementType.PROVIDEDROLE && activity.getBasicActivity()==BasicActivity.ADD) {
				Activity newActivity = new Activity(ActivityType.TESTEXECUTION, ActivityElementType.TESTCASE, "test case", BasicActivity.EXECUTE, "execute test case(s)");
				activity.addFollowupactivity(newActivity);
			} else if (activity.getElementType() == ActivityElementType.PROVIDEDROLE && activity.getBasicActivity()==BasicActivity.REMOVE) {
				Activity newActivity = new Activity(ActivityType.TESTEXECUTION, ActivityElementType.TESTCASE, "test case", BasicActivity.EXECUTE, "execute test case(s)");
				activity.addFollowupactivity(newActivity);
			} else if (activity.getElementType() == ActivityElementType.PROVIDEDROLE && activity.getBasicActivity()==BasicActivity.MODIFY) {
				Activity newActivity = new Activity(ActivityType.TESTEXECUTION, ActivityElementType.TESTCASE, "test case", BasicActivity.EXECUTE, "execute test case(s)");
				activity.addFollowupactivity(newActivity);
			}
		}
	}

	private static void deriveReleaseConfigurationActivities(
			List<Activity> baseActivityList) {
		// TODO: update release annotations
		for (Activity activity : baseActivityList) {
			if (activity.getElementType() == ActivityElementType.BUILDCONFIGURATION && activity.getBasicActivity()==BasicActivity.MODIFY) {
				Activity newActivity = new Activity(ActivityType.RELEASECONFIGURATION, ActivityElementType.RELEASECONFIGURATION, "release configuration", BasicActivity.MODIFY, "modify release configuration");
				activity.addFollowupactivity(newActivity);
			} 
		}
	}

	private static void deriveReleaseExecutionActivities(
			List<Activity> baseActivityList) {
		// TODO: update release annotations
		for (Activity activity : baseActivityList) {
			if (activity.getElementType() == ActivityElementType.BUILDCONFIGURATION && activity.getBasicActivity()==BasicActivity.EXECUTE) {
				Activity newActivity = new Activity(ActivityType.RELEASEEXECUTION, ActivityElementType.RELEASECONFIGURATION, "release configuration", BasicActivity.EXECUTE, "execute release configuration");
				activity.addFollowupactivity(newActivity);
			} 
		}
	}
	
	private static void deriveDeploymentConfigurationActivities(
			List<Activity> baseActivityList) {
		for (Activity activity : baseActivityList) {
			if (activity.getType()==ActivityType.RELEASEEXECUTION && activity.getBasicActivity()==BasicActivity.EXECUTE) {
				Activity newActivity = new Activity(ActivityType.DEPLOYMENTCONFIGURATION, ActivityElementType.DEPLOYMENTCONFIGURATION, "deployment configuration", BasicActivity.MODIFY, "modify deployment configuration");
				activity.addFollowupactivity(newActivity);
			} 
		}
	}

	private static void deriveDeploymentExecutionActivities(
			List<Activity> baseActivityList) {
		for (Activity activity : baseActivityList) {
			if (activity.getType()==ActivityType.RELEASEEXECUTION && activity.getBasicActivity()==BasicActivity.EXECUTE) {
				Activity newActivity = new Activity(ActivityType.DEPLOYMENTEXECUTION, ActivityElementType.DEPLOYMENTCONFIGURATION, "deployment configuration", BasicActivity.EXECUTE, "execute deployment");
				activity.addFollowupactivity(newActivity);
			} 
		}
	}
}
