package edu.kit.ipd.sdq.kamp.core;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.metamodel.DifferenceKind;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeLeftTarget;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.UpdateReference;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;

import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMark;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.repository.BasicComponent;
import de.uka.ipd.sdq.pcm.repository.ImplementationComponentType;
import de.uka.ipd.sdq.pcm.repository.OperationInterface;
import de.uka.ipd.sdq.pcm.repository.OperationProvidedRole;
import de.uka.ipd.sdq.pcm.repository.OperationRequiredRole;
import de.uka.ipd.sdq.pcm.repository.ProvidedRole;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import de.uka.ipd.sdq.pcm.repository.RequiredRole;
import de.uka.ipd.sdq.pcm.repository.Signature;

public class DifferenceCalculation {
	public static DiffModel calculateDiffModel(EObject source, EObject target) {
		MatchModel matchModel = null;
		try {
			matchModel = MatchService.doMatch(target, source, null);
		} catch (InterruptedException e) {
			throw new RuntimeException(e);
		}

		DiffModel diff = null;
		if (matchModel != null) {
			diff = DiffService.doDiff(matchModel);
		}
		
		return diff;
	}

	public static boolean checkDiffElement(DiffElement diffElement, Class diffElementType, DifferenceKind kind) {
		if ((diffElementType.isInstance(diffElement))&&(diffElement.getKind() == kind)) 
			return true;
		
		return false;
	}
	
	public static boolean checkUpdateReference(UpdateReference diffElement, Class leftElementType, Class leftTargetType) {
		if ((leftElementType.isInstance(diffElement.getLeftElement()))&&(leftTargetType.isInstance(diffElement.getLeftTarget()))) 
			return true;
		
		return false;
	}
	
	public static boolean checkModelElementChangeLeftTarget(ModelElementChangeLeftTarget diffElement, Class leftElementType) {
		if (leftElementType.isInstance(diffElement.getLeftElement())) 
			return true;
		
		return false;
	}
	
	public static boolean checkModelElementChangeRightTarget(ModelElementChangeRightTarget diffElement, Class leftElementType) {
		if (leftElementType.isInstance(diffElement.getRightElement())) 
			return true;
		
		return false;
	}
	
	
	public static boolean detectionRuleAddedBasicComponent(DiffElement diffElement) {
		if (checkDiffElement(diffElement, ModelElementChangeLeftTarget.class, DifferenceKind.ADDITION)
				&&checkModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement, BasicComponent.class))
			return true;
		
		return false;
	}
	
	public static boolean detectionRuleDeletedBasicComponent(DiffElement diffElement) {
		if (checkDiffElement(diffElement, ModelElementChangeRightTarget.class, DifferenceKind.DELETION)
				&&checkModelElementChangeRightTarget((ModelElementChangeRightTarget)diffElement, BasicComponent.class))
			return true;
		
		return false;
	}
	
	public static boolean detectionRuleAddedInterface(DiffElement diffElement) {
		if (checkDiffElement(diffElement, ModelElementChangeLeftTarget.class, DifferenceKind.ADDITION)
				&&checkModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement, OperationInterface.class))
			return true;
		
		return false;
	}
	
	public static boolean detectionRuleDeletedInterface(DiffElement diffElement) {
		if (checkDiffElement(diffElement, ModelElementChangeRightTarget.class, DifferenceKind.DELETION)
				&&checkModelElementChangeRightTarget((ModelElementChangeRightTarget)diffElement, OperationInterface.class))
			return true;
		
		return false;
	}
	
	public static boolean detectionRuleDeletedInterfaceForProvidedRole(DiffElement diffElement) {
		if (checkDiffElement(diffElement, UpdateReference.class, DifferenceKind.CHANGE)
				&&checkUpdateReference((UpdateReference)diffElement, ProvidedRole.class, OperationInterface.class))
			return true;
		
		return false;
	}

	public static boolean detectionRuleDeletedInterfaceForRequiredRole(DiffElement diffElement) {
		if (checkDiffElement(diffElement, UpdateReference.class, DifferenceKind.CHANGE)
				&&checkUpdateReference((UpdateReference)diffElement, RequiredRole.class, OperationInterface.class))
			return true;
		
		return false;
	}

	public static boolean detectionRuleAddedProvidedRole(DiffElement diffElement) {
		if (checkDiffElement(diffElement, ModelElementChangeLeftTarget.class, DifferenceKind.ADDITION)
				&&checkModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement, OperationProvidedRole.class))
			return true;
		
		return false;
	}
	
	public static boolean detectionRuleAddedRequiredRole(DiffElement diffElement) {
		if (checkDiffElement(diffElement, ModelElementChangeLeftTarget.class, DifferenceKind.ADDITION)
				&&checkModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement, OperationRequiredRole.class))
			return true;
		
		return false;
	}

	public static boolean detectionRuleDeletedProvidedRole(DiffElement diffElement) {
		if (checkDiffElement(diffElement, ModelElementChangeRightTarget.class, DifferenceKind.DELETION)
				&&checkModelElementChangeRightTarget((ModelElementChangeRightTarget)diffElement, OperationProvidedRole.class))
			return true;
		
		return false;
	}
	
	public static boolean detectionRuleDeletedRequiredRole(DiffElement diffElement) {
		if (checkDiffElement(diffElement, ModelElementChangeRightTarget.class, DifferenceKind.DELETION)
				&&checkModelElementChangeRightTarget((ModelElementChangeRightTarget)diffElement, OperationRequiredRole.class))
			return true;
		
		return false;
	}
	
	public static EObject retrieveArchitectureElement(DiffElement diffElement) {
		if (diffElement instanceof ModelElementChangeRightTarget) {
			return ((ModelElementChangeRightTarget)diffElement).getRightElement();
		} else if (diffElement instanceof ModelElementChangeLeftTarget) {
			return ((ModelElementChangeLeftTarget)diffElement).getLeftElement();
		} else if (diffElement instanceof UpdateReference) {
			return ((UpdateReference)diffElement).getLeftElement();
		} else {
			return null;
		}
	}
	
	public static List<DiffElement> foundAddedBasicComponent(DiffModel diff) {
		List<DiffElement> result = new ArrayList<DiffElement>();
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleAddedBasicComponent(diffElement)) {
				result.add(diffElement);
			}
		} 
		return result;
	}
	
	public static List<DiffElement> foundAddedInterface(DiffModel diff) {
		List<DiffElement> result = new ArrayList<DiffElement>();
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleAddedInterface(diffElement)) {
				result.add(diffElement);
			}
		} 
		return result;
	}
	
	public static List<DiffElement> foundDeletedBasicComponent(DiffModel diff) {
		List<DiffElement> result = new ArrayList<DiffElement>();
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleDeletedBasicComponent(diffElement)) {
				result.add(diffElement);
			}
		} 
		return result;
	}

	public static List<DiffElement> foundDeletedInterface(DiffModel diff) {
		List<DiffElement> result = new ArrayList<DiffElement>();
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleDeletedInterface(diffElement)) {
				result.add(diffElement);
			}
		} 
		return result;
	}

	public static List<DiffElement> foundDeletedInterfaceForProvidedRole(DiffModel diff) {
		List<DiffElement> result = new ArrayList<DiffElement>();
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleDeletedInterfaceForProvidedRole(diffElement)) {
				result.add(diffElement);
			}
		} 
		return result;
	}

	public static List<DiffElement> foundDeletedInterfaceForRequiredRole(DiffModel diff) {
		List<DiffElement> result = new ArrayList<DiffElement>();
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleDeletedInterfaceForRequiredRole(diffElement)) {
				result.add(diffElement);
			}
		} 
		return result;
	}

	public static List<DiffElement> foundAddedProvidedRole(DiffModel diff) {
		List<DiffElement> result = new ArrayList<DiffElement>();
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleAddedProvidedRole(diffElement)) {
				result.add(diffElement);
			}
		} 
		return result;
	}
	
	public static List<DiffElement> foundAddedRequiredRole(DiffModel diff) {
		List<DiffElement> result = new ArrayList<DiffElement>();
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleAddedRequiredRole(diffElement)) {
				result.add(diffElement);
			}
		} 
		return result;
	}
	
	public static List<DiffElement> foundDeletedProvidedRole(DiffModel diff) {
		List<DiffElement> result = new ArrayList<DiffElement>();
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleDeletedProvidedRole(diffElement)) {
				result.add(diffElement);
			}
		} 
		return result;
	}

	public static List<DiffElement> foundDeletedRequiredRole(DiffModel diff) {
		List<DiffElement> result = new ArrayList<DiffElement>();
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleDeletedRequiredRole(diffElement)) {
				result.add(diffElement);
			}
		} 
		return result;
	}

	public static List<Activity> deriveBaseWorkPlan(DiffModel diff) {
		List<Activity> workplan = new ArrayList<Activity>();
		
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleAddedInterface(diffElement)) {
				OperationInterface architectureElement = (OperationInterface)retrieveArchitectureElement(diffElement);
				Activity newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.INTERFACE, architectureElement.getEntityName(), BasicActivity.ADD, "add interface");
				workplan.add(newActivity);
				newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities(architectureElement, BasicActivity.ADD));
			} else if (detectionRuleDeletedInterface(diffElement)) {
				OperationInterface architectureElement = (OperationInterface)retrieveArchitectureElement(diffElement);
				Activity newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.INTERFACE, architectureElement.getEntityName(), BasicActivity.REMOVE, "remove interface");
				workplan.add(newActivity);
				newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities(architectureElement, BasicActivity.REMOVE));
			} else if (detectionRuleAddedBasicComponent(diffElement)) {
				BasicComponent architectureElement = (BasicComponent) retrieveArchitectureElement(diffElement);
				Activity newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.COMPONENT, architectureElement.getEntityName(), BasicActivity.ADD, "add component");
				workplan.add(newActivity);
				newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities(architectureElement, BasicActivity.ADD));
			} else if (detectionRuleDeletedBasicComponent(diffElement)) {
				BasicComponent architectureElement = (BasicComponent) retrieveArchitectureElement(diffElement);
				Activity newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.COMPONENT, architectureElement.getEntityName(), BasicActivity.REMOVE, "remove component");
				workplan.add(newActivity);
				newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities(architectureElement, BasicActivity.REMOVE));
			} else if (detectionRuleAddedProvidedRole(diffElement)) {
				OperationProvidedRole architectureElement = (OperationProvidedRole)retrieveArchitectureElement(diffElement);
				Activity newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.PROVIDEDROLE, architectureElement.getEntityName(), BasicActivity.ADD, "add provided role");
				workplan.add(newActivity);
				newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities(architectureElement, BasicActivity.ADD));
			} else if (detectionRuleDeletedProvidedRole(diffElement)) {
				OperationProvidedRole architectureElement = (OperationProvidedRole)retrieveArchitectureElement(diffElement);
				Activity newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.PROVIDEDROLE, architectureElement.getEntityName(), BasicActivity.REMOVE, "remove provided role");
				workplan.add(newActivity);
				newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities(architectureElement, BasicActivity.REMOVE));
			} else if (detectionRuleAddedRequiredRole(diffElement)) {
				OperationRequiredRole architectureElement = (OperationRequiredRole)retrieveArchitectureElement(diffElement);
				Activity newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.REQUIREDROLE, architectureElement.getEntityName(), BasicActivity.ADD, "add required role");
				workplan.add(newActivity);
				newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities(architectureElement, BasicActivity.REMOVE));
			} else if (detectionRuleDeletedRequiredRole(diffElement)) {
				OperationRequiredRole architectureElement = (OperationRequiredRole)retrieveArchitectureElement(diffElement);
				Activity newActivity = new Activity(ActivityType.ARCHITECTUREMODELDIFF, ActivityElementType.REQUIREDROLE, architectureElement.getEntityName(), BasicActivity.REMOVE, "remove required role");
				workplan.add(newActivity);
				newActivity.addSubactivities(SubactivityDerivation.deriveSubactivities(architectureElement, BasicActivity.REMOVE));
			}
		} 
	
		return workplan;
	}
	
	
//	private static EObject getReferenceTarget(DiffElement diffElement) {
//		
//		if (diffElement instanceof UpdateReference) {
//			return ((UpdateReference)diffElement).getLeftTarget();
//		} else if (diffElement instanceof ModelElementChangeLeftTarget) {
//			return ((ModelElementChangeLeftTarget)diffElement).getLeftElement();
//		}
//		
//		return null;
//	}

	public static List<DiffElement> foundAddedAssemblyConnector(DiffModel diff) {
		List<DiffElement> result = new ArrayList<DiffElement>();
		for (DiffElement diffElement : diff.getDifferences()) {
			if (detectionRuleAddedAssemblyConnector(diffElement)) {
				result.add(diffElement);
			}
		} 
		return result;
	}

	public static boolean detectionRuleAddedAssemblyConnector(
			DiffElement diffElement) {
		if (checkDiffElement(diffElement, ModelElementChangeLeftTarget.class, DifferenceKind.ADDITION)
				&&checkModelElementChangeLeftTarget((ModelElementChangeLeftTarget)diffElement, AssemblyConnector.class))
			return true;
		
		return false;
	}

	public static List<Activity> deriveWorkplan(
			ArchitectureVersion baseVersion,
			ArchitectureVersion targetVersion) {
		List<Activity> activityList = new ArrayList<Activity>();
		
		DiffModel repositoryDiff = calculateDiffModel(baseVersion.getRepository(), targetVersion.getRepository());
		DiffModel systemDiff = calculateDiffModel(baseVersion.getSystem(), targetVersion.getSystem());

		List<Activity> repositoryActivities = deriveBaseWorkPlan(repositoryDiff);
		activityList.addAll(repositoryActivities);

		List<Activity> systemActivities = deriveBaseWorkPlan(systemDiff);
		activityList.addAll(systemActivities);

		List<Activity> internalModificationActivities = deriveInternalModifications(targetVersion);
		activityList.addAll(internalModificationActivities);
		
		return activityList;
	}

	private static List<Activity> deriveInternalModifications(
			ArchitectureVersion targetVersion) {
		
		List<Activity> activityList = new ArrayList<Activity>();
		
		for (InternalModificationMark internalModificationMark : targetVersion.getInternalModificationMarkRepository().getInternalModificationMark()) {
			RepositoryComponent component = internalModificationMark.getComponent();
			List<ProvidedRole> providedRoles = internalModificationMark.getProvidedRole();
			List<Signature> signatures = internalModificationMark.getSignature();
			
			fixInternalModificationMark(internalModificationMark);
			
			if (component!=null) {
				Activity componentActivity = new Activity(ActivityType.INTERNALMODIFICATIONMARK, ActivityElementType.COMPONENT, component.getEntityName(), BasicActivity.MODIFY, "modify component (internally)");
				activityList.add(componentActivity);
				for (ProvidedRole providedRole : providedRoles) {
					Activity providedRoleActivity = new Activity(ActivityType.INTERNALMODIFICATIONMARK, ActivityElementType.PROVIDEDROLE, providedRole.getEntityName(), BasicActivity.MODIFY, "modify provided role (internally)");
					componentActivity.addSubactivity(providedRoleActivity);
					for (Signature signature : signatures) {
						Activity providedOperationActivity = new Activity(ActivityType.INTERNALMODIFICATIONMARK, ActivityElementType.PROVIDEDOPERATION, signature.getEntityName(), BasicActivity.MODIFY, "modify provided operation (internally)");
						providedRoleActivity.addSubactivity(providedOperationActivity);
					}
				}
			}
		}
		
		return activityList;
	}

	private static void fixInternalModificationMark(
			InternalModificationMark internalModificationMark) {
		if (internalModificationMark.getComponent()==null && internalModificationMark.getProvidedRole()!=null && !internalModificationMark.getProvidedRole().isEmpty()) {
			internalModificationMark.setComponent((RepositoryComponent) internalModificationMark.getProvidedRole().get(0).getProvidingEntity_ProvidedRole());
		}

		// TODO: ensure that provided roles for signatures are also specified 
//		for (Signature signature : internalModificationMark.getSignature()) {
//			boolean found = false;
//			for (ProvidedRole providedRole : internalModificationMark.getProvidedRole()) {
//				if (providedRole instanceof OperationProvidedRole) {
//					if (((OperationProvidedRole)providedRole).getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface().contains(signature)) {
//						found = true;
//					}
//				}
//			}
//			if (!found) {
//				
//			}
//		}
	}
	
}
