package edu.kit.ipd.sdq.kamp.core;

import java.util.ArrayList;
import java.util.List;

import de.uka.ipd.sdq.componentInternalDependencies.RoleToRoleDependency;
import de.uka.ipd.sdq.pcm.core.composition.AssemblyConnector;
import de.uka.ipd.sdq.pcm.repository.ProvidedRole;
import de.uka.ipd.sdq.pcm.repository.RepositoryComponent;
import de.uka.ipd.sdq.pcm.repository.RequiredRole;

/**
 * The change propagation analysis 
 * 1. determines a seed population of affected components (resp. provided roles)
 * 2. calculates in iterations:
 *    a) inter-component propagation
 *    b) intra-component propagation
 * 3. generates internal modification marks for affected elements
 * 
 * - elements which were already part of a seed population are not further investigated
 * 
 * 
 * @author stammel
 *
 */
public class ChangePropagationAnalysis {

	private List<RepositoryComponent> seedComponents;

	private List<RepositoryComponent> acceptedPropagationComponents;

	private List<RepositoryComponent> visitedComponents;

	private List<RepositoryComponent> excludedPropagationComponents;
	
	public ChangePropagationAnalysis() {
//		this.identifiedComponents = new ArrayList<RepositoryComponent>();
//		this.excludedComponents = new ArrayList<RepositoryComponent>();
	}
	
	/**
	 * affected required roles + component internal dependencies => affected provided roles
	 */
	public static List<ProvidedRole> calculateIntraComponentPropagation(List<RequiredRole> requiredRoles, List<RoleToRoleDependency> componentInternalDependencies) {
		List<ProvidedRole> affectedProvidedRoles = new ArrayList<ProvidedRole>();

		for (RequiredRole requiredRole : requiredRoles) 
			for (RoleToRoleDependency dependency : componentInternalDependencies) {
				if (dependency.getRequiredRole()==requiredRole) {
					affectedProvidedRoles.add(dependency.getProvidedRole());
				}
			}
		
		return affectedProvidedRoles;
	}

	/**
	 *  affected provided roles (of component A) + connectors => affected required roles of dependent components (B, C, ...)
	 */
	public static List<RequiredRole> calculateInterComponentPropagation(List<ProvidedRole> providedRoles, List<AssemblyConnector> assemblyConnectors) {
		List<RequiredRole> affectedRequiredRolesOfDependentComponent = new ArrayList<RequiredRole>();
		
		for (ProvidedRole providedRole : providedRoles) 
			for (AssemblyConnector assemblyConnector : assemblyConnectors) {
				if (assemblyConnector.getProvidedRole_AssemblyConnector()==providedRole) {
					affectedRequiredRolesOfDependentComponent.add(assemblyConnector.getRequiredRole_AssemblyConnector());
				}
			}
		
		return affectedRequiredRolesOfDependentComponent;
	}

}
