package edu.kit.ipd.sdq.kamp.core;

import java.io.IOException;
import java.util.Collections;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

import de.uka.ipd.sdq.componentInternalDependencies.ComponentInternalDependencyRepository;
import de.uka.ipd.sdq.fieldOfActivityAnnotations.FieldOfActivityAnnotationsRepository;
import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMarkRepository;
import de.uka.ipd.sdq.pcm.repository.Repository;
import de.uka.ipd.sdq.pcm.system.System;

public class ArchitectureVersionPersistency {
	public static void save(String nameprefix, ArchitectureVersion version) throws IOException {
		ResourceSet resourceSet = new ResourceSetImpl();
		String repositoryfilePath = nameprefix + ".repository";
		if (version.getRepository()!=null)
			ArchitectureVersionPersistency.saveEmfModelToResource(version.getRepository(), repositoryfilePath, resourceSet);		
		String systemfilePath = nameprefix + ".system";
		if (version.getSystem()!=null)
			ArchitectureVersionPersistency.saveEmfModelToResource(version.getSystem(), systemfilePath, resourceSet);		
		String fieldOfActivityRepositoryFilePath = nameprefix + ".fieldofactivityannotations";
		if (version.getFieldOfActivityRepository()!=null)
			ArchitectureVersionPersistency.saveEmfModelToResource(version.getFieldOfActivityRepository(), fieldOfActivityRepositoryFilePath, resourceSet);		
		String internalModFilePath = nameprefix + ".internalmodificationmarks";
		if (version.getInternalModificationMarkRepository()!=null)
			ArchitectureVersionPersistency.saveEmfModelToResource(version.getInternalModificationMarkRepository(), internalModFilePath, resourceSet);		
		String cidepfilePath = nameprefix + ".componentinternaldependencies";
		if (version.getComponentInternalDependencyRepository()!=null)
			ArchitectureVersionPersistency.saveEmfModelToResource(version.getComponentInternalDependencyRepository(), cidepfilePath, resourceSet);		
	}
	
	public static ArchitectureVersion load(String loadprefix, String versionname) throws IOException {
		ResourceSet loadResourceSet = new ResourceSetImpl();
		
		String repositoryfilePath = loadprefix + ".repository";
		String systemfilePath = loadprefix + ".system";
		String fieldOfActivityRepositoryFilePath = loadprefix + ".fieldofactivityannotations";
		String internalModFilePath = loadprefix + ".internalmodificationmarks";
		String cidepfilePath = loadprefix + ".componentinternaldependencies";

		Repository repository = (Repository)loadEmfModelFromResource(repositoryfilePath, loadResourceSet);
		System system = (System)loadEmfModelFromResource(systemfilePath, loadResourceSet);
		FieldOfActivityAnnotationsRepository fieldOfActivityRepository = (FieldOfActivityAnnotationsRepository)loadEmfModelFromResource(fieldOfActivityRepositoryFilePath, loadResourceSet);
		InternalModificationMarkRepository internalModificationMarkRepository = (InternalModificationMarkRepository)loadEmfModelFromResource(internalModFilePath, loadResourceSet);
		ComponentInternalDependencyRepository componentInternalDependencyRepository = (ComponentInternalDependencyRepository)loadEmfModelFromResource(cidepfilePath, loadResourceSet);
		
		return new ArchitectureVersion(versionname, repository, system, fieldOfActivityRepository, internalModificationMarkRepository, componentInternalDependencyRepository);
	}	
	
	private static void saveEmfModelToResource(EObject model, String filePath, ResourceSet resourceSet) {
        if (filePath != null) {
            URI saveURI = URI.createFileURI(filePath);
            Resource resource = resourceSet.createResource(saveURI);

            resource.getContents().add(model);

            try {
                resource.save(Collections.EMPTY_MAP);
            } catch (IOException e) {
                throw new RuntimeException("Saving of resource failed", e);
            } finally {

            }
        }
    }
	
	private static EObject loadEmfModelFromResource(String filePath, ResourceSet resourceSet) {
        if (filePath != null) {
            URI loadURI = URI.createFileURI(filePath);
            try {
				return ModelUtils.load(loadURI, resourceSet);
			} catch (IOException e) {
				throw new RuntimeException(e);
			}
        }
        return null;
    }
	
	public static ArchitectureVersion saveAsAndReload(
			ArchitectureVersion saveVersion, String targetname) {
		try {
			ArchitectureVersionPersistency.save(targetname, saveVersion);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}

		ArchitectureVersion loadVersion = null;
		try {
			loadVersion = ArchitectureVersionPersistency.load(targetname, targetname);
		} catch (IOException e) {
			throw new RuntimeException(e);
		}		
		
		return loadVersion;
	}
	
	public static ArchitectureVersion createArchitectureVersionClone(
			ArchitectureVersion baseversion, String targetname) {
		
		ArchitectureVersion targetversion = ArchitectureVersionPersistency.saveAsAndReload(baseversion, targetname);
		
		return targetversion;
	}
}
