package edu.kit.ipd.sdq.kamp.core;

import java.io.IOException;
import java.util.Collections;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.util.ModelUtils;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.uka.ipd.sdq.componentInternalDependencies.ComponentInternalDependencyRepository;
import de.uka.ipd.sdq.fieldOfActivityAnnotations.FieldOfActivityAnnotationsRepository;
import de.uka.ipd.sdq.internalmodificationmark.InternalModificationMarkRepository;
import de.uka.ipd.sdq.pcm.repository.Repository;
import de.uka.ipd.sdq.pcm.system.System;

public class ArchitectureVersion {
	private String name;
	private Repository repository;
	private de.uka.ipd.sdq.pcm.system.System system;
	private FieldOfActivityAnnotationsRepository fieldOfActivityRepository;
	private InternalModificationMarkRepository internalModificationMarkRepository;
	private ComponentInternalDependencyRepository componentInternalDependencyRepository;
	
	public ArchitectureVersion(
			String name,
			Repository repository,
			System system,
			FieldOfActivityAnnotationsRepository fieldOfActivityRepository,
			InternalModificationMarkRepository internalModificationMarkRepository,
			ComponentInternalDependencyRepository componentInternalDependencyRepository) {
		super();
		this.name = name;
		this.repository = repository;
		this.system = system;
		this.fieldOfActivityRepository = fieldOfActivityRepository;
		this.internalModificationMarkRepository = internalModificationMarkRepository;
		this.componentInternalDependencyRepository = componentInternalDependencyRepository;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Repository getRepository() {
		return repository;
	}

	public void setRepository(Repository repository) {
		this.repository = repository;
	}

	public de.uka.ipd.sdq.pcm.system.System getSystem() {
		return system;
	}

	public void setSystem(de.uka.ipd.sdq.pcm.system.System system) {
		this.system = system;
	}

	public FieldOfActivityAnnotationsRepository getFieldOfActivityRepository() {
		return fieldOfActivityRepository;
	}

	public void setFieldOfActivityRepository(
			FieldOfActivityAnnotationsRepository fieldOfActivityRepository) {
		this.fieldOfActivityRepository = fieldOfActivityRepository;
	}

	public InternalModificationMarkRepository getInternalModificationMarkRepository() {
		return internalModificationMarkRepository;
	}

	public void setInternalModificationMarkRepository(
			InternalModificationMarkRepository internalModificationMarkRepository) {
		this.internalModificationMarkRepository = internalModificationMarkRepository;
	}

	public ComponentInternalDependencyRepository getComponentInternalDependencyRepository() {
		return componentInternalDependencyRepository;
	}

	public void setComponentInternalDependencyRepository(
			ComponentInternalDependencyRepository componentInternalDependencyRepository) {
		this.componentInternalDependencyRepository = componentInternalDependencyRepository;
	}

	public void delete() {
		EcoreUtil.delete(this.getRepository(), true);
		EcoreUtil.delete(this.getSystem(), true);
		EcoreUtil.delete(this.getFieldOfActivityRepository(), true);
		EcoreUtil.delete(this.getInternalModificationMarkRepository(), true);
		EcoreUtil.delete(this.getComponentInternalDependencyRepository(), true);
	}

}
